/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.Session;
import com.aspectran.core.component.session.SessionHandler;
import java.util.Collections;
import java.util.Enumeration;

public class SessionAgent {
    private final SessionHandler sessionHandler;
    private volatile String sessionId;

    public SessionAgent(SessionHandler sessionHandler) {
        this.sessionHandler = sessionHandler;
    }

    public String getId() {
        return this.getSession(true).getId();
    }

    public long getCreationTime() {
        return this.getSession(true).getCreationTime();
    }

    public long getLastAccessedTime() {
        return this.getSession(true).getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.getSession(true).getMaxInactiveInterval();
    }

    public void setMaxInactiveInterval(int secs) {
        this.getSession(true).setMaxInactiveInterval(secs);
    }

    public Enumeration<String> getAttributeNames() {
        Session session = this.getSession(false);
        if (session == null) {
            return null;
        }
        return Collections.enumeration(session.getAttributeNames());
    }

    public <T> T getAttribute(String name) {
        Session session = this.getSession(false);
        if (session == null) {
            return null;
        }
        return session.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.getSession(true).setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        Session session = this.getSession(false);
        if (session != null) {
            session.removeAttribute(name);
        }
    }

    public Session getSession(boolean create) {
        if (this.sessionId == null && !create) {
            return null;
        }
        if (this.sessionId != null) {
            Session session = this.sessionHandler.getSession(this.sessionId);
            if (session == null && create) {
                session = this.createSession();
            }
            return session;
        }
        return this.createSession();
    }

    private Session createSession() {
        this.sessionId = this.sessionHandler.createSessionId(this.hashCode());
        return this.sessionHandler.createSession(this.sessionId);
    }

    public void invalidate() {
        Session session = this.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    public boolean isValid() {
        Session session = this.getSession(false);
        return session != null && session.isValid();
    }

    public boolean isNew() {
        Session session = this.getSession(false);
        return session == null || session.isNew();
    }

    public void access() {
        Session session = this.getSession(false);
        if (session != null) {
            session.access();
        }
    }

    public void complete() {
        Session session = this.getSession(false);
        if (session != null) {
            session.complete();
        }
    }
}

