/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.AbstractSessionHandler;
import com.aspectran.core.component.session.ManagedSession;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.utils.thread.AutoLock;
import com.aspectran.utils.thread.ThreadContextHelper;
import com.aspectran.utils.timer.CyclicTimeout;
import java.util.concurrent.TimeUnit;

public class SessionInactivityTimer {
    private static final Logger logger = LoggerFactory.getLogger(SessionInactivityTimer.class);
    private final ManagedSession session;
    private final CyclicTimeout timer;

    public SessionInactivityTimer(final @NonNull AbstractSessionHandler sessionHandler, final @NonNull ManagedSession session) {
        this.session = session;
        this.timer = new CyclicTimeout(sessionHandler.getScheduler()){

            @Override
            public void onTimeoutExpired() {
                if (logger.isTraceEnabled()) {
                    logger.trace("Timer expired for session " + session.getId());
                }
                long now = System.currentTimeMillis();
                try (AutoLock ignored = session.lock();){
                    if (session.getRequests() > 0L) {
                        return;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("Inspecting session " + session.getId() + ", valid=" + session.isValid());
                    }
                    if (!session.isValid()) {
                        return;
                    }
                    boolean expired = false;
                    try {
                        expired = ThreadContextHelper.call(sessionHandler.getClassLoader(), () -> sessionHandler.sessionInactivityTimerExpired(session, now));
                    }
                    catch (Exception e) {
                        logger.warn(e);
                    }
                    if (!expired && session.isResident()) {
                        SessionInactivityTimer.this.schedule(session.calculateInactivityTimeout(now));
                    }
                }
            }
        };
    }

    public void schedule(long time) {
        if (time >= 0L) {
            if (logger.isTraceEnabled()) {
                logger.trace("(Re)starting timer for session " + this.session.getId() + " at " + time + "ms");
            }
            this.timer.schedule(time, TimeUnit.MILLISECONDS);
        } else if (logger.isTraceEnabled()) {
            logger.trace("Not starting timer for session " + this.session.getId());
        }
    }

    public void cancel() {
        this.timer.cancel();
        if (logger.isTraceEnabled()) {
            logger.trace("Cancelled timer for session " + this.session.getId());
        }
    }

    public void destroy() {
        this.timer.destroy();
        if (logger.isTraceEnabled()) {
            logger.trace("Destroyed timer for session " + this.session.getId());
        }
    }
}

