/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.utils.statistic.CounterStatistic;
import com.aspectran.utils.statistic.SampleStatistic;
import java.util.concurrent.atomic.AtomicLong;

public class SessionStatistics {
    private final CounterStatistic activationCount = new CounterStatistic();
    private final AtomicLong creationCount = new AtomicLong();
    private final AtomicLong expirationCount = new AtomicLong();
    private final AtomicLong rejectionCount = new AtomicLong();
    private final SampleStatistic timeRecord = new SampleStatistic();
    private final AtomicLong startTime = new AtomicLong(System.currentTimeMillis());

    protected void sessionCreated() {
        this.creationCount.incrementAndGet();
    }

    protected void sessionCreated(long createdSessionsToAdd) {
        this.creationCount.addAndGet(createdSessionsToAdd);
    }

    protected void sessionExpired() {
        this.expirationCount.incrementAndGet();
    }

    protected void sessionActivated() {
        this.activationCount.increment();
    }

    protected void sessionInactivated() {
        this.activationCount.decrement();
    }

    protected void sessionRejected() {
        this.rejectionCount.incrementAndGet();
    }

    protected void recordTime(long sample) {
        this.timeRecord.record(sample);
    }

    protected void reset() {
        this.activationCount.reset();
        this.creationCount.set(0L);
        this.expirationCount.set(0L);
        this.rejectionCount.set(0L);
        this.timeRecord.reset();
        this.startTime.set(System.currentTimeMillis());
    }

    public long getNumberOfCreated() {
        return this.creationCount.get();
    }

    public long getNumberOfExpired() {
        return this.expirationCount.get();
    }

    public long getNumberOfActives() {
        return this.activationCount.getCurrent();
    }

    public long getHighestNumberOfActives() {
        return this.activationCount.getMax();
    }

    public long getNumberOfRejected() {
        return this.rejectionCount.get();
    }

    public long getNumberOfUnmanaged() {
        return this.getNumberOfCreated() - this.getNumberOfExpired() - this.getNumberOfActives();
    }

    public long getMaxSessionAliveTime() {
        return this.timeRecord.getMax();
    }

    public long getTotalSessionsAliveTime() {
        return this.timeRecord.getTotal();
    }

    public long getAverageSessionAliveTime() {
        return Math.round(this.timeRecord.getMean());
    }

    public double getStdDevSessionAliveTime() {
        return this.timeRecord.getStdDev();
    }

    public long getStartTime() {
        return this.startTime.get();
    }
}

