/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session.redis.lettuce;

import com.aspectran.core.component.session.AbstractSessionStore;
import com.aspectran.core.component.session.SessionData;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public abstract class AbstractLettuceSessionStore
extends AbstractSessionStore {
    protected abstract void scan(Consumer<SessionData> var1);

    @Override
    public Set<String> doGetExpired(long time) {
        HashSet<String> expired = new HashSet<String>();
        this.scan(sessionData -> {
            long expiry = sessionData.getExpiry();
            if (expiry > 0L && expiry <= time) {
                expired.add(sessionData.getId());
            }
        });
        return expired;
    }

    @Override
    public void doCleanOrphans(long time) {
    }

    @Override
    public Set<String> getAllSessions() {
        long now = System.currentTimeMillis();
        HashSet<String> all = new HashSet<String>();
        this.scan(sessionData -> {
            long expiry = sessionData.getExpiry();
            if (expiry <= 0L || expiry > now) {
                all.add(sessionData.getId());
            }
        });
        return all;
    }
}

