/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session.redis.lettuce;

import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.redis.lettuce.AbstractLettuceSessionStore;
import com.aspectran.core.component.session.redis.lettuce.ConnectionPool;
import com.aspectran.core.component.session.redis.lettuce.SessionDataCodec;
import com.aspectran.utils.annotation.jsr305.NonNull;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.ScanIterator;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.api.sync.RedisKeyCommands;
import java.util.function.Consumer;
import java.util.function.Function;

public class DefaultLettuceSessionStore
extends AbstractLettuceSessionStore {
    private final ConnectionPool<StatefulRedisConnection<String, SessionData>> pool;

    public DefaultLettuceSessionStore(ConnectionPool<StatefulRedisConnection<String, SessionData>> pool) {
        this.pool = pool;
    }

    @Override
    protected void doInitialize() throws Exception {
        SessionDataCodec codec = new SessionDataCodec(this.getNonPersistentAttributes());
        this.pool.initialize(codec);
    }

    @Override
    protected void doDestroy() throws Exception {
        this.pool.destroy();
    }

    private StatefulRedisConnection<String, SessionData> getConnection() {
        try {
            return this.pool.getConnection();
        }
        catch (Exception e) {
            throw RedisConnectionException.create((Throwable)e);
        }
    }

    <R> R sync(@NonNull Function<RedisCommands<String, SessionData>, R> func) {
        try (StatefulRedisConnection<String, SessionData> conn = this.getConnection();){
            R r = func.apply((RedisCommands<String, SessionData>)conn.sync());
            return r;
        }
    }

    @Override
    public void scan(Consumer<SessionData> func) {
        this.sync(c -> {
            ScanIterator scanIterator = ScanIterator.scan((RedisKeyCommands)c);
            while (scanIterator.hasNext()) {
                String key = (String)scanIterator.next();
                SessionData data = (SessionData)c.get((Object)key);
                func.accept(data);
            }
            return null;
        });
    }

    @Override
    public SessionData load(String id) {
        return this.sync(c -> (SessionData)c.get((Object)id));
    }

    @Override
    public boolean delete(String id) {
        return this.sync(c -> {
            Long deleted = c.del((Object[])new String[]{id});
            return deleted != null && deleted > 0L;
        });
    }

    @Override
    public boolean exists(String id) {
        long now = System.currentTimeMillis();
        return this.sync(c -> this.checkExpiry((SessionData)c.get((Object)id), now));
    }

    @Override
    public void doSave(String id, SessionData data) {
        this.sync(c -> c.set((Object)id, (Object)data));
    }
}

