/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session.redis.lettuce;

import com.aspectran.core.component.session.SessionData;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.ToStringBuilder;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class RedisConnectionPoolConfig
extends GenericObjectPoolConfig<StatefulRedisConnection<String, SessionData>> {
    private RedisURI redisURI;
    private ClientOptions clientOptions;

    public RedisURI getRedisURI() {
        return this.redisURI;
    }

    public void setRedisURI(RedisURI redisURI) {
        if (redisURI == null) {
            throw new IllegalArgumentException("redisURI must not be null");
        }
        this.redisURI = redisURI;
    }

    public void setUri(String uri) {
        if (!StringUtils.hasText(uri)) {
            throw new IllegalArgumentException("uri must not be null or empty");
        }
        this.redisURI = RedisURI.create((String)uri);
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public void setClientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("redisURI", this.redisURI);
        tsb.append("clientOptions", this.clientOptions);
        return tsb.toString();
    }
}

