/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session.redis.lettuce.cluster;

import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.redis.lettuce.ConnectionPool;
import com.aspectran.core.component.session.redis.lettuce.SessionDataCodec;
import com.aspectran.core.component.session.redis.lettuce.cluster.RedisClusterConnectionPoolConfig;
import com.aspectran.utils.Assert;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.support.ConnectionPoolSupport;
import java.util.Arrays;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class RedisClusterConnectionPool
implements ConnectionPool<StatefulRedisClusterConnection<String, SessionData>> {
    private final RedisClusterConnectionPoolConfig poolConfig;
    private RedisClusterClient client;
    private GenericObjectPool<StatefulRedisClusterConnection<String, SessionData>> pool;

    public RedisClusterConnectionPool(RedisClusterConnectionPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
    }

    @Override
    public StatefulRedisClusterConnection<String, SessionData> getConnection() throws Exception {
        Assert.state(this.pool != null, "No RedisClusterConnectionPool configured");
        return (StatefulRedisClusterConnection)this.pool.borrowObject();
    }

    @Override
    public void initialize(SessionDataCodec codec) {
        Assert.state(this.pool == null, "RedisClusterConnectionPool is already configured");
        RedisURI[] redisURIs = this.poolConfig.getRedisURIs();
        if (redisURIs == null || redisURIs.length == 0) {
            throw new IllegalArgumentException("redisURIs must not be null or empty");
        }
        this.client = RedisClusterClient.create(Arrays.asList(redisURIs));
        if (this.poolConfig.getClusterClientOptions() != null) {
            this.client.setOptions(this.poolConfig.getClusterClientOptions());
        }
        this.pool = ConnectionPoolSupport.createGenericObjectPool(() -> this.client.connect((RedisCodec)codec), (GenericObjectPoolConfig)this.poolConfig);
    }

    @Override
    public void destroy() {
        if (this.pool != null) {
            this.pool.close();
        }
        if (this.client != null) {
            this.client.shutdown();
        }
    }
}

