/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session.redis.lettuce.masterreplica;

import com.aspectran.core.component.session.SessionData;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.ToStringBuilder;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import java.util.Arrays;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class RedisMasterReplicaConnectionPoolConfig
extends GenericObjectPoolConfig<StatefulRedisConnection<String, SessionData>> {
    private RedisURI[] redisURIs;
    private ClientOptions clientOptions;

    public RedisURI[] getRedisURIs() {
        return this.redisURIs;
    }

    public void setRedisURIs(RedisURI ... redisURIs) {
        if (redisURIs == null || redisURIs.length == 0) {
            throw new IllegalArgumentException("redisURIs must not be null or empty");
        }
        this.redisURIs = redisURIs;
    }

    public void setNodes(String[] nodes) {
        if (nodes == null || nodes.length == 0) {
            throw new IllegalArgumentException("nodes must not be null or empty");
        }
        this.redisURIs = (RedisURI[])Arrays.stream(nodes).map(RedisURI::create).toArray(RedisURI[]::new);
    }

    public void setUri(String uri) {
        if (!StringUtils.hasText(uri)) {
            throw new IllegalArgumentException("uri must not be null or empty");
        }
        RedisURI redisURI = RedisURI.create((String)uri);
        this.redisURIs = new RedisURI[]{redisURI};
    }

    public ClientOptions getClientOptions() {
        return this.clientOptions;
    }

    public void setClientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("redisURIs", this.redisURIs);
        tsb.append("clientOptions", this.clientOptions);
        return tsb.toString();
    }
}

