/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.template;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.InstantActivity;
import com.aspectran.core.activity.InstantActivityException;
import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.template.TemplateNotFoundException;
import com.aspectran.core.component.template.TemplateRenderer;
import com.aspectran.core.component.template.TemplateRenderingException;
import com.aspectran.core.component.template.TemplateRuleRegistry;
import com.aspectran.core.component.template.engine.TemplateEngine;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.asel.token.Token;
import com.aspectran.core.context.rule.TemplateRule;
import com.aspectran.utils.Assert;
import java.io.Writer;

public class DefaultTemplateRenderer
extends AbstractComponent
implements TemplateRenderer {
    private final ActivityContext context;
    private final TemplateRuleRegistry templateRuleRegistry;

    public DefaultTemplateRenderer(ActivityContext context, TemplateRuleRegistry templateRuleRegistry) {
        Assert.notNull((Object)context, "context must not be null");
        Assert.notNull((Object)templateRuleRegistry, "templateRuleRegistry must not be null");
        this.context = context;
        this.templateRuleRegistry = templateRuleRegistry;
    }

    @Override
    public String render(String templateId) {
        try {
            InstantActivity activity = new InstantActivity(this.context);
            return activity.perform(() -> {
                this.render(templateId, (Activity)activity);
                return activity.getResponseAdapter().getWriter().toString();
            });
        }
        catch (Exception e) {
            throw new InstantActivityException(e);
        }
    }

    @Override
    public void render(String templateId, Activity activity) {
        Assert.notNull((Object)templateId, "templateId must not be null");
        TemplateRule templateRule = this.templateRuleRegistry.getTemplateRule(templateId);
        if (templateRule == null) {
            throw new TemplateNotFoundException(templateId);
        }
        this.render(templateRule, activity);
    }

    @Override
    public void render(TemplateRule templateRule, Activity activity) {
        try {
            Assert.notNull((Object)templateRule, "templateRule must not be null");
            Assert.notNull((Object)activity, "activity must not be null");
            Writer writer = null;
            if (activity.getResponseAdapter() != null) {
                writer = activity.getResponseAdapter().getWriter();
            }
            if (writer == null) {
                throw new IllegalStateException("No such writer to transfer the output string");
            }
            if (templateRule.isExternalEngine()) {
                TemplateEngine engine = null;
                if (templateRule.getEngineBeanClass() != null) {
                    engine = (TemplateEngine)activity.getBean(templateRule.getEngineBeanClass());
                } else if (templateRule.getEngineBeanId() != null) {
                    engine = (TemplateEngine)activity.getBean(templateRule.getEngineBeanId());
                }
                if (engine == null) {
                    throw new IllegalArgumentException("No template engine bean named '" + templateRule.getEngine() + "'");
                }
                if (templateRule.isOutsourcing()) {
                    String templateName = templateRule.getName();
                    engine.process(templateName, activity);
                } else {
                    String templateSource = templateRule.getTemplateSource(this.context);
                    if (templateSource != null) {
                        String contentType = templateRule.getContentType();
                        if (contentType == null && activity.getResponseAdapter() != null) {
                            contentType = activity.getResponseAdapter().getContentType();
                        }
                        engine.process(templateSource, contentType, activity);
                    }
                }
            } else {
                Token[] templateTokens = templateRule.getTemplateTokens(this.context);
                if (templateTokens != null) {
                    activity.getTokenEvaluator().evaluate(templateTokens, writer);
                } else {
                    writer.write(templateRule.getTemplateSource(this.context));
                }
            }
        }
        catch (Exception e) {
            throw new TemplateRenderingException("An error occurred during rendering of the template", templateRule, e);
        }
    }

    @Override
    protected void doInitialize() throws Exception {
        this.templateRuleRegistry.initialize();
    }

    @Override
    protected void doDestroy() {
        this.templateRuleRegistry.destroy();
    }
}

