/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.DefaultActivity;
import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.aspect.AspectRuleRegistry;
import com.aspectran.core.component.bean.BeanRegistry;
import com.aspectran.core.component.bean.DefaultBeanRegistry;
import com.aspectran.core.component.schedule.ScheduleRuleRegistry;
import com.aspectran.core.component.template.DefaultTemplateRenderer;
import com.aspectran.core.component.template.TemplateRenderer;
import com.aspectran.core.component.translet.TransletRuleRegistry;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.InactivityStateException;
import com.aspectran.core.context.env.ActivityEnvironment;
import com.aspectran.core.context.env.Environment;
import com.aspectran.core.context.rule.DescriptionRule;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.support.i18n.message.DelegatingMessageSource;
import com.aspectran.core.support.i18n.message.MessageSource;
import com.aspectran.utils.Assert;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.utils.thread.ThreadContextHelper;

public class DefaultActivityContext
extends AbstractComponent
implements ActivityContext {
    private static final Logger logger = LoggerFactory.getLogger(DefaultActivityContext.class);
    private final ThreadLocal<Activity> currentActivityHolder = new ThreadLocal();
    private final ClassLoader classLoader;
    private final ApplicationAdapter applicationAdapter;
    private final Activity defaultActivity;
    private String name;
    private DescriptionRule descriptionRule;
    private CoreService masterService;
    private ActivityEnvironment activityEnvironment;
    private AspectRuleRegistry aspectRuleRegistry;
    private DefaultBeanRegistry defaultBeanRegistry;
    private DefaultTemplateRenderer defaultTemplateRenderer;
    private ScheduleRuleRegistry scheduleRuleRegistry;
    private TransletRuleRegistry transletRuleRegistry;
    private MessageSource messageSource;

    public DefaultActivityContext(ClassLoader classLoader, ApplicationAdapter applicationAdapter) {
        this.classLoader = classLoader;
        this.applicationAdapter = applicationAdapter;
        this.defaultActivity = new DefaultActivity(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.checkInitializable();
        this.name = name;
    }

    public DescriptionRule getDescriptionRule() {
        return this.descriptionRule;
    }

    public void setDescriptionRule(DescriptionRule descriptionRule) {
        this.checkInitializable();
        this.descriptionRule = descriptionRule;
    }

    @Override
    public String getDescription() {
        if (this.descriptionRule != null) {
            return DescriptionRule.render(this.descriptionRule, this.defaultActivity);
        }
        return null;
    }

    @Override
    public CoreService getMasterService() {
        return this.masterService;
    }

    @Override
    public void setMasterService(CoreService masterService) {
        this.checkInitializable();
        this.masterService = masterService;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public ApplicationAdapter getApplicationAdapter() {
        return this.applicationAdapter;
    }

    @Override
    public Environment getEnvironment() {
        return this.activityEnvironment;
    }

    public void setActivityEnvironment(ActivityEnvironment activityEnvironment) {
        this.checkInitializable();
        this.activityEnvironment = activityEnvironment;
    }

    @Override
    public AspectRuleRegistry getAspectRuleRegistry() {
        return this.aspectRuleRegistry;
    }

    public void setAspectRuleRegistry(AspectRuleRegistry aspectRuleRegistry) {
        this.checkInitializable();
        this.aspectRuleRegistry = aspectRuleRegistry;
    }

    @Override
    public BeanRegistry getBeanRegistry() {
        return this.defaultBeanRegistry;
    }

    public void setDefaultBeanRegistry(DefaultBeanRegistry defaultBeanRegistry) {
        this.checkInitializable();
        this.defaultBeanRegistry = defaultBeanRegistry;
    }

    @Override
    public TemplateRenderer getTemplateRenderer() {
        return this.defaultTemplateRenderer;
    }

    public void setDefaultTemplateRenderer(DefaultTemplateRenderer defaultTemplateRenderer) {
        this.checkInitializable();
        this.defaultTemplateRenderer = defaultTemplateRenderer;
    }

    @Override
    public ScheduleRuleRegistry getScheduleRuleRegistry() {
        return this.scheduleRuleRegistry;
    }

    public void setScheduleRuleRegistry(ScheduleRuleRegistry scheduleRuleRegistry) {
        this.checkInitializable();
        this.scheduleRuleRegistry = scheduleRuleRegistry;
    }

    @Override
    public TransletRuleRegistry getTransletRuleRegistry() {
        return this.transletRuleRegistry;
    }

    public void setTransletRuleRegistry(TransletRuleRegistry transletRuleRegistry) {
        this.checkInitializable();
        this.transletRuleRegistry = transletRuleRegistry;
    }

    @Override
    public MessageSource getMessageSource() {
        if (this.messageSource == null) {
            this.resolveMessageSource();
        }
        return this.messageSource;
    }

    @Override
    public Activity getDefaultActivity() {
        return this.defaultActivity;
    }

    @Override
    public Activity getAvailableActivity() {
        Activity activity = this.currentActivityHolder.get();
        return activity != null ? activity : this.getDefaultActivity();
    }

    @Override
    public Activity getCurrentActivity() {
        Activity activity = this.currentActivityHolder.get();
        if (activity == null) {
            throw new InactivityStateException();
        }
        return activity;
    }

    @Override
    public void setCurrentActivity(Activity activity) {
        this.currentActivityHolder.set(activity);
    }

    @Override
    public void removeCurrentActivity() {
        this.currentActivityHolder.remove();
    }

    @Override
    public boolean hasCurrentActivity() {
        return this.currentActivityHolder.get() != null;
    }

    private void resolveMessageSource() {
        if (this.defaultBeanRegistry.containsBean(MessageSource.class, "messageSource")) {
            this.messageSource = this.defaultBeanRegistry.getBean(MessageSource.class, "messageSource");
            if (logger.isDebugEnabled()) {
                logger.debug("Using MessageSource [" + String.valueOf(this.messageSource) + "]");
            }
        }
        if (this.messageSource == null) {
            this.messageSource = new DelegatingMessageSource();
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to locate MessageSource with name 'messageSource': using default [" + String.valueOf(this.messageSource) + "]");
            }
        }
    }

    @Override
    protected void doInitialize() throws Exception {
        Assert.state(this.aspectRuleRegistry != null, "AspectRuleRegistry is not set");
        Assert.state(this.defaultBeanRegistry != null, "BeanRegistry is not set");
        Assert.state(this.defaultTemplateRenderer != null, "TemplateRenderer is not set");
        Assert.state(this.scheduleRuleRegistry != null, "ScheduleRuleRegistry is not set");
        Assert.state(this.transletRuleRegistry != null, "TransletRuleRegistry is not set");
        ThreadContextHelper.runThrowable(this.getClassLoader(), () -> {
            this.aspectRuleRegistry.initialize();
            this.defaultBeanRegistry.initialize();
            this.defaultTemplateRenderer.initialize();
            this.scheduleRuleRegistry.initialize();
            this.transletRuleRegistry.initialize();
            this.resolveMessageSource();
        });
    }

    @Override
    protected void doDestroy() {
        ThreadContextHelper.run(this.getClassLoader(), () -> {
            if (this.transletRuleRegistry != null) {
                this.transletRuleRegistry.destroy();
                this.transletRuleRegistry = null;
            }
            if (this.scheduleRuleRegistry != null) {
                this.scheduleRuleRegistry.destroy();
                this.scheduleRuleRegistry = null;
            }
            if (this.defaultTemplateRenderer != null) {
                this.defaultTemplateRenderer.destroy();
                this.defaultTemplateRenderer = null;
            }
            if (this.defaultBeanRegistry != null) {
                this.defaultBeanRegistry.destroy();
                this.defaultBeanRegistry = null;
            }
            if (this.aspectRuleRegistry != null) {
                this.aspectRuleRegistry.destroy();
                this.aspectRuleRegistry = null;
            }
        });
    }
}

