/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.asel;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.context.asel.ExpressionEvaluationException;
import com.aspectran.core.context.asel.ExpressionEvaluator;
import com.aspectran.core.context.asel.ExpressionParserException;
import com.aspectran.core.context.asel.token.Token;
import com.aspectran.core.context.asel.token.TokenEvaluator;
import com.aspectran.core.context.asel.token.TokenParser;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.utils.Assert;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;

public class TokenizedExpression
implements ExpressionEvaluator {
    private static final String TOKEN_VAR_REF_SYMBOL = "#";
    private static final String TOKEN_VAR_NAME_PREFIX = "__";
    private static final String TOKEN_VAR_NAME_SUFFIX = "__";
    private final String expression;
    private String substitutedExpression;
    private Object parsedExpression;
    private Token[] tokens;
    private Map<String, Token> tokenVars;
    private Set<String> tokenVarNames;

    public TokenizedExpression(String expression) throws ExpressionParserException {
        this.expression = expression;
        this.parseExpression();
    }

    @Override
    @Nullable
    public String getExpressionString() {
        return this.expression;
    }

    @Override
    @Nullable
    public String getSubstitutedExpression() {
        return this.substitutedExpression;
    }

    @Override
    @Nullable
    public Object getParsedExpression() {
        return this.parsedExpression;
    }

    @Override
    @Nullable
    public Token[] getTokens() {
        return this.tokens;
    }

    @Override
    @Nullable
    public Set<String> getTokenVarNames() {
        return this.tokenVarNames;
    }

    public boolean hasTokenVars() {
        return this.tokenVarNames != null && !this.tokenVarNames.isEmpty();
    }

    private void parseExpression() throws ExpressionParserException {
        Token[] tokens = TokenParser.makeTokens(this.expression, true);
        HashMap<String, Token> tokenVars = null;
        String substitutedExpression = null;
        if (tokens != null && tokens.length > 0) {
            tokenVars = new HashMap<String, Token>();
            if (tokens.length == 1) {
                Token token = tokens[0];
                if (token.getType() == TokenType.TEXT) {
                    substitutedExpression = token.getDefaultValue();
                } else {
                    String tokenVarName = TokenizedExpression.createTokenVarName(token);
                    tokenVars.putIfAbsent(tokenVarName, token);
                    substitutedExpression = TokenizedExpression.createTokenVarRefName(tokenVarName);
                }
            } else {
                StringBuilder sb = new StringBuilder();
                for (Token token : tokens) {
                    if (token.getType() == TokenType.TEXT) {
                        sb.append(token.getDefaultValue());
                        continue;
                    }
                    String tokenVarName = TokenizedExpression.createTokenVarName(token);
                    tokenVars.putIfAbsent(tokenVarName, token);
                    substitutedExpression = TokenizedExpression.createTokenVarRefName(tokenVarName);
                    sb.append(substitutedExpression);
                }
                substitutedExpression = sb.toString();
            }
        }
        this.tokens = tokens;
        this.tokenVars = tokenVars != null && !tokenVars.isEmpty() ? Collections.unmodifiableMap(tokenVars) : null;
        this.tokenVarNames = tokenVars != null && !tokenVars.isEmpty() ? Collections.unmodifiableSet(tokenVars.keySet()) : null;
        this.substitutedExpression = substitutedExpression;
        if (substitutedExpression != null) {
            try {
                this.parsedExpression = Ognl.parseExpression((String)substitutedExpression);
            }
            catch (OgnlException e) {
                throw new ExpressionParserException(this.expression, e);
            }
        }
    }

    @Override
    public Object evaluate(Activity activity, OgnlContext ognlContext) {
        return this.evaluate(activity, ognlContext, null, null);
    }

    @Override
    public Object evaluate(Activity activity, OgnlContext ognlContext, Object root) {
        return this.evaluate(activity, ognlContext, root, null);
    }

    @Override
    public Object evaluate(Activity activity, OgnlContext ognlContext, Object root, Class<?> resultType) {
        Assert.notNull((Object)activity, "activity must not be null");
        Assert.notNull((Object)ognlContext, "ognlContext must not be null");
        if (this.getParsedExpression() == null) {
            return null;
        }
        try {
            this.preProcess(activity, ognlContext);
            Object value = Ognl.getValue((Object)this.getParsedExpression(), (OgnlContext)ognlContext, (Object)root, resultType);
            return this.postProcess(activity, ognlContext, value);
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException(this.getExpressionString(), e);
        }
    }

    private void preProcess(Activity activity, OgnlContext ognlContext) {
        if (this.hasTokenVars()) {
            TokenEvaluator tokenEvaluator = activity.getTokenEvaluator();
            this.resolveTokenVariables(ognlContext, tokenEvaluator);
        }
    }

    private Object postProcess(Activity activity, OgnlContext ognlContext, Object value) {
        if (this.getTokenVarNames() != null && value instanceof String) {
            String str = (String)value;
            for (String tokenVarName : this.getTokenVarNames()) {
                String tokenVarRefName = TokenizedExpression.createTokenVarRefName(tokenVarName);
                if (!str.contains(tokenVarRefName)) continue;
                Object tokenValue = ognlContext.get((Object)tokenVarName);
                String replacement = tokenValue != null ? ToStringBuilder.toString(tokenValue, activity.getStringifyContext()) : "";
                str = str.replace(tokenVarRefName, replacement);
            }
            return str;
        }
        return value;
    }

    private void resolveTokenVariables(OgnlContext ognlContext, TokenEvaluator tokenEvaluator) {
        for (Map.Entry<String, Token> entry : this.tokenVars.entrySet()) {
            String tokenVarName = entry.getKey();
            Token token = entry.getValue();
            Object value = tokenEvaluator.evaluate(token);
            ognlContext.put(tokenVarName, value);
        }
    }

    @NonNull
    private static String createTokenVarName(Token token) {
        return "__" + TokenizedExpression.createTokenName(token) + "__";
    }

    @NonNull
    private static String createTokenVarRefName(String tokenVarName) {
        return TOKEN_VAR_REF_SYMBOL + tokenVarName;
    }

    @NonNull
    private static String createTokenName(@NonNull Token token) {
        int hashCode = token.hashCode();
        if (hashCode >= 0) {
            return Long.toString(hashCode, 32);
        }
        return Long.toString(hashCode & Integer.MAX_VALUE, 32);
    }
}

