/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.asel.item;

import com.aspectran.core.activity.request.FileParameter;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.context.asel.item.ItemEvaluationException;
import com.aspectran.core.context.asel.item.ItemEvaluator;
import com.aspectran.core.context.asel.token.Token;
import com.aspectran.core.context.asel.token.TokenEvaluator;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.type.ItemType;
import com.aspectran.core.context.rule.type.ItemValueType;
import com.aspectran.utils.LinkedMultiValueMap;
import com.aspectran.utils.MultiValueMap;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.apon.Parameters;
import com.aspectran.utils.apon.VariableParameters;
import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ItemEvaluation
implements ItemEvaluator {
    private final TokenEvaluator tokenEvaluator;

    public ItemEvaluation(TokenEvaluator tokenEvaluator) {
        this.tokenEvaluator = tokenEvaluator;
    }

    @Override
    public Map<String, Object> evaluate(ItemRuleMap itemRuleMap) {
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
        this.evaluate(itemRuleMap, valueMap);
        return valueMap;
    }

    @Override
    public void evaluate(ItemRuleMap itemRuleMap, Map<String, Object> valueMap) {
        if (itemRuleMap != null) {
            for (ItemRule itemRule : itemRuleMap.values()) {
                valueMap.put(itemRule.getName(), this.evaluate(itemRule));
            }
        }
    }

    public <T> T evaluate(ItemRule itemRule) {
        try {
            ItemType itemType = itemRule.getType();
            ItemValueType valueType = itemRule.getValueType();
            Object value = null;
            if (itemType == ItemType.SINGLE) {
                value = valueType == ItemValueType.BEAN ? this.evaluateBean(itemRule.getBeanRule()) : this.evaluate(itemRule.getTokens(), valueType);
            } else if (itemType == ItemType.ARRAY) {
                value = valueType == ItemValueType.BEAN ? this.evaluateBeanAsArray(itemRule.getBeanRuleList()) : this.evaluateAsArray(itemRule.getTokensList(), valueType);
            } else if (itemType == ItemType.LIST) {
                value = valueType == ItemValueType.BEAN ? this.evaluateBeanAsList(itemRule.getBeanRuleList()) : this.evaluateAsList(itemRule.getTokensList(), valueType);
            } else if (itemType == ItemType.SET) {
                value = valueType == ItemValueType.BEAN ? this.evaluateBeanAsSet(itemRule.getBeanRuleList()) : this.evaluateAsSet(itemRule.getTokensList(), valueType);
            } else if (itemType == ItemType.MAP) {
                value = valueType == ItemValueType.BEAN ? this.evaluateBeanAsMap(itemRule.getBeanRuleMap()) : this.evaluateAsMap(itemRule.getTokensMap(), valueType);
            } else if (itemType == ItemType.PROPERTIES) {
                value = valueType == ItemValueType.BEAN ? this.evaluateBeanAsProperties(itemRule.getBeanRuleMap()) : this.evaluateAsProperties(itemRule.getTokensMap(), valueType);
            }
            return (T)value;
        }
        catch (Exception e) {
            throw new ItemEvaluationException(itemRule, (Throwable)e);
        }
    }

    @Override
    public MultiValueMap<String, String> evaluateAsMultiValueMap(@NonNull ItemRuleMap itemRuleMap) {
        return this.evaluateAsMultiValueMap(itemRuleMap.values());
    }

    @Override
    public MultiValueMap<String, String> evaluateAsMultiValueMap(@NonNull Collection<ItemRule> itemRules) {
        LinkedMultiValueMap<String, String> valueMap = new LinkedMultiValueMap<String, String>();
        for (ItemRule itemRule : itemRules) {
            String[] values = this.evaluateAsStringArray(itemRule);
            valueMap.set(itemRule.getName(), (String[])values);
        }
        return valueMap;
    }

    @Override
    public ParameterMap evaluateAsParameterMap(@NonNull ItemRuleMap itemRuleMap) {
        return this.evaluateAsParameterMap(itemRuleMap.values());
    }

    @Override
    public ParameterMap evaluateAsParameterMap(@NonNull Collection<ItemRule> itemRules) {
        ParameterMap params = new ParameterMap();
        for (ItemRule itemRule : itemRules) {
            String[] values = this.evaluateAsStringArray(itemRule);
            params.put(itemRule.getName(), values);
        }
        return params;
    }

    @Override
    public String[] evaluateAsStringArray(ItemRule itemRule) {
        try {
            Properties prop;
            ItemType itemType = itemRule.getType();
            ItemValueType valueType = itemRule.getValueType();
            String[] values = null;
            if (itemType == ItemType.SINGLE) {
                Object value;
                if (valueType == ItemValueType.BEAN) {
                    value = this.evaluateBean(itemRule.getBeanRule());
                } else {
                    Token[] tokens = itemRule.getTokens();
                    value = this.evaluate(tokens, valueType);
                }
                if (value != null) {
                    values = value instanceof String[] ? (String[])value : new String[]{value.toString()};
                }
            } else if (itemType == ItemType.ARRAY) {
                Object[] arr = valueType == ItemValueType.BEAN ? this.evaluateBeanAsArray(itemRule.getBeanRuleList()) : this.evaluateAsArray(itemRule.getTokensList(), valueType);
                if (arr != null) {
                    values = arr instanceof String[] ? (String[])arr : (String[])Arrays.stream(arr).map(Object::toString).toArray(String[]::new);
                }
            } else if (itemType == ItemType.LIST) {
                List<Object> list = valueType == ItemValueType.BEAN ? this.evaluateBeanAsList(itemRule.getBeanRuleList()) : this.evaluateAsList(itemRule.getTokensList(), valueType);
                if (list != null) {
                    values = (String[])Arrays.stream(list.toArray()).map(Object::toString).toArray(String[]::new);
                }
            } else if (itemType == ItemType.SET) {
                Set<Object> set = valueType == ItemValueType.BEAN ? this.evaluateBeanAsSet(itemRule.getBeanRuleList()) : this.evaluateAsSet(itemRule.getTokensList(), valueType);
                if (set != null) {
                    values = (String[])Arrays.stream(set.toArray()).map(Object::toString).toArray(String[]::new);
                }
            } else if (itemType == ItemType.MAP) {
                Map<String, Object> map = valueType == ItemValueType.BEAN ? this.evaluateBeanAsMap(itemRule.getBeanRuleMap()) : this.evaluateAsMap(itemRule.getTokensMap(), valueType);
                if (map != null) {
                    values = new String[]{map.toString()};
                }
            } else if (itemType == ItemType.PROPERTIES && (prop = valueType == ItemValueType.BEAN ? this.evaluateBeanAsProperties(itemRule.getBeanRuleMap()) : this.evaluateAsProperties(itemRule.getTokensMap(), valueType)) != null) {
                values = new String[]{prop.toString()};
            }
            return values;
        }
        catch (Exception e) {
            throw new ItemEvaluationException(itemRule, (Throwable)e);
        }
    }

    private Object evaluate(Token[] tokens, ItemValueType valueType) throws Exception {
        Object value = this.tokenEvaluator.evaluate(tokens);
        return value == null || valueType == null ? value : this.valuelize(value, valueType);
    }

    @Nullable
    private Object[] evaluateAsArray(List<Token[]> tokensList, ItemValueType valueType) throws Exception {
        List<Object> list = this.evaluateAsList(tokensList, valueType);
        if (list == null) {
            return null;
        }
        if (valueType == ItemValueType.STRING) {
            return list.toArray(new String[0]);
        }
        if (valueType == ItemValueType.INT) {
            return list.toArray(new Integer[0]);
        }
        if (valueType == ItemValueType.LONG) {
            return list.toArray(new Long[0]);
        }
        if (valueType == ItemValueType.FLOAT) {
            return list.toArray(new Float[0]);
        }
        if (valueType == ItemValueType.DOUBLE) {
            return list.toArray(new Double[0]);
        }
        if (valueType == ItemValueType.BOOLEAN) {
            return list.toArray(new Boolean[0]);
        }
        if (valueType == ItemValueType.PARAMETERS) {
            return list.toArray(new Parameters[0]);
        }
        if (valueType == ItemValueType.FILE) {
            return list.toArray(new File[0]);
        }
        if (valueType == ItemValueType.MULTIPART_FILE) {
            return list.toArray(new FileParameter[0]);
        }
        return list.toArray(new Object[0]);
    }

    private List<Object> evaluateAsList(List<Token[]> tokensList, ItemValueType valueType) throws Exception {
        if (tokensList == null || tokensList.isEmpty()) {
            return null;
        }
        ArrayList<Object> valueList = new ArrayList<Object>(tokensList.size());
        for (Token[] tokens : tokensList) {
            Object value = this.tokenEvaluator.evaluate(tokens);
            if (value != null && valueType != null) {
                value = this.valuelize(value, valueType);
            }
            valueList.add(value);
        }
        return valueList;
    }

    private Set<Object> evaluateAsSet(List<Token[]> tokensList, ItemValueType valueType) throws Exception {
        if (tokensList == null || tokensList.isEmpty()) {
            return null;
        }
        LinkedHashSet<Object> valueSet = new LinkedHashSet<Object>();
        for (Token[] tokens : tokensList) {
            Object value = this.tokenEvaluator.evaluate(tokens);
            if (value != null && valueType != null) {
                value = this.valuelize(value, valueType);
            }
            valueSet.add(value);
        }
        return valueSet;
    }

    private Map<String, Object> evaluateAsMap(Map<String, Token[]> tokensMap, ItemValueType valueType) throws Exception {
        if (tokensMap == null || tokensMap.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Token[]> entry : tokensMap.entrySet()) {
            Object value = this.tokenEvaluator.evaluate(entry.getValue());
            if (value != null && valueType != null) {
                value = this.valuelize(value, valueType);
            }
            valueMap.put(entry.getKey(), value);
        }
        return valueMap;
    }

    private Properties evaluateAsProperties(Map<String, Token[]> tokensMap, ItemValueType valueType) throws Exception {
        if (tokensMap == null || tokensMap.isEmpty()) {
            return null;
        }
        Properties prop = new Properties();
        for (Map.Entry<String, Token[]> entry : tokensMap.entrySet()) {
            Object value = this.tokenEvaluator.evaluate(entry.getValue());
            if (value != null && valueType != null) {
                value = this.valuelize(value, valueType);
            }
            if (value == null) continue;
            prop.put(entry.getKey(), value);
        }
        return prop;
    }

    private Object valuelize(Object value, ItemValueType valueType) throws Exception {
        if (valueType == ItemValueType.STRING) {
            return value.toString();
        }
        if (valueType == ItemValueType.INT) {
            return value instanceof Integer ? value : Integer.valueOf(value.toString());
        }
        if (valueType == ItemValueType.LONG) {
            return value instanceof Long ? value : Long.valueOf(value.toString());
        }
        if (valueType == ItemValueType.FLOAT) {
            return value instanceof Float ? value : Float.valueOf(value.toString());
        }
        if (valueType == ItemValueType.DOUBLE) {
            return value instanceof Double ? value : Double.valueOf(value.toString());
        }
        if (valueType == ItemValueType.BOOLEAN) {
            return value instanceof Boolean ? value : Boolean.valueOf(value.toString());
        }
        if (valueType == ItemValueType.PARAMETERS) {
            return new VariableParameters(value.toString());
        }
        if (valueType == ItemValueType.FILE) {
            return value instanceof File ? value : new File(value.toString());
        }
        if (valueType == ItemValueType.MULTIPART_FILE) {
            return value instanceof FileParameter ? value : new FileParameter(new File(value.toString()));
        }
        return value;
    }

    private Object evaluateBean(BeanRule beanRule) {
        return this.tokenEvaluator.getActivity().getPrototypeScopeBean(beanRule);
    }

    @Nullable
    private Object[] evaluateBeanAsArray(List<BeanRule> beanRuleList) {
        List<Object> valueList = this.evaluateBeanAsList(beanRuleList);
        if (valueList == null) {
            return null;
        }
        Class<?> componentType = null;
        for (Object value : valueList) {
            if (value == null) continue;
            if (componentType == null) {
                componentType = value.getClass();
                continue;
            }
            if (componentType == value.getClass()) continue;
            componentType = null;
            break;
        }
        if (componentType != null) {
            Object values = Array.newInstance(componentType, valueList.size());
            for (int i = 0; i < valueList.size(); ++i) {
                Array.set(values, i, valueList.get(i));
            }
            return (Object[])values;
        }
        return valueList.toArray(new Object[0]);
    }

    private List<Object> evaluateBeanAsList(List<BeanRule> beanRuleList) {
        if (beanRuleList == null || beanRuleList.isEmpty()) {
            return null;
        }
        ArrayList<Object> valueList = new ArrayList<Object>(beanRuleList.size());
        for (BeanRule beanRule : beanRuleList) {
            valueList.add(this.evaluateBean(beanRule));
        }
        return valueList;
    }

    private Set<Object> evaluateBeanAsSet(List<BeanRule> beanRuleList) {
        if (beanRuleList == null || beanRuleList.isEmpty()) {
            return null;
        }
        LinkedHashSet<Object> valueSet = new LinkedHashSet<Object>();
        for (BeanRule beanRule : beanRuleList) {
            Object value = this.evaluateBean(beanRule);
            valueSet.add(value);
        }
        return valueSet;
    }

    private Map<String, Object> evaluateBeanAsMap(Map<String, BeanRule> beanRuleMap) {
        if (beanRuleMap == null || beanRuleMap.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, BeanRule> entry : beanRuleMap.entrySet()) {
            Object value = this.evaluateBean(entry.getValue());
            valueMap.put(entry.getKey(), value);
        }
        return valueMap;
    }

    private Properties evaluateBeanAsProperties(Map<String, BeanRule> beanRuleMap) {
        if (beanRuleMap == null || beanRuleMap.isEmpty()) {
            return null;
        }
        Properties prop = new Properties();
        for (Map.Entry<String, BeanRule> entry : beanRuleMap.entrySet()) {
            Object value = this.evaluateBean(entry.getValue());
            if (value == null) continue;
            prop.put(entry.getKey(), value);
        }
        return prop;
    }
}

