/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.asel.token;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.ActivityPerformException;
import com.aspectran.core.activity.InstantActivity;
import com.aspectran.core.component.bean.NoSuchBeanException;
import com.aspectran.core.component.bean.NoUniqueBeanException;
import com.aspectran.core.context.asel.token.Token;
import com.aspectran.core.context.asel.token.TokenEvaluationException;
import com.aspectran.core.context.asel.token.TokenEvaluator;
import com.aspectran.core.context.rule.type.TokenDirectiveType;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.utils.BeanUtils;
import com.aspectran.utils.PropertiesLoaderUtils;
import com.aspectran.utils.ReflectionUtils;
import com.aspectran.utils.SystemUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;

public class TokenEvaluation
implements TokenEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(TokenEvaluation.class);
    protected final Activity activity;

    public TokenEvaluation(Activity activity) {
        if (activity == null) {
            throw new IllegalArgumentException("activity must not be null");
        }
        this.activity = activity;
    }

    @Override
    public Activity getActivity() {
        return this.activity;
    }

    @Override
    public Object evaluate(Token token) {
        try {
            TokenType tokenType = token.getType();
            Object value = null;
            if (tokenType == TokenType.TEXT) {
                value = token.getDefaultValue();
            } else if (tokenType == TokenType.BEAN) {
                value = this.getBean(token);
            } else if (tokenType == TokenType.TEMPLATE) {
                value = this.getTemplate(token);
            } else if (tokenType == TokenType.PARAMETER) {
                String[] values = this.getParameterValues(token.getName());
                value = values == null || values.length == 0 ? token.getDefaultValue() : (values.length > 1 && token.getDefaultValue() == null ? values : (values[0] != null ? values[0] : token.getDefaultValue()));
            } else if (tokenType == TokenType.ATTRIBUTE) {
                value = this.getAttribute(token);
            } else if (tokenType == TokenType.PROPERTY) {
                value = this.getProperty(token);
            }
            return value;
        }
        catch (Exception e) {
            throw new TokenEvaluationException(token, (Throwable)e);
        }
    }

    @Override
    public Object evaluate(Token[] tokens) {
        if (tokens == null || tokens.length == 0) {
            return null;
        }
        if (tokens.length > 1) {
            StringBuilder sb = new StringBuilder();
            for (Token t : tokens) {
                Object value = this.evaluate(t);
                if (value == null) continue;
                if (value instanceof Object[]) {
                    sb.append(Arrays.toString((Object[])value));
                    continue;
                }
                sb.append(value);
            }
            return sb.toString();
        }
        return this.evaluate(tokens[0]);
    }

    @Override
    public void evaluate(Token[] tokens, Writer writer) throws IOException {
        if (tokens == null || tokens.length == 0) {
            return;
        }
        for (Token t : tokens) {
            Object value = this.evaluate(t);
            if (value == null) continue;
            writer.write(value.toString());
        }
        writer.flush();
    }

    @Override
    public String evaluateAsString(Token[] tokens) {
        Object value = this.evaluate(tokens);
        if (value instanceof Object[]) {
            return Arrays.toString((Object[])value);
        }
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    @Override
    public List<Object> evaluateAsList(List<Token[]> tokensList) {
        if (tokensList == null || tokensList.isEmpty()) {
            return null;
        }
        ArrayList<Object> valueList = new ArrayList<Object>(tokensList.size());
        for (Token[] tokens : tokensList) {
            Object value = this.evaluate(tokens);
            valueList.add(value);
        }
        return valueList;
    }

    @Override
    public Set<Object> evaluateAsSet(Set<Token[]> tokensSet) {
        if (tokensSet == null || tokensSet.isEmpty()) {
            return null;
        }
        HashSet<Object> valueSet = new HashSet<Object>();
        for (Token[] tokens : tokensSet) {
            Object value = this.evaluate(tokens);
            valueSet.add(value);
        }
        return valueSet;
    }

    @Override
    public Map<String, Object> evaluateAsMap(Map<String, Token[]> tokensMap) {
        if (tokensMap == null || tokensMap.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Token[]> entry : tokensMap.entrySet()) {
            Object value = this.evaluate(entry.getValue());
            valueMap.put(entry.getKey(), value);
        }
        return valueMap;
    }

    @Override
    public Properties evaluateAsProperties(Properties tokensProp) {
        if (tokensProp == null || tokensProp.isEmpty()) {
            return null;
        }
        Properties prop = new Properties();
        for (Map.Entry<Object, Object> entry : tokensProp.entrySet()) {
            Object value = this.evaluate((Token[])entry.getValue());
            prop.put(entry.getKey(), value);
        }
        return prop;
    }

    protected String[] getParameterValues(String name) {
        if (this.activity.getRequestAdapter() != null) {
            return this.activity.getRequestAdapter().getParameterValues(name);
        }
        return null;
    }

    protected Object getAttribute(Token token) {
        Object object = null;
        if (this.activity.getProcessResult() != null) {
            object = this.activity.getProcessResult().getResultValue(token.getName());
        }
        if (object == null && this.activity.getRequestAdapter() != null) {
            object = this.activity.getRequestAdapter().getAttribute(token.getName());
        }
        if (object != null && token.getGetterName() != null) {
            object = this.getBeanProperty(object, token.getGetterName());
        }
        return object != null ? object : token.getDefaultValue();
    }

    protected Object getBean(@NonNull Token token) {
        Object value;
        if (token.getAlternativeValue() != null) {
            if (token.getDirectiveType() == TokenDirectiveType.FIELD) {
                Field field = (Field)token.getAlternativeValue();
                if (Modifier.isStatic(field.getModifiers())) {
                    value = ReflectionUtils.getField(field, null);
                } else {
                    Class<?> beanClass = field.getDeclaringClass();
                    Object target = this.activity.getBean(beanClass);
                    value = ReflectionUtils.getField(field, target);
                }
            } else if (token.getDirectiveType() == TokenDirectiveType.METHOD) {
                Method method = (Method)token.getAlternativeValue();
                if (Modifier.isStatic(method.getModifiers())) {
                    value = ReflectionUtils.invokeMethod(method, null);
                } else {
                    Class<?> beanClass = method.getDeclaringClass();
                    Object target = this.activity.getBean(beanClass);
                    value = ReflectionUtils.invokeMethod(method, target);
                }
            } else {
                T[] enums;
                Class beanClass = (Class)token.getAlternativeValue();
                String getterName = token.getGetterName();
                if (getterName != null && beanClass.isEnum() && (enums = beanClass.getEnumConstants()) != null) {
                    for (Object en : enums) {
                        if (!getterName.equals(en.toString())) continue;
                        return en;
                    }
                }
                try {
                    value = this.activity.getBean(beanClass);
                }
                catch (NoSuchBeanException | NoUniqueBeanException e) {
                    if (getterName != null) {
                        try {
                            Object value2 = BeanUtils.getProperty(beanClass, getterName);
                            if (value2 == null) {
                                value2 = token.getDefaultValue();
                            }
                            return value2;
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            // empty catch block
                        }
                    }
                    throw e;
                }
                if (value != null && getterName != null) {
                    value = this.getBeanProperty(value, getterName);
                }
            }
        } else {
            value = this.activity.getBean(token.getName());
            if (value != null && token.getGetterName() != null) {
                value = this.getBeanProperty(value, token.getGetterName());
            }
        }
        if (value == null) {
            value = token.getDefaultValue();
        }
        return value;
    }

    protected Object getBeanProperty(Object bean, String propertyName) {
        Object value;
        try {
            value = BeanUtils.getProperty(bean, propertyName);
        }
        catch (InvocationTargetException e) {
            value = null;
        }
        return value;
    }

    protected Object getProperty(@NonNull Token token) throws IOException {
        if (token.getDirectiveType() == TokenDirectiveType.CLASSPATH) {
            try {
                Properties props = PropertiesLoaderUtils.loadProperties(token.getValue(), this.activity.getClassLoader());
                Properties value = token.getGetterName() != null ? props.get(token.getGetterName()) : props;
                return value != null ? value : token.getDefaultValue();
            }
            catch (EncryptionInitializationException | EncryptionOperationNotPossibleException e) {
                logger.error("Failed to decrypt values of encrypted properties while evaluating token " + String.valueOf(token) + "; Most of these occur when the password used for encryption is different", e);
                return null;
            }
        }
        if (token.getDirectiveType() == TokenDirectiveType.SYSTEM) {
            return SystemUtils.getProperty(token.getValue(), token.getDefaultValue());
        }
        Object value = this.activity.getEnvironment().getProperty(token.getName(), this.activity);
        if (value != null && token.getGetterName() != null) {
            value = this.getBeanProperty(value, token.getGetterName());
        }
        return value != null ? value : token.getDefaultValue();
    }

    protected String getTemplate(@NonNull Token token) throws ActivityPerformException {
        InstantActivity instantActivity = new InstantActivity(this.activity, false);
        return instantActivity.perform(() -> {
            this.activity.getTemplateRenderer().render(token.getName(), (Activity)instantActivity);
            String result = instantActivity.getResponseAdapter().getWriter().toString();
            return result != null ? result : token.getDefaultValue();
        });
    }
}

