/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.asel.token;

import com.aspectran.core.context.asel.token.Token;
import com.aspectran.core.context.rule.type.TokenDirectiveType;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Tokenizer {
    private static final int MAX_TOKEN_NAME_LENGTH = 256;
    private static final int AT_TEXT = 1;
    private static final int AT_SYMBOL = 2;
    private static final int AT_NAME = 3;
    private static final int AT_VALUE = 4;
    private static final char CR = '\r';
    private static final char LF = '\n';

    @NonNull
    public static List<Token> tokenize(CharSequence chars, boolean textTrim) {
        if (chars == null) {
            throw new IllegalArgumentException("chars must not be null");
        }
        int inputLen = chars.length();
        if (inputLen == 0) {
            ArrayList<Token> tokens = new ArrayList<Token>(1);
            tokens.add(new Token(""));
            return tokens;
        }
        StringBuilder nameBuf = new StringBuilder();
        StringBuilder valueBuf = new StringBuilder();
        int start = 0;
        int end = 0;
        int symbolStart = -1;
        char symbol = '$';
        int state = 1;
        ArrayList<Token> tokens = new ArrayList<Token>();
        block6: for (int i = 0; i < inputLen; ++i) {
            char c = chars.charAt(i);
            ++end;
            switch (state) {
                case 1: {
                    if (!Token.isTokenSymbol(c)) continue block6;
                    symbol = c;
                    state = 2;
                    symbolStart = end - 1;
                    continue block6;
                }
                case 2: {
                    if (c == '{') {
                        nameBuf.setLength(0);
                        state = 3;
                        continue block6;
                    }
                    if (Token.isTokenSymbol(c)) {
                        symbol = c;
                        symbolStart = end - 1;
                        continue block6;
                    }
                    state = 1;
                    continue block6;
                }
                case 3: {
                    Token token;
                    if (c == ':') {
                        valueBuf.setLength(0);
                        state = 4;
                        continue block6;
                    }
                    if (c == '}') {
                        if (!nameBuf.isEmpty()) {
                            if (symbolStart > start) {
                                token = Tokenizer.createToken(chars, start, symbolStart, textTrim);
                                tokens.add(token);
                            }
                            token = Tokenizer.createToken(symbol, nameBuf, null);
                            tokens.add(token);
                            start = end;
                        }
                        state = 1;
                        continue block6;
                    }
                    nameBuf.append(c);
                    if (nameBuf.length() <= 256) continue block6;
                    nameBuf.setLength(0);
                    state = 1;
                    continue block6;
                }
                case 4: {
                    Token token;
                    if (c == '}') {
                        if (!valueBuf.isEmpty()) {
                            if (symbolStart > start) {
                                token = Tokenizer.createToken(chars, start, symbolStart, textTrim);
                                tokens.add(token);
                            }
                            token = Tokenizer.createToken(symbol, nameBuf, valueBuf);
                            tokens.add(token);
                            start = end;
                        }
                        state = 1;
                        continue block6;
                    }
                    valueBuf.append(c);
                }
            }
        }
        if (start < end) {
            Token token = Tokenizer.createToken(chars, start, end, textTrim);
            tokens.add(token);
        }
        return tokens;
    }

    @NonNull
    private static Token createToken(char symbol, StringBuilder nameBuf, StringBuilder valueBuf) {
        String value = null;
        if (valueBuf != null && !valueBuf.isEmpty()) {
            value = valueBuf.toString();
        }
        if (!nameBuf.isEmpty()) {
            TokenType type = Token.resolveTypeAsSymbol(symbol);
            String name = nameBuf.toString();
            int offset = name.indexOf(94);
            if (offset > -1) {
                String name2 = name.substring(0, offset);
                String getter = name.substring(offset + 1);
                Token token = new Token(type, name2);
                if (!getter.isEmpty()) {
                    token.setGetterName(getter);
                }
                token.setDefaultValue(value);
                return token;
            }
            if (value != null) {
                TokenDirectiveType directiveType = TokenDirectiveType.resolve(name);
                if (directiveType != null) {
                    String getter = null;
                    String defaultValue = null;
                    offset = value.indexOf(94);
                    if (offset > -1) {
                        String value2 = value.substring(0, offset);
                        String getter2 = value.substring(offset + 1);
                        value = value2;
                        offset = getter2.indexOf(58);
                        if (offset > -1) {
                            String getter3 = getter2.substring(0, offset);
                            String value3 = getter2.substring(offset + 1);
                            if (!getter3.isEmpty()) {
                                getter = getter3;
                            }
                            if (!value3.isEmpty()) {
                                defaultValue = value3;
                            }
                        } else if (!getter2.isEmpty()) {
                            getter = getter2;
                        }
                    }
                    Token token = new Token(type, directiveType, value);
                    token.setGetterName(getter);
                    token.setDefaultValue(defaultValue);
                    return token;
                }
                Token token = new Token(type, name);
                token.setDefaultValue(value);
                return token;
            }
            return new Token(type, name);
        }
        return new Token(value);
    }

    @NonNull
    private static Token createToken(CharSequence chars, int start, int end, boolean trim) {
        String text = Tokenizer.extract(chars, start, end, trim);
        return new Token(text);
    }

    private static String extract(CharSequence chars, int start, int end, boolean trim) {
        char c;
        int i;
        if (!trim) {
            return chars.subSequence(start, end).toString();
        }
        boolean leadingLF = false;
        boolean tailingLF = false;
        int subStart = start;
        int subEnd = end;
        for (i = start; i < end; ++i) {
            c = chars.charAt(i);
            if (c == '\n' || c == '\r') {
                leadingLF = true;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            subStart = i;
            break;
        }
        if (leadingLF && start == subStart) {
            return String.valueOf('\n');
        }
        for (i = end - 1; i > start; --i) {
            c = chars.charAt(i);
            if (c == '\n' || c == '\r') {
                tailingLF = true;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            subEnd = i + 1;
            break;
        }
        String str = chars.subSequence(subStart, subEnd).toString();
        if (leadingLF && tailingLF) {
            return "\n" + str + "\n";
        }
        if (leadingLF) {
            return "\n" + str;
        }
        if (tailingLF) {
            return str + "\n";
        }
        return str;
    }

    public static Token[] optimize(Token[] tokens) {
        String text;
        if (tokens == null) {
            return null;
        }
        String firstVal = null;
        String lastVal = null;
        if (tokens.length == 1) {
            if (tokens[0].getType() == TokenType.TEXT) {
                firstVal = tokens[0].getDefaultValue();
            }
        } else if (tokens.length > 1) {
            if (tokens[0].getType() == TokenType.TEXT) {
                firstVal = tokens[0].getDefaultValue();
            }
            if (tokens[tokens.length - 1].getType() == TokenType.TEXT) {
                lastVal = tokens[tokens.length - 1].getDefaultValue();
            }
        }
        if (firstVal != null && !Objects.equals(firstVal, text = Tokenizer.trimLeadingWhitespace(firstVal))) {
            tokens[0] = new Token(text);
        }
        if (lastVal != null && !lastVal.isEmpty() && !Objects.equals(lastVal, text = Tokenizer.trimTrailingWhitespace(lastVal))) {
            tokens[tokens.length - 1] = new Token(text);
        }
        return tokens;
    }

    @NonNull
    private static String trimLeadingWhitespace(@NonNull String str) {
        if (str.isEmpty()) {
            return str;
        }
        int start = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) continue;
            start = i;
            break;
        }
        if (start == 0) {
            return str;
        }
        return str.substring(start);
    }

    private static String trimTrailingWhitespace(@NonNull String str) {
        int end = 0;
        for (int i = str.length() - 1; i >= 0; --i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) continue;
            end = i;
            break;
        }
        if (end == 0) {
            return str;
        }
        return str.substring(0, end + 1);
    }
}

