/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.asel.value;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.context.asel.ExpressionEvaluationException;
import com.aspectran.core.context.asel.ExpressionEvaluator;
import com.aspectran.core.context.asel.ExpressionParserException;
import com.aspectran.core.context.asel.TokenizedExpression;
import com.aspectran.core.context.asel.ognl.OgnlSupport;
import com.aspectran.core.context.asel.token.Token;
import com.aspectran.core.context.asel.value.ValueEvaluator;
import com.aspectran.utils.ConcurrentReferenceHashMap;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.util.Map;
import ognl.OgnlContext;

public class ValueExpression
implements ValueEvaluator {
    private static final Map<String, ExpressionEvaluator> cache = new ConcurrentReferenceHashMap<String, ExpressionEvaluator>();
    private final ExpressionEvaluator expressionEvaluator;

    public ValueExpression(String expression) throws ExpressionParserException {
        this.expressionEvaluator = ValueExpression.parseExpression(expression);
    }

    @Nullable
    public String getExpressionString() {
        return this.expressionEvaluator.getExpressionString();
    }

    @Nullable
    public Object getParsedExpression() {
        return this.expressionEvaluator.getParsedExpression();
    }

    @Nullable
    public Token[] getTokens() {
        return this.expressionEvaluator.getTokens();
    }

    @Override
    public <V> V evaluate(Activity activity, Class<V> resultType) {
        if (activity == null) {
            throw new IllegalArgumentException("activity must not be null");
        }
        if (this.getParsedExpression() == null) {
            return null;
        }
        OgnlContext ognlContext = OgnlSupport.createDefaultContext();
        return (V)this.expressionEvaluator.evaluate(activity, ognlContext, activity.getActivityData(), resultType);
    }

    public static Object evaluate(String expression, Activity activity) {
        return ValueExpression.evaluate(expression, activity, null);
    }

    public static <V> V evaluate(String expression, Activity activity, Class<V> resultType) {
        try {
            ValueExpression valueEvaluator = new ValueExpression(expression);
            return valueEvaluator.evaluate(activity, resultType);
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException(expression, e);
        }
    }

    private static ExpressionEvaluator parseExpression(String expression) throws ExpressionParserException {
        ExpressionEvaluator existing;
        ExpressionEvaluator evaluator = cache.get(expression);
        if (evaluator == null && (existing = cache.putIfAbsent(expression, evaluator = new TokenizedExpression(expression))) != null) {
            evaluator = existing;
        }
        return evaluator;
    }
}

