/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.builder;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.adapter.DefaultApplicationAdapter;
import com.aspectran.core.component.aspect.AspectAdviceRulePreRegister;
import com.aspectran.core.component.aspect.AspectRuleRegistry;
import com.aspectran.core.component.aspect.InvalidPointcutPatternException;
import com.aspectran.core.component.aspect.pointcut.Pointcut;
import com.aspectran.core.component.aspect.pointcut.PointcutFactory;
import com.aspectran.core.component.aspect.pointcut.PointcutPattern;
import com.aspectran.core.component.bean.BeanRuleRegistry;
import com.aspectran.core.component.bean.DefaultBeanRegistry;
import com.aspectran.core.component.schedule.ScheduleRuleRegistry;
import com.aspectran.core.component.template.DefaultTemplateRenderer;
import com.aspectran.core.component.template.TemplateRuleRegistry;
import com.aspectran.core.component.translet.TransletRuleRegistry;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.DefaultActivityContext;
import com.aspectran.core.context.builder.ActivityContextBuilder;
import com.aspectran.core.context.builder.reload.ContextReloadingTimer;
import com.aspectran.core.context.config.ContextAutoReloadConfig;
import com.aspectran.core.context.config.ContextConfig;
import com.aspectran.core.context.config.ContextProfilesConfig;
import com.aspectran.core.context.env.ActivityEnvironment;
import com.aspectran.core.context.env.ActivityEnvironmentBuilder;
import com.aspectran.core.context.env.EnvironmentProfiles;
import com.aspectran.core.context.resource.InvalidResourceException;
import com.aspectran.core.context.resource.ResourceManager;
import com.aspectran.core.context.resource.SiblingClassLoader;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.EnvironmentRule;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.PointcutPatternRule;
import com.aspectran.core.context.rule.PointcutRule;
import com.aspectran.core.context.rule.assistant.ActivityRuleAssistant;
import com.aspectran.core.context.rule.assistant.BeanReferenceException;
import com.aspectran.core.context.rule.assistant.BeanReferenceInspector;
import com.aspectran.core.context.rule.params.AspectranParameters;
import com.aspectran.core.context.rule.type.AutoReloadType;
import com.aspectran.core.service.CoreService;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.SystemUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public abstract class AbstractActivityContextBuilder
implements ActivityContextBuilder {
    private static final Logger logger = LoggerFactory.getLogger(AbstractActivityContextBuilder.class);
    private static final String TMP_BASE_DIRNAME_PREFIX = "com.aspectran-";
    private String basePath;
    private boolean ownBasePath;
    private final CoreService masterService;
    private ContextConfig contextConfig;
    private AspectranParameters aspectranParameters;
    private String[] contextRules;
    private String encoding;
    private String[] resourceLocations;
    private String[] basePackages;
    private String[] activeProfiles;
    private String[] defaultProfiles;
    private ItemRuleMap propertyItemRuleMap;
    private boolean hardReload;
    private boolean autoReloadEnabled;
    private int scanIntervalSeconds;
    private ContextReloadingTimer contextReloadingTimer;
    private SiblingClassLoader siblingClassLoader;
    private boolean useAponToLoadXml;
    private boolean debugMode;

    public AbstractActivityContextBuilder(CoreService masterService) {
        this.masterService = masterService;
        this.useAponToLoadXml = Boolean.parseBoolean(SystemUtils.getProperty("com.aspectran.core.context.builder.useAponToLoadXml"));
        this.debugMode = Boolean.parseBoolean(SystemUtils.getProperty("com.aspectran.core.context.builder.debugMode"));
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public void setBasePath(String basePath) {
        this.basePath = StringUtils.hasText(basePath) ? basePath : null;
    }

    @Override
    public boolean hasOwnBasePath() {
        return this.ownBasePath;
    }

    protected void setOwnBasePath(boolean ownBasePath) {
        this.ownBasePath = ownBasePath;
    }

    @Override
    public CoreService getMasterService() {
        return this.masterService;
    }

    @Override
    public ContextConfig getContextConfig() {
        return this.contextConfig;
    }

    @Override
    public AspectranParameters getAspectranParameters() {
        return this.aspectranParameters;
    }

    @Override
    public void setAspectranParameters(AspectranParameters aspectranParameters) {
        this.aspectranParameters = aspectranParameters;
        this.contextRules = null;
    }

    @Override
    public String[] getContextRules() {
        return this.contextRules;
    }

    @Override
    public void setContextRules(String[] contextRules) {
        this.contextRules = contextRules;
        this.aspectranParameters = null;
    }

    @Override
    public String getEncoding() {
        return this.encoding == null ? ActivityContext.DEFAULT_ENCODING : this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public String[] getResourceLocations() {
        return this.resourceLocations;
    }

    @Override
    public void setResourceLocations(String ... resourceLocations) {
        this.resourceLocations = resourceLocations;
    }

    @Override
    public String[] getBasePackages() {
        return this.basePackages;
    }

    @Override
    public void setBasePackages(String ... basePackages) {
        if (basePackages != null && basePackages.length > 0) {
            this.basePackages = basePackages;
        }
    }

    @Override
    public String[] getActiveProfiles() {
        return this.activeProfiles;
    }

    @Override
    public void setActiveProfiles(String ... activeProfiles) {
        this.activeProfiles = activeProfiles;
    }

    @Override
    public String[] getDefaultProfiles() {
        return this.defaultProfiles;
    }

    @Override
    public void setDefaultProfiles(String ... defaultProfiles) {
        this.defaultProfiles = defaultProfiles;
    }

    @Override
    public void putPropertyItemRule(ItemRule propertyItemRule) {
        if (this.propertyItemRuleMap == null) {
            this.propertyItemRuleMap = new ItemRuleMap();
        }
        this.propertyItemRuleMap.putItemRule(propertyItemRule);
    }

    @Override
    public boolean isHardReload() {
        return this.hardReload;
    }

    @Override
    public void setHardReload(boolean hardReload) {
        this.hardReload = hardReload;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.siblingClassLoader;
    }

    @Override
    public void configure(ContextConfig contextConfig) throws IOException, InvalidResourceException {
        if (this.basePath == null) {
            this.basePath = this.getMasterService() != null ? this.getMasterService().getBasePath() : contextConfig.getBasePath();
        }
        if (this.getMasterService() == null || this.getMasterService().isRootService()) {
            this.checkDirectoryStructure();
        }
        if (contextConfig != null) {
            ContextAutoReloadConfig autoReloadConfig;
            this.contextConfig = contextConfig;
            this.contextRules = contextConfig.getContextRules();
            AspectranParameters aspectranParameters = contextConfig.getAspectranParameters();
            if (aspectranParameters != null) {
                this.aspectranParameters = aspectranParameters;
            }
            this.encoding = contextConfig.getEncoding();
            String[] resourceLocations = contextConfig.getResourceLocations();
            this.resourceLocations = ResourceManager.checkResourceLocations(resourceLocations, this.getBasePath());
            this.basePackages = contextConfig.getBasePackages();
            ContextProfilesConfig profilesConfig = contextConfig.getProfilesConfig();
            if (profilesConfig != null) {
                this.setActiveProfiles(profilesConfig.getActiveProfiles());
                this.setDefaultProfiles(profilesConfig.getDefaultProfiles());
            }
            if ((autoReloadConfig = contextConfig.getAutoReloadConfig()) != null) {
                String reloadMode = autoReloadConfig.getReloadMode();
                int scanIntervalSeconds = autoReloadConfig.getScanIntervalSeconds();
                boolean autoReloadEnabled = autoReloadConfig.isEnabled();
                this.hardReload = AutoReloadType.HARD.toString().equals(reloadMode);
                this.autoReloadEnabled = autoReloadEnabled;
                this.scanIntervalSeconds = scanIntervalSeconds;
            }
            if (this.autoReloadEnabled && this.resourceLocations == null) {
                this.autoReloadEnabled = false;
            }
            if (this.autoReloadEnabled && this.scanIntervalSeconds == -1) {
                this.scanIntervalSeconds = 10;
                if (logger.isDebugEnabled()) {
                    logger.debug("Context option 'autoReload' not specified, defaulting to 10 seconds");
                }
            }
        }
    }

    protected boolean isUseAponToLoadXml() {
        return this.useAponToLoadXml;
    }

    @Override
    public void setUseAponToLoadXml(boolean useAponToLoadXml) {
        this.useAponToLoadXml = useAponToLoadXml;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    protected SiblingClassLoader createSiblingClassLoader(String contextName, ClassLoader parentClassLoader) throws InvalidResourceException {
        if (this.siblingClassLoader == null || this.hardReload) {
            this.siblingClassLoader = new SiblingClassLoader(contextName, parentClassLoader, this.resourceLocations);
        } else {
            this.siblingClassLoader.reload();
        }
        return this.siblingClassLoader;
    }

    protected ApplicationAdapter createApplicationAdapter() {
        return new DefaultApplicationAdapter(this.basePath);
    }

    protected EnvironmentProfiles createEnvironmentProfiles() {
        EnvironmentProfiles environmentProfiles = new EnvironmentProfiles();
        if (this.getDefaultProfiles() != null) {
            environmentProfiles.setDefaultProfiles(this.getDefaultProfiles());
        }
        if (this.getActiveProfiles() != null) {
            environmentProfiles.setActiveProfiles(this.getActiveProfiles());
        } else {
            environmentProfiles.getActiveProfiles();
        }
        return environmentProfiles;
    }

    protected ActivityContext createActivityContext(@NonNull ActivityRuleAssistant assistant) throws BeanReferenceException, IllegalRuleException {
        DefaultActivityContext context = new DefaultActivityContext(assistant.getClassLoader(), assistant.getApplicationAdapter());
        if (this.getContextConfig() != null) {
            context.setName(this.getContextConfig().getName());
        }
        context.setDescriptionRule(assistant.getAssistantLocal().getDescriptionRule());
        ActivityEnvironment activityEnvironment = this.createActivityEnvironment(context, assistant);
        context.setActivityEnvironment(activityEnvironment);
        AspectRuleRegistry aspectRuleRegistry = assistant.getAspectRuleRegistry();
        BeanRuleRegistry beanRuleRegistry = assistant.getBeanRuleRegistry();
        beanRuleRegistry.postProcess(assistant);
        BeanReferenceInspector beanReferenceInspector = assistant.getBeanReferenceInspector();
        beanReferenceInspector.inspect(beanRuleRegistry);
        this.initAspectRuleRegistry(assistant);
        DefaultBeanRegistry defaultBeanRegistry = new DefaultBeanRegistry(context, beanRuleRegistry);
        TemplateRuleRegistry templateRuleRegistry = assistant.getTemplateRuleRegistry();
        DefaultTemplateRenderer defaultTemplateRenderer = new DefaultTemplateRenderer(context, templateRuleRegistry);
        ScheduleRuleRegistry scheduleRuleRegistry = assistant.getScheduleRuleRegistry();
        TransletRuleRegistry transletRuleRegistry = assistant.getTransletRuleRegistry();
        context.setAspectRuleRegistry(aspectRuleRegistry);
        context.setDefaultBeanRegistry(defaultBeanRegistry);
        context.setScheduleRuleRegistry(scheduleRuleRegistry);
        context.setDefaultTemplateRenderer(defaultTemplateRenderer);
        context.setTransletRuleRegistry(transletRuleRegistry);
        return context;
    }

    protected void startContextReloadingTimer() {
        if (this.autoReloadEnabled && this.masterService != null && this.siblingClassLoader != null) {
            this.contextReloadingTimer = new ContextReloadingTimer(this.masterService.getServiceLifeCycle());
            this.contextReloadingTimer.setResources(this.siblingClassLoader.getAllResources());
            this.contextReloadingTimer.start(this.scanIntervalSeconds);
        }
    }

    protected void stopContextReloadingTimer() {
        if (this.contextReloadingTimer != null) {
            this.contextReloadingTimer.stop();
            this.contextReloadingTimer = null;
        }
    }

    @NonNull
    private ActivityEnvironment createActivityEnvironment(ActivityContext context, @NonNull ActivityRuleAssistant assistant) {
        EnvironmentProfiles environmentProfiles = assistant.getEnvironmentProfiles();
        ActivityEnvironmentBuilder builder = new ActivityEnvironmentBuilder(context, environmentProfiles).putPropertyItemRules(this.propertyItemRuleMap);
        for (EnvironmentRule environmentRule : assistant.getEnvironmentRules()) {
            if (!environmentProfiles.acceptsProfiles(environmentRule.getProfiles()) || environmentRule.getPropertyItemRuleMapList() == null) continue;
            for (ItemRuleMap propertyIrm : environmentRule.getPropertyItemRuleMapList()) {
                if (!environmentProfiles.acceptsProfiles(propertyIrm.getProfiles())) continue;
                builder.putPropertyItemRules(propertyIrm);
            }
        }
        return builder.build();
    }

    private void initAspectRuleRegistry(@NonNull ActivityRuleAssistant assistant) {
        AspectRuleRegistry aspectRuleRegistry = assistant.getAspectRuleRegistry();
        BeanRuleRegistry beanRuleRegistry = assistant.getBeanRuleRegistry();
        TransletRuleRegistry transletRuleRegistry = assistant.getTransletRuleRegistry();
        for (AspectRule aspectRule : aspectRuleRegistry.getAspectRules()) {
            PointcutRule pointcutRule = aspectRule.getPointcutRule();
            if (pointcutRule == null) continue;
            Pointcut pointcut = PointcutFactory.createPointcut(pointcutRule);
            aspectRule.setPointcut(pointcut);
        }
        boolean pointcutPatternVerifiable = assistant.isPointcutPatternVerifiable();
        AspectAdviceRulePreRegister preRegister = new AspectAdviceRulePreRegister(aspectRuleRegistry);
        preRegister.setPointcutPatternVerifiable(pointcutPatternVerifiable || logger.isDebugEnabled());
        preRegister.register(beanRuleRegistry);
        preRegister.register(transletRuleRegistry);
        if (pointcutPatternVerifiable || logger.isDebugEnabled()) {
            int invalidPointcutPatterns = 0;
            for (AspectRule aspectRule : aspectRuleRegistry.getAspectRules()) {
                List<PointcutPatternRule> pointcutPatternRuleList;
                Pointcut pointcut = aspectRule.getPointcut();
                if (pointcut == null || (pointcutPatternRuleList = pointcut.getPointcutPatternRuleList()) == null) continue;
                for (PointcutPatternRule ppr : pointcutPatternRuleList) {
                    String msg;
                    PointcutPattern pp = ppr.getPointcutPattern();
                    if (pp == null) continue;
                    if (pp.getBeanIdPattern() != null && ppr.getMatchedBeanIdCount() == 0) {
                        ++invalidPointcutPatterns;
                        msg = "No beans matching to '" + pp.getBeanIdPattern() + "'; aspectRule " + String.valueOf(aspectRule);
                        if (pointcutPatternVerifiable) {
                            logger.error(msg);
                        } else if (logger.isDebugEnabled()) {
                            logger.debug(msg);
                        }
                    }
                    if (pp.getClassNamePattern() != null && ppr.getMatchedClassNameCount() == 0) {
                        ++invalidPointcutPatterns;
                        msg = "No beans matching to '@class:" + pp.getClassNamePattern() + "'; aspectRule " + String.valueOf(aspectRule);
                        if (pointcutPatternVerifiable) {
                            logger.error(msg);
                        } else if (logger.isDebugEnabled()) {
                            logger.debug(msg);
                        }
                    }
                    if (pp.getMethodNamePattern() == null || ppr.getMatchedMethodNameCount() != 0) continue;
                    ++invalidPointcutPatterns;
                    msg = "No beans have methods matching to '^" + pp.getMethodNamePattern() + "'; aspectRule " + String.valueOf(aspectRule);
                    if (pointcutPatternVerifiable) {
                        logger.error(msg);
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(msg);
                }
            }
            if (invalidPointcutPatterns > 0) {
                String msg = "Invalid pointcut detected: " + invalidPointcutPatterns + "; Please check the logs for more information";
                if (pointcutPatternVerifiable) {
                    logger.error(msg);
                    throw new InvalidPointcutPatternException(msg);
                }
                logger.debug(msg);
            }
        }
    }

    @Override
    public void clear() {
        SystemUtils.clearProperty("aspectran.basePath");
        SystemUtils.clearProperty("aspectran.workPath");
        SystemUtils.clearProperty("aspectran.tempPath");
    }

    private void checkDirectoryStructure() throws IOException {
        this.setOwnBasePath(true);
        if (this.getBasePath() == null) {
            File baseDir;
            String basePath = SystemUtils.getProperty("aspectran.basePath");
            if (StringUtils.hasText(basePath)) {
                baseDir = new File(basePath);
                if (!baseDir.isDirectory()) {
                    throw new IOException("Make sure it is a valid base directory; aspectran.basePath=" + basePath);
                }
            } else {
                this.setOwnBasePath(false);
                try {
                    String tmpDir = SystemUtils.getJavaIoTmpDir();
                    baseDir = Files.createTempDirectory(Path.of(tmpDir, new String[0]), TMP_BASE_DIRNAME_PREFIX, new FileAttribute[0]).toFile();
                    baseDir.deleteOnExit();
                }
                catch (IOException e) {
                    throw new IOException("Could not verify the base directory", e);
                }
            }
            try {
                this.setBasePath(baseDir.getCanonicalPath());
                System.setProperty("aspectran.basePath", this.getBasePath());
            }
            catch (IOException e) {
                throw new IOException("Could not verify the base directory", e);
            }
        }
        System.setProperty("aspectran.basePath", this.getBasePath());
        File workDir = null;
        String workPath = SystemUtils.getProperty("aspectran.workPath");
        if (StringUtils.hasText(workPath)) {
            workDir = new File(workPath);
        }
        if (workDir == null || !workDir.isDirectory()) {
            workDir = new File(this.getBasePath(), "work");
        }
        try {
            System.setProperty("aspectran.workPath", workDir.getCanonicalPath());
        }
        catch (Exception e) {
            logger.warn("Could not verify the working directory: " + String.valueOf(workDir));
        }
        File tempDir = null;
        String tempPath = SystemUtils.getProperty("aspectran.tempPath");
        if (StringUtils.hasText(tempPath)) {
            tempDir = new File(tempPath);
        }
        if (tempDir == null || !tempDir.isDirectory()) {
            tempDir = new File(this.getBasePath(), "temp");
        }
        try {
            System.setProperty("aspectran.tempPath", tempDir.getCanonicalPath());
        }
        catch (Exception e) {
            logger.warn("Could not verify the temporary directory: " + String.valueOf(tempDir));
        }
    }
}

