/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.builder;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.Component;
import com.aspectran.core.component.bean.BeanRuleRegistry;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.builder.AbstractActivityContextBuilder;
import com.aspectran.core.context.builder.ActivityContextBuilderException;
import com.aspectran.core.context.env.EnvironmentProfiles;
import com.aspectran.core.context.resource.SiblingClassLoader;
import com.aspectran.core.context.rule.assistant.ActivityRuleAssistant;
import com.aspectran.core.context.rule.params.AspectranParameters;
import com.aspectran.core.context.rule.parser.HybridActivityContextParser;
import com.aspectran.core.service.CoreService;
import com.aspectran.utils.Assert;
import com.aspectran.utils.ShutdownHook;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public class HybridActivityContextBuilder
extends AbstractActivityContextBuilder {
    private static final Logger logger = LoggerFactory.getLogger(HybridActivityContextBuilder.class);
    private final Object buildDestroyMonitor = new Object();
    private final AtomicBoolean active = new AtomicBoolean();
    private ShutdownHook.Manager shutdownHookManager;
    private ActivityContext activityContext;

    public HybridActivityContextBuilder() {
        this(null);
    }

    public HybridActivityContextBuilder(CoreService masterService) {
        super(masterService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityContext build(AspectranParameters aspectranParameters) throws ActivityContextBuilderException {
        Object object = this.buildDestroyMonitor;
        synchronized (object) {
            this.setAspectranParameters(aspectranParameters);
            return this.doBuild();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityContext build(String ... contextRules) throws ActivityContextBuilderException {
        Object object = this.buildDestroyMonitor;
        synchronized (object) {
            this.setContextRules(contextRules);
            return this.doBuild();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityContext build() throws ActivityContextBuilderException {
        Object object = this.buildDestroyMonitor;
        synchronized (object) {
            return this.doBuild();
        }
    }

    private ActivityContext doBuild() throws ActivityContextBuilderException {
        try {
            CoreService parentService;
            Assert.state(!this.active.get(), "ActivityContext is already configured");
            String[] contextRules = this.getContextRules();
            AspectranParameters aspectranParameters = this.getAspectranParameters();
            if (contextRules != null) {
                logger.info("Building ActivityContext with context rules [" + StringUtils.joinCommaDelimitedList(contextRules) + "]");
            } else if (aspectranParameters != null) {
                logger.info("Building ActivityContext with specified parameters");
            } else if (logger.isDebugEnabled()) {
                logger.debug("No context rules configured");
            }
            long startTime = System.currentTimeMillis();
            String contextName = this.getContextConfig() != null ? this.getContextConfig().getName() : null;
            ClassLoader parentClassLoader = null;
            if (this.getMasterService() != null && this.getMasterService().getParentService() != null && (parentService = this.getMasterService().getParentService()) != null) {
                parentClassLoader = parentService.getActivityContext().getClassLoader();
            }
            SiblingClassLoader classLoader = this.createSiblingClassLoader(contextName, parentClassLoader);
            ApplicationAdapter applicationAdapter = null;
            if (this.getMasterService() != null) {
                applicationAdapter = this.getMasterService().getApplicationAdapter();
            }
            if (applicationAdapter == null) {
                applicationAdapter = this.createApplicationAdapter();
            }
            EnvironmentProfiles environmentProfiles = this.createEnvironmentProfiles();
            ActivityRuleAssistant assistant = new ActivityRuleAssistant(classLoader, applicationAdapter, environmentProfiles);
            assistant.prepare();
            if (this.getBasePackages() != null) {
                BeanRuleRegistry beanRuleRegistry = assistant.getBeanRuleRegistry();
                beanRuleRegistry.scanConfigurableBeans(this.getBasePackages());
            }
            if (contextRules != null || aspectranParameters != null) {
                HybridActivityContextParser parser = new HybridActivityContextParser(assistant);
                parser.setEncoding(this.getEncoding());
                parser.setUseXmlToApon(this.isUseAponToLoadXml());
                parser.setDebugMode(this.isDebugMode());
                if (contextRules != null) {
                    parser.parse(contextRules);
                } else {
                    parser.parse(aspectranParameters);
                }
                assistant = parser.getContextRuleAssistant();
                assistant.clearCurrentRuleAppender();
            }
            this.activityContext = this.createActivityContext(assistant);
            assistant.release();
            if (this.getMasterService() != null) {
                this.activityContext.setMasterService(this.getMasterService());
            } else {
                ((Component)((Object)this.activityContext)).initialize();
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            logger.info("ActivityContext build completed in " + elapsedTime + " ms");
            if (this.getMasterService() != null) {
                this.startContextReloadingTimer();
            } else {
                this.registerDestroyTask();
            }
            this.active.set(true);
            return this.activityContext;
        }
        catch (Exception e) {
            throw new ActivityContextBuilderException("Failed to build ActivityContext", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.buildDestroyMonitor;
        synchronized (object) {
            this.doDestroy();
            this.removeDestroyTask();
        }
    }

    private void doDestroy() {
        if (this.active.get()) {
            this.stopContextReloadingTimer();
            if (this.activityContext != null) {
                ((Component)((Object)this.activityContext)).destroy();
                this.activityContext = null;
            }
            this.active.set(false);
        }
    }

    private void registerDestroyTask() {
        this.shutdownHookManager = ShutdownHook.Manager.create(new ShutdownHook.Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() throws Exception {
                Object object = HybridActivityContextBuilder.this.buildDestroyMonitor;
                synchronized (object) {
                    HybridActivityContextBuilder.this.doDestroy();
                }
            }

            public String toString() {
                return "Destroy " + HybridActivityContextBuilder.class.getSimpleName();
            }
        });
    }

    private void removeDestroyTask() {
        if (this.shutdownHookManager != null) {
            this.shutdownHookManager.remove();
            this.shutdownHookManager = null;
        }
    }

    @Override
    public boolean isActive() {
        return this.active.get();
    }
}

