/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.builder.reload;

import com.aspectran.core.context.builder.reload.ContextReloadingTimerTask;
import com.aspectran.core.service.ServiceLifeCycle;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.net.URL;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;

public class ContextReloadingTimer {
    private static final Logger logger = LoggerFactory.getLogger(ContextReloadingTimer.class);
    private final ServiceLifeCycle serviceLifeCycle;
    private Enumeration<URL> resources;
    private volatile Timer timer;
    private ContextReloadingTimerTask timerTask;

    public ContextReloadingTimer(ServiceLifeCycle serviceLifeCycle) {
        this.serviceLifeCycle = serviceLifeCycle;
    }

    public void setResources(Enumeration<URL> resources) {
        this.resources = resources;
    }

    public void start(int scanIntervalInSeconds) {
        this.stop();
        if (logger.isDebugEnabled()) {
            logger.debug("Starting ContextReloadingTimer...");
        }
        this.timerTask = new ContextReloadingTimerTask(this.serviceLifeCycle);
        this.timerTask.setResources(this.resources);
        this.timer = new Timer("ContextReloading");
        this.timer.schedule((TimerTask)this.timerTask, 0L, (long)scanIntervalInSeconds * 1000L);
    }

    public void stop() {
        if (this.timer != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Stopping ContextReloadingTimer...");
            }
            this.timer.cancel();
            this.timer = null;
            this.timerTask.cancel();
            this.timerTask = null;
        }
    }
}

