/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.builder.reload;

import com.aspectran.core.service.ServiceLifeCycle;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;

public class ContextReloadingTimerTask
extends TimerTask {
    private static final Logger logger = LoggerFactory.getLogger(ContextReloadingTimerTask.class);
    private final ServiceLifeCycle serviceLifeCycle;
    private final Map<String, Long> modifiedTimeMap = new HashMap<String, Long>();
    private boolean modified = false;

    public ContextReloadingTimerTask(ServiceLifeCycle serviceLifeCycle) {
        this.serviceLifeCycle = serviceLifeCycle;
    }

    public void setResources(Enumeration<URL> resources) {
        if (resources != null) {
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                try {
                    File file;
                    if ("jar".equals(url.getProtocol())) {
                        URL fileUrl = new URI(url.getFile()).toURL();
                        String[] parts = StringUtils.split(fileUrl.getFile(), "!/");
                        file = new File(parts[0]);
                    } else {
                        file = new File(url.getFile());
                    }
                    String filePath = file.getAbsolutePath();
                    this.modifiedTimeMap.put(filePath, file.lastModified());
                }
                catch (Exception e) {
                    logger.error(e);
                }
            }
        }
    }

    @Override
    public void run() {
        if (this.modified || this.modifiedTimeMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Long> entry : this.modifiedTimeMap.entrySet()) {
            File file;
            long lastModifiedTime;
            String filePath = entry.getKey();
            long prevLastModifiedTime = entry.getValue();
            if (prevLastModifiedTime == (lastModifiedTime = (file = new File(filePath)).lastModified())) continue;
            this.modified = true;
            this.modifiedTimeMap.put(filePath, lastModifiedTime);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Detected modified resource: " + filePath);
        }
        if (this.modified) {
            this.restartService();
        }
    }

    private void restartService() {
        try {
            String message = "Some resource file changes have been detected.";
            this.serviceLifeCycle.restart(message);
        }
        catch (Exception exception) {
        }
        finally {
            this.modified = false;
        }
    }
}

