/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.config;

import com.aspectran.core.context.config.ContextConfig;
import com.aspectran.core.context.config.DaemonConfig;
import com.aspectran.core.context.config.EmbedConfig;
import com.aspectran.core.context.config.SchedulerConfig;
import com.aspectran.core.context.config.ShellConfig;
import com.aspectran.core.context.config.SystemConfig;
import com.aspectran.core.context.config.WebConfig;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.SystemUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.apon.AbstractParameters;
import com.aspectran.utils.apon.AponParseException;
import com.aspectran.utils.apon.ParameterKey;
import com.aspectran.utils.apon.VariableParameters;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;

public class AspectranConfig
extends AbstractParameters {
    public static final String BASE_PATH_PROPERTY_NAME = "aspectran.basePath";
    public static final String TEMP_PATH_PROPERTY_NAME = "aspectran.tempPath";
    public static final String WORK_PATH_PROPERTY_NAME = "aspectran.workPath";
    public static final String DEFAULT_ASPECTRAN_CONFIG_FILE = "aspectran-config.apon";
    private static final ParameterKey system = new ParameterKey("system", SystemConfig.class);
    private static final ParameterKey context = new ParameterKey("context", ContextConfig.class);
    private static final ParameterKey scheduler = new ParameterKey("scheduler", SchedulerConfig.class);
    private static final ParameterKey embed = new ParameterKey("embed", EmbedConfig.class);
    private static final ParameterKey shell = new ParameterKey("shell", ShellConfig.class);
    private static final ParameterKey daemon = new ParameterKey("daemon", DaemonConfig.class);
    private static final ParameterKey web = new ParameterKey("web", WebConfig.class);
    private static final ParameterKey[] parameterKeys = new ParameterKey[]{system, context, scheduler, embed, shell, daemon, web};

    public AspectranConfig() {
        super(parameterKeys);
    }

    public AspectranConfig(String apon) throws AponParseException {
        this();
        this.readFrom(apon);
    }

    public AspectranConfig(VariableParameters parameters) throws AponParseException {
        this();
        this.readFrom(parameters);
    }

    public AspectranConfig(File configFile) throws AponParseException {
        this();
        this.readFrom(configFile);
    }

    public AspectranConfig(Reader reader) throws AponParseException {
        this();
        this.readFrom(reader);
    }

    public SystemConfig getSystemConfig() {
        return (SystemConfig)this.getParameters(system);
    }

    public SystemConfig newSystemConfig() {
        return (SystemConfig)this.newParameters(system);
    }

    public SystemConfig touchSystemConfig() {
        return (SystemConfig)this.touchParameters(system);
    }

    public boolean hasSystemConfig() {
        return this.hasValue(system);
    }

    public ContextConfig getContextConfig() {
        return (ContextConfig)this.getParameters(context);
    }

    public ContextConfig newContextConfig() {
        return (ContextConfig)this.newParameters(context);
    }

    public ContextConfig touchContextConfig() {
        return (ContextConfig)this.touchParameters(context);
    }

    public boolean hasContextConfig() {
        return this.hasValue(context);
    }

    public SchedulerConfig getSchedulerConfig() {
        return (SchedulerConfig)this.getParameters(scheduler);
    }

    public SchedulerConfig newSchedulerConfig() {
        return (SchedulerConfig)this.newParameters(scheduler);
    }

    public SchedulerConfig touchSchedulerConfig() {
        return (SchedulerConfig)this.touchParameters(scheduler);
    }

    public boolean hasSchedulerConfig() {
        return this.hasValue(scheduler);
    }

    public EmbedConfig getEmbedConfig() {
        return (EmbedConfig)this.getParameters(embed);
    }

    public EmbedConfig newEmbedConfig() {
        return (EmbedConfig)this.newParameters(embed);
    }

    public EmbedConfig touchEmbedConfig() {
        return (EmbedConfig)this.touchParameters(embed);
    }

    public ShellConfig getShellConfig() {
        return (ShellConfig)this.getParameters(shell);
    }

    public void setShellConfig(ShellConfig shellConfig) {
        this.putValue(shell, (Object)shellConfig);
    }

    public ShellConfig newShellConfig() {
        return (ShellConfig)this.newParameters(shell);
    }

    public ShellConfig touchShellConfig() {
        return (ShellConfig)this.touchParameters(shell);
    }

    public DaemonConfig getDaemonConfig() {
        return (DaemonConfig)this.getParameters(daemon);
    }

    public void setDaemonConfig(DaemonConfig daemonConfig) {
        this.putValue(daemon, (Object)daemonConfig);
    }

    public DaemonConfig newDaemonConfig() {
        return (DaemonConfig)this.newParameters(daemon);
    }

    public DaemonConfig touchDaemonConfig() {
        return (DaemonConfig)this.touchParameters(daemon);
    }

    public WebConfig getWebConfig() {
        return (WebConfig)this.getParameters(web);
    }

    public WebConfig newWebConfig() {
        return (WebConfig)this.newParameters(web);
    }

    public WebConfig touchWebConfig() {
        return (WebConfig)this.touchParameters(web);
    }

    public static String determineBasePath(@Nullable String[] args) {
        String basePath = args == null || args.length < 2 ? SystemUtils.getProperty(BASE_PATH_PROPERTY_NAME) : args[0];
        if (StringUtils.hasText(basePath)) {
            try {
                basePath = new File(basePath).getCanonicalPath();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to determine the base path", e);
            }
        } else {
            basePath = null;
        }
        return basePath;
    }

    @NonNull
    public static File determineAspectranConfigFile(@Nullable String[] args) {
        File file;
        if (args == null || args.length == 0) {
            String basePath = SystemUtils.getProperty(BASE_PATH_PROPERTY_NAME);
            file = StringUtils.hasText(basePath) ? new File(basePath, DEFAULT_ASPECTRAN_CONFIG_FILE) : new File(DEFAULT_ASPECTRAN_CONFIG_FILE);
            if (!file.exists()) {
                throw new IllegalArgumentException("No Aspectran Configuration file provided");
            }
        } else if (args.length == 1) {
            String baseDir = SystemUtils.getProperty(BASE_PATH_PROPERTY_NAME);
            if (baseDir != null) {
                Path basePath = Paths.get(baseDir, new String[0]);
                Path filePath = Paths.get(args[0], new String[0]);
                file = filePath.startsWith(basePath) && filePath.isAbsolute() ? filePath.toFile() : new File(baseDir, args[0]);
            } else {
                file = new File(args[0]);
            }
        } else {
            file = new File(args[0], args[1]);
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to determine the aspectran config file", e);
        }
    }
}

