/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.config;

import com.aspectran.core.context.config.ContextAutoReloadConfig;
import com.aspectran.core.context.config.ContextProfilesConfig;
import com.aspectran.core.context.rule.params.AspectranParameters;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.apon.AbstractParameters;
import com.aspectran.utils.apon.ParameterKey;
import com.aspectran.utils.apon.ValueType;

public class ContextConfig
extends AbstractParameters {
    private static final ParameterKey name = new ParameterKey("name", ValueType.STRING);
    private static final ParameterKey base = new ParameterKey("base", ValueType.STRING);
    private static final ParameterKey rules = new ParameterKey("rules", ValueType.STRING, true);
    private static final ParameterKey encoding = new ParameterKey("encoding", ValueType.STRING);
    private static final ParameterKey resources = new ParameterKey("resources", ValueType.STRING, true);
    private static final ParameterKey scan = new ParameterKey("scan", ValueType.STRING, true);
    private static final ParameterKey profiles = new ParameterKey("profiles", ContextProfilesConfig.class);
    private static final ParameterKey autoReload = new ParameterKey("autoReload", ContextAutoReloadConfig.class);
    private static final ParameterKey singleton = new ParameterKey("singleton", ValueType.BOOLEAN);
    private static final ParameterKey parameters = new ParameterKey("parameters", AspectranParameters.class);
    private static final ParameterKey[] parameterKeys = new ParameterKey[]{name, base, rules, encoding, resources, scan, profiles, autoReload, singleton, parameters};

    public ContextConfig() {
        super(parameterKeys);
    }

    public String getName() {
        return this.getString(name);
    }

    public ContextConfig setName(String name) {
        if (StringUtils.hasText(name)) {
            this.putValue(ContextConfig.name, (Object)name);
        } else if (this.hasValue(name)) {
            this.removeValue(ContextConfig.name);
        }
        return this;
    }

    public String getBasePath() {
        return this.getString(base);
    }

    public boolean hasBasePath() {
        return this.hasValue(base);
    }

    public ContextConfig setBasePath(String basePath) {
        if (StringUtils.hasText(basePath)) {
            this.putValue(base, (Object)basePath);
        } else if (this.hasValue(base)) {
            this.removeValue(base);
        }
        return this;
    }

    public String[] getContextRules() {
        return this.getStringArray(rules);
    }

    public ContextConfig setContextRules(String[] contextRules) {
        this.removeValue(rules);
        this.putValue(rules, (Object)contextRules);
        return this;
    }

    public ContextConfig addContextRule(String contextRule) {
        this.putValue(rules, (Object)contextRule);
        return this;
    }

    public String getEncoding() {
        return this.getString(encoding);
    }

    public ContextConfig setEncoding(String encoding) {
        this.putValue(ContextConfig.encoding, (Object)encoding);
        return this;
    }

    public String[] getResourceLocations() {
        return this.getStringArray(resources);
    }

    public ContextConfig setResourceLocations(String[] resourceLocations) {
        this.removeValue(resources);
        this.putValue(resources, (Object)resourceLocations);
        return this;
    }

    public ContextConfig addResourceLocation(String resourceLocation) {
        this.putValue(resources, (Object)resourceLocation);
        return this;
    }

    public String[] getBasePackages() {
        return this.getStringArray(scan);
    }

    public ContextConfig setBasePackage(String[] basePackages) {
        this.removeValue(scan);
        this.putValue(scan, (Object)basePackages);
        return this;
    }

    public ContextConfig addBasePackage(String basePackage) {
        this.putValue(scan, (Object)basePackage);
        return this;
    }

    public ContextProfilesConfig getProfilesConfig() {
        return (ContextProfilesConfig)this.getParameters(profiles);
    }

    public ContextProfilesConfig newProfilesConfig() {
        return (ContextProfilesConfig)this.newParameters(profiles);
    }

    public ContextProfilesConfig touchProfilesConfig() {
        return (ContextProfilesConfig)this.touchParameters(profiles);
    }

    public boolean hasProfilesConfig() {
        return this.hasValue(profiles);
    }

    public ContextAutoReloadConfig getAutoReloadConfig() {
        return (ContextAutoReloadConfig)this.getParameters(autoReload);
    }

    public ContextAutoReloadConfig newAutoReloadConfig() {
        return (ContextAutoReloadConfig)this.newParameters(autoReload);
    }

    public ContextAutoReloadConfig touchAutoReloadConfig() {
        return (ContextAutoReloadConfig)this.touchParameters(autoReload);
    }

    public boolean isSingleton() {
        return this.getBoolean(singleton, false);
    }

    public ContextConfig setSingleton(boolean singleton) {
        this.putValue(ContextConfig.singleton, (Object)singleton);
        return this;
    }

    public AspectranParameters getAspectranParameters() {
        return (AspectranParameters)this.getParameters(parameters);
    }

    public AspectranParameters newAspectranParameters() {
        return (AspectranParameters)this.newParameters(parameters);
    }

    public AspectranParameters touchAspectranParameters() {
        return (AspectranParameters)this.touchParameters(parameters);
    }

    public boolean hasAspectranParameters() {
        return this.hasValue(parameters);
    }
}

