/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.config;

import com.aspectran.utils.apon.AbstractParameters;
import com.aspectran.utils.apon.ParameterKey;
import com.aspectran.utils.apon.ValueType;

public class SessionFileStoreConfig
extends AbstractParameters {
    private static final ParameterKey storeDir = new ParameterKey("storeDir", ValueType.STRING);
    private static final ParameterKey gracePeriodSeconds = new ParameterKey("gracePeriodSeconds", ValueType.INT);
    private static final ParameterKey savePeriodSeconds = new ParameterKey("savePeriodSeconds", ValueType.INT);
    private static final ParameterKey deleteUnrestorableFiles = new ParameterKey("deleteUnrestorableFiles", ValueType.BOOLEAN);
    private static final ParameterKey nonPersistentAttributes = new ParameterKey("nonPersistentAttributes", ValueType.STRING, true);
    private static final ParameterKey[] parameterKeys = new ParameterKey[]{storeDir, gracePeriodSeconds, deleteUnrestorableFiles, nonPersistentAttributes};

    public SessionFileStoreConfig() {
        super(parameterKeys);
    }

    public String getStoreDir() {
        return this.getString(storeDir);
    }

    public SessionFileStoreConfig setStoreDir(String storeDir) {
        this.putValue(SessionFileStoreConfig.storeDir, (Object)storeDir);
        return this;
    }

    public int getGracePeriodSeconds() {
        return this.getInt(gracePeriodSeconds, 0);
    }

    public SessionFileStoreConfig setGracePeriodSeconds(int gracePeriodSeconds) {
        this.putValue(SessionFileStoreConfig.gracePeriodSeconds, (Object)gracePeriodSeconds);
        return this;
    }

    public boolean hasGracePeriodSeconds() {
        return this.hasValue(gracePeriodSeconds);
    }

    public int getSavePeriodSeconds() {
        return this.getInt(savePeriodSeconds, 0);
    }

    public SessionFileStoreConfig setSavePeriodSeconds(int savePeriodSeconds) {
        this.putValue(SessionFileStoreConfig.savePeriodSeconds, (Object)savePeriodSeconds);
        return this;
    }

    public boolean hasSavePeriodSeconds() {
        return this.hasValue(savePeriodSeconds);
    }

    public boolean isDeleteUnrestorableFiles() {
        return this.getBoolean(deleteUnrestorableFiles, false);
    }

    public SessionFileStoreConfig setDeleteUnrestorableFiles(boolean deleteUnrestorableFiles) {
        this.putValue(SessionFileStoreConfig.deleteUnrestorableFiles, (Object)deleteUnrestorableFiles);
        return this;
    }

    public boolean hasDeleteUnrestorableFiles() {
        return this.hasValue(deleteUnrestorableFiles);
    }

    public String[] getNonPersistentAttributes() {
        return this.getStringArray(nonPersistentAttributes);
    }

    public SessionFileStoreConfig setNonPersistentAttributes(String[] nonPersistentAttributes) {
        this.removeValue(SessionFileStoreConfig.nonPersistentAttributes);
        this.putValue(SessionFileStoreConfig.nonPersistentAttributes, (Object)nonPersistentAttributes);
        return this;
    }

    public SessionFileStoreConfig addNonPersistentAttributes(String nonPersistentAttribute) {
        this.putValue(nonPersistentAttributes, (Object)nonPersistentAttribute);
        return this;
    }

    public boolean hasNonPersistentAttributes() {
        return this.hasValue(nonPersistentAttributes);
    }
}

