/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.config;

import com.aspectran.core.context.config.SessionFileStoreConfig;
import com.aspectran.utils.apon.AbstractParameters;
import com.aspectran.utils.apon.AponParseException;
import com.aspectran.utils.apon.ParameterKey;
import com.aspectran.utils.apon.ValueType;
import com.aspectran.utils.apon.VariableParameters;

public class SessionManagerConfig
extends AbstractParameters {
    private static final ParameterKey workerName = new ParameterKey("workerName", ValueType.STRING);
    private static final ParameterKey maxActiveSessions = new ParameterKey("maxActiveSessions", ValueType.INT);
    private static final ParameterKey maxIdleSeconds = new ParameterKey("maxIdleSeconds", ValueType.INT);
    private static final ParameterKey evictionIdleSeconds = new ParameterKey("evictionIdleSeconds", ValueType.INT);
    private static final ParameterKey scavengingIntervalSeconds = new ParameterKey("scavengingIntervalSeconds", ValueType.INT);
    private static final ParameterKey saveOnCreate = new ParameterKey("saveOnCreate", ValueType.BOOLEAN);
    private static final ParameterKey saveOnInactiveEviction = new ParameterKey("saveOnInactiveEviction", ValueType.BOOLEAN);
    private static final ParameterKey removeUnloadableSessions = new ParameterKey("removeUnloadableSessions", ValueType.BOOLEAN);
    private static final ParameterKey fileStore = new ParameterKey("fileStore", SessionFileStoreConfig.class);
    private static final ParameterKey clusterEnabled = new ParameterKey("clusterEnabled", ValueType.BOOLEAN);
    private static final ParameterKey enabled = new ParameterKey("enabled", ValueType.BOOLEAN);
    private static final ParameterKey[] parameterKeys = new ParameterKey[]{workerName, maxActiveSessions, maxIdleSeconds, evictionIdleSeconds, scavengingIntervalSeconds, saveOnCreate, saveOnInactiveEviction, removeUnloadableSessions, fileStore, clusterEnabled, enabled};

    public SessionManagerConfig() {
        super(parameterKeys);
    }

    public SessionManagerConfig(String apon) throws AponParseException {
        super(parameterKeys);
        this.readFrom(apon);
    }

    public SessionManagerConfig(VariableParameters parameters) throws AponParseException {
        this();
        this.readFrom(parameters);
    }

    public String getWorkerName() {
        return this.getString(workerName);
    }

    public SessionManagerConfig setWorkerName(String workerName) {
        this.putValue(SessionManagerConfig.workerName, (Object)workerName);
        return this;
    }

    public boolean hasWorkerName() {
        return this.hasValue(workerName);
    }

    public int getMaxActiveSessions() {
        return this.getInt(maxActiveSessions, 0);
    }

    public SessionManagerConfig setMaxActiveSessions(int maxActiveSessions) {
        this.putValue(SessionManagerConfig.maxActiveSessions, (Object)maxActiveSessions);
        return this;
    }

    public boolean hasMaxActiveSessions() {
        return this.hasValue(maxActiveSessions);
    }

    public int getMaxIdleSeconds() {
        return this.getInt(maxIdleSeconds, -1);
    }

    public SessionManagerConfig setMaxIdleSeconds(int maxIdleSeconds) {
        this.putValue(SessionManagerConfig.maxIdleSeconds, (Object)maxIdleSeconds);
        return this;
    }

    public boolean hasMaxIdleSeconds() {
        return this.hasValue(maxIdleSeconds);
    }

    public int getEvictionIdleSeconds() {
        return this.getInt(evictionIdleSeconds, -1);
    }

    public SessionManagerConfig setEvictionIdleSeconds(int evictionIdleSeconds) {
        this.putValue(SessionManagerConfig.evictionIdleSeconds, (Object)evictionIdleSeconds);
        return this;
    }

    public boolean hasEvictionIdleSeconds() {
        return this.hasValue(evictionIdleSeconds);
    }

    public int getScavengingIntervalSeconds() {
        return this.getInt(scavengingIntervalSeconds, 0);
    }

    public SessionManagerConfig setScavengingIntervalSeconds(int scavengingIntervalSeconds) {
        this.putValue(SessionManagerConfig.scavengingIntervalSeconds, (Object)scavengingIntervalSeconds);
        return this;
    }

    public boolean hasScavengingIntervalSeconds() {
        return this.hasValue(scavengingIntervalSeconds);
    }

    public boolean getSaveOnCreate() {
        return this.getBoolean(saveOnCreate, false);
    }

    public SessionManagerConfig setSaveOnCreate(boolean saveOnCreate) {
        this.putValue(SessionManagerConfig.saveOnCreate, (Object)saveOnCreate);
        return this;
    }

    public boolean hasSaveOnCreate() {
        return this.hasValue(saveOnCreate);
    }

    public boolean getSaveOnInactiveEviction() {
        return this.getBoolean(saveOnInactiveEviction, false);
    }

    public SessionManagerConfig setSaveOnInactiveEviction(boolean saveOnInactiveEviction) {
        this.putValue(SessionManagerConfig.saveOnInactiveEviction, (Object)saveOnInactiveEviction);
        return this;
    }

    public boolean hasSaveOnInactiveEviction() {
        return this.hasValue(saveOnInactiveEviction);
    }

    public boolean getRemoveUnloadableSessions() {
        return this.getBoolean(removeUnloadableSessions, false);
    }

    public SessionManagerConfig setRemoveUnloadableSessions(boolean removeUnloadableSessions) {
        this.putValue(SessionManagerConfig.removeUnloadableSessions, (Object)removeUnloadableSessions);
        return this;
    }

    public boolean hasRemoveUnloadableSessions() {
        return this.hasValue(removeUnloadableSessions);
    }

    public SessionFileStoreConfig getFileStoreConfig() {
        return (SessionFileStoreConfig)this.getParameters(fileStore);
    }

    public SessionFileStoreConfig newFileStoreConfig() {
        return (SessionFileStoreConfig)this.newParameters(fileStore);
    }

    public SessionFileStoreConfig touchFileStoreConfig() {
        return (SessionFileStoreConfig)this.touchParameters(fileStore);
    }

    public boolean isClusterEnabled() {
        return this.getBoolean(clusterEnabled, false);
    }

    public SessionManagerConfig setClusterEnabled(boolean clusterEnabled) {
        this.putValue(SessionManagerConfig.clusterEnabled, (Object)clusterEnabled);
        return this;
    }

    public boolean isEnabled() {
        return this.getBoolean(enabled, true);
    }

    public SessionManagerConfig setEnabled(boolean enabled) {
        this.putValue(SessionManagerConfig.enabled, (Object)enabled);
        return this;
    }
}

