/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.config;

import com.aspectran.core.context.config.AcceptableConfig;
import com.aspectran.core.context.config.SessionManagerConfig;
import com.aspectran.core.context.config.ShellStyleConfig;
import com.aspectran.utils.apon.AbstractParameters;
import com.aspectran.utils.apon.ParameterKey;
import com.aspectran.utils.apon.ValueType;

public class ShellConfig
extends AbstractParameters {
    private static final ParameterKey style = new ParameterKey("style", ShellStyleConfig.class);
    private static final ParameterKey greetings = new ParameterKey("greetings", ValueType.TEXT);
    private static final ParameterKey prompt = new ParameterKey("prompt", ValueType.STRING);
    private static final ParameterKey commands = new ParameterKey("commands", ValueType.STRING, true);
    private static final ParameterKey session = new ParameterKey("session", SessionManagerConfig.class);
    private static final ParameterKey historyFile = new ParameterKey("historyFile", ValueType.STRING);
    private static final ParameterKey verbose = new ParameterKey("verbose", ValueType.BOOLEAN);
    private static final ParameterKey acceptable = new ParameterKey("acceptable", AcceptableConfig.class);
    private static final ParameterKey[] parameterKeys = new ParameterKey[]{style, greetings, prompt, commands, session, historyFile, verbose, acceptable};

    public ShellConfig() {
        super(parameterKeys);
    }

    public ShellStyleConfig getShellStyleConfig() {
        return (ShellStyleConfig)this.getParameters(style);
    }

    public ShellStyleConfig newShellStyleConfig() {
        return (ShellStyleConfig)this.newParameters(style);
    }

    public SessionManagerConfig touchShellStyleConfig() {
        return (SessionManagerConfig)this.touchParameters(style);
    }

    public String getGreetings() {
        return this.getString(greetings);
    }

    public ShellConfig setGreetings(String greetings) {
        this.putValue(ShellConfig.greetings, (Object)greetings);
        return this;
    }

    public String getPrompt() {
        return this.getString(prompt);
    }

    public ShellConfig setPrompt(String prompt) {
        this.putValue(ShellConfig.prompt, (Object)prompt);
        return this;
    }

    public String[] getCommands() {
        return this.getStringArray(commands);
    }

    public ShellConfig setCommands(String[] commands) {
        this.removeValue(ShellConfig.commands);
        this.putValue(ShellConfig.commands, (Object)commands);
        return this;
    }

    public ShellConfig addCommand(String command) {
        this.putValue(commands, (Object)command);
        return this;
    }

    public SessionManagerConfig getSessionManagerConfig() {
        return (SessionManagerConfig)this.getParameters(session);
    }

    public SessionManagerConfig newSessionManagerConfig() {
        return (SessionManagerConfig)this.newParameters(session);
    }

    public SessionManagerConfig touchSessionManagerConfig() {
        return (SessionManagerConfig)this.touchParameters(session);
    }

    public String getHistoryFile() {
        return this.getString(historyFile);
    }

    public ShellConfig setHistoryFile(String historyFile) {
        this.putValue(ShellConfig.historyFile, (Object)historyFile);
        return this;
    }

    public boolean isVerbose() {
        return this.getBoolean(verbose, false);
    }

    public ShellConfig setVerbose(boolean verbose) {
        this.putValue(ShellConfig.verbose, (Object)verbose);
        return this;
    }

    public AcceptableConfig getAcceptableConfig() {
        return (AcceptableConfig)this.getParameters(acceptable);
    }

    public AcceptableConfig newAcceptableConfig() {
        return (AcceptableConfig)this.newParameters(acceptable);
    }

    public AcceptableConfig touchAcceptableConfig() {
        return (AcceptableConfig)this.touchParameters(acceptable);
    }
}

