/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.env;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.env.Environment;
import com.aspectran.core.context.env.EnvironmentProfiles;
import com.aspectran.core.context.env.Profiles;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import java.util.Iterator;

public class ActivityEnvironment
implements Environment {
    private final ActivityContext context;
    private final EnvironmentProfiles environmentProfiles;
    private final ItemRuleMap propertyItemRuleMap = new ItemRuleMap();

    public ActivityEnvironment(ActivityContext context, EnvironmentProfiles environmentProfiles) {
        this.context = context;
        this.environmentProfiles = environmentProfiles;
    }

    @Override
    public String[] getActiveProfiles() {
        return this.environmentProfiles.getActiveProfiles();
    }

    @Override
    public String[] getDefaultProfiles() {
        return this.environmentProfiles.getDefaultProfiles();
    }

    @Override
    public String[] getCurrentProfiles() {
        String[] activeProfiles = this.getActiveProfiles();
        if (activeProfiles.length > 0) {
            return activeProfiles;
        }
        return this.getDefaultProfiles();
    }

    @Override
    public boolean matchesProfiles(String profileExpression) {
        return this.environmentProfiles.matchesProfiles(profileExpression);
    }

    @Override
    public boolean acceptsProfiles(Profiles profiles) {
        return this.environmentProfiles.acceptsProfiles(profiles);
    }

    @Override
    public boolean acceptsProfiles(String ... profiles) {
        return this.environmentProfiles.acceptsProfiles(profiles);
    }

    @Override
    public void addActiveProfile(String profile) {
        this.environmentProfiles.addActiveProfile(profile);
    }

    @Override
    public <T> T getProperty(String name) {
        return this.getProperty(name, this.context.getAvailableActivity());
    }

    @Override
    public <T> T getProperty(String name, Activity activity) {
        ItemRule itemRule = (ItemRule)this.propertyItemRuleMap.get(name);
        if (itemRule != null) {
            return (T)activity.getItemEvaluator().evaluate(itemRule);
        }
        return null;
    }

    @Override
    public Iterator<String> getPropertyNames() {
        return this.propertyItemRuleMap.keySet().iterator();
    }

    protected void putPropertyItemRule(ItemRule propertyItemRule) {
        this.propertyItemRuleMap.putItemRule(propertyItemRule);
    }
}

