/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.env;

import com.aspectran.core.context.env.Profiles;
import com.aspectran.utils.Assert;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.SystemUtils;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.util.LinkedHashSet;
import java.util.Set;

public class EnvironmentProfiles {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentProfiles.class);
    public static final String ACTIVE_PROFILES_PROPERTY_NAME = "aspectran.profiles.active";
    public static final String DEFAULT_PROFILES_PROPERTY_NAME = "aspectran.profiles.default";
    private final Set<String> activeProfiles = new LinkedHashSet<String>();
    private final Set<String> defaultProfiles = new LinkedHashSet<String>();

    public String[] getActiveProfiles() {
        return StringUtils.toStringArray(this.doGetActiveProfiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> doGetActiveProfiles() {
        Set<String> set = this.activeProfiles;
        synchronized (set) {
            String[] profiles;
            if (this.activeProfiles.isEmpty() && (profiles = this.doGetActiveProfilesProperty()) != null) {
                this.setActiveProfiles(profiles);
            }
            return this.activeProfiles;
        }
    }

    private String[] doGetActiveProfilesProperty() {
        return this.getProfilesFromSystemProperty(ACTIVE_PROFILES_PROPERTY_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveProfiles(String ... profiles) {
        Assert.notNull((Object)profiles, "profiles must not be null");
        logger.info("Activating profiles [" + StringUtils.joinCommaDelimitedList(profiles) + "]");
        Set<String> set = this.activeProfiles;
        synchronized (set) {
            this.activeProfiles.clear();
            for (String profile : profiles) {
                this.validateProfile(profile);
                this.activeProfiles.add(profile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActiveProfile(String profile) {
        logger.info("Activating profile '" + profile + "'");
        this.validateProfile(profile);
        this.doGetActiveProfiles();
        Set<String> set = this.activeProfiles;
        synchronized (set) {
            this.activeProfiles.add(profile);
        }
    }

    public String[] getDefaultProfiles() {
        return StringUtils.toStringArray(this.doGetDefaultProfiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> doGetDefaultProfiles() {
        Set<String> set = this.defaultProfiles;
        synchronized (set) {
            String[] profiles;
            if (this.defaultProfiles.isEmpty() && (profiles = this.doGetDefaultProfilesProperty()) != null) {
                this.setDefaultProfiles(profiles);
            }
            return this.defaultProfiles;
        }
    }

    private String[] doGetDefaultProfilesProperty() {
        return this.getProfilesFromSystemProperty(DEFAULT_PROFILES_PROPERTY_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultProfiles(String ... profiles) {
        Assert.notNull((Object)profiles, "profiles must not be null");
        logger.info("Default profiles [" + StringUtils.joinCommaDelimitedList(profiles) + "]");
        Set<String> set = this.defaultProfiles;
        synchronized (set) {
            this.defaultProfiles.clear();
            for (String profile : profiles) {
                this.validateProfile(profile);
                this.defaultProfiles.add(profile);
            }
        }
    }

    public boolean matchesProfiles(String profileExpression) {
        return this.acceptsProfiles(Profiles.of(profileExpression));
    }

    public boolean acceptsProfiles(Profiles profiles) {
        return profiles == null || profiles.matches(this::isProfileActive);
    }

    public boolean acceptsProfiles(String ... profiles) {
        if (profiles == null || profiles.length == 0) {
            return true;
        }
        for (String profile : profiles) {
            if (!(StringUtils.hasLength(profile) && profile.charAt(0) == '!' ? !this.isProfileActive(profile.substring(1)) : this.isProfileActive(profile))) continue;
            return true;
        }
        return false;
    }

    private boolean isProfileActive(String profile) {
        this.validateProfile(profile);
        Set<String> currentActiveProfiles = this.doGetActiveProfiles();
        return currentActiveProfiles.contains(profile) || currentActiveProfiles.isEmpty() && this.doGetDefaultProfiles().contains(profile);
    }

    private void validateProfile(String profile) {
        if (!StringUtils.hasText(profile)) {
            throw new IllegalArgumentException("Invalid profile [" + profile + "]: must contain text");
        }
        if (profile.charAt(0) == '!') {
            throw new IllegalArgumentException("Invalid profile [" + profile + "]: must not begin with ! operator");
        }
    }

    @Nullable
    private String[] getProfilesFromSystemProperty(String propName) {
        String[] profiles;
        String profilesProp = SystemUtils.getProperty(propName);
        if (profilesProp != null && (profiles = StringUtils.splitCommaDelimitedString(profilesProp)).length > 0) {
            return profiles;
        }
        return null;
    }
}

