/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.env;

import com.aspectran.core.context.env.Profiles;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Predicate;

final class ProfilesParser {
    private ProfilesParser() {
    }

    @NonNull
    static Profiles parse(String expression) {
        Profiles parsed = ProfilesParser.parseExpression(expression);
        return new ParsedProfiles(expression, parsed);
    }

    private static Profiles parseExpression(String expression) {
        Assert.hasText(expression, () -> "Invalid profile expression \"" + expression + "\": must contain text");
        StringTokenizer tokens = new StringTokenizer(expression, "()[]!, ", true);
        return ProfilesParser.parseTokens(expression, tokens);
    }

    private static Profiles parseTokens(String expression, StringTokenizer tokens) {
        return ProfilesParser.parseTokens(expression, tokens, Operator.NONE);
    }

    private static Profiles parseTokens(String expression, @NonNull StringTokenizer tokens, Operator operator) {
        ArrayList<Profiles> elements = new ArrayList<Profiles>();
        String token = null;
        int count = 0;
        block15: while (tokens.hasMoreTokens()) {
            token = tokens.nextToken().trim();
            if (token.isEmpty()) continue;
            switch (token) {
                case "(": 
                case "[": {
                    Operator nested = "(".equals(token) ? Operator.AND : Operator.OR;
                    Profiles contents = ProfilesParser.parseTokens(expression, tokens, nested);
                    if (operator == Operator.NEGATE) {
                        return contents;
                    }
                    ProfilesParser.assertWellFormed(expression, elements, count);
                    elements.add(contents);
                    continue block15;
                }
                case ")": {
                    ProfilesParser.assertWellFormed(expression, operator, Operator.AND, token);
                    return ProfilesParser.merge(expression, elements, operator);
                }
                case "]": {
                    ProfilesParser.assertWellFormed(expression, operator, Operator.OR, token);
                    return ProfilesParser.merge(expression, elements, operator);
                }
                case "!": {
                    elements.add(ProfilesParser.not(ProfilesParser.parseTokens(expression, tokens, Operator.NEGATE)));
                    continue block15;
                }
                case ",": {
                    ++count;
                    continue block15;
                }
            }
            Profiles value = ProfilesParser.equals(token);
            if (operator == Operator.NEGATE) {
                return value;
            }
            ProfilesParser.assertWellFormed(expression, elements, count);
            elements.add(value);
        }
        ProfilesParser.assertWellFormed(expression, Operator.NONE, operator, token);
        return ProfilesParser.merge(expression, elements, Operator.OR);
    }

    private static Profiles merge(String expression, @NonNull List<Profiles> elements, Operator operator) {
        ProfilesParser.assertWellFormed(expression, !elements.isEmpty(), "");
        if (elements.size() == 1) {
            return elements.get(0);
        }
        Profiles[] profiles = elements.toArray(new Profiles[0]);
        return operator == Operator.AND ? ProfilesParser.and(profiles) : ProfilesParser.or(profiles);
    }

    private static void assertWellFormed(String expression, Operator expected, Operator actual, String token) {
        Assert.isTrue(expected == actual, () -> {
            Object message = null;
            if (actual == Operator.NEGATE) {
                message = "inappropriate use of negation operator; \u2018!\u2019 cannot be used alone";
            } else if (actual == Operator.AND && expected == Operator.OR) {
                message = "missing closing parenthesis of " + String.valueOf((Object)expected) + " set; must be closed with ']', but ')'";
            } else if (actual == Operator.OR && expected == Operator.AND) {
                message = "missing closing parenthesis of " + String.valueOf((Object)expected) + " set; must be closed with ')', but ']'";
            } else if (token != null) {
                message = "unnecessary operator '" + token + "'";
            }
            return "Malformed profile expression \"" + expression + "\"" + (String)(message != null ? ": " + (String)message : "");
        });
    }

    private static void assertWellFormed(String expression, @NonNull List<Profiles> elements, int size) {
        ProfilesParser.assertWellFormed(expression, elements.size() == size, "each profile or set of them must be separated by commas (',')");
    }

    private static void assertWellFormed(String expression, boolean wellFormed, String message) {
        Assert.isTrue(wellFormed, () -> "Malformed profile expression \"" + expression + "\": " + message);
    }

    @NonNull
    private static Profiles or(Profiles ... profiles) {
        return activeProfile -> Arrays.stream(profiles).anyMatch(ProfilesParser.isMatch(activeProfile));
    }

    @NonNull
    private static Profiles and(Profiles ... profiles) {
        return activeProfile -> Arrays.stream(profiles).allMatch(ProfilesParser.isMatch(activeProfile));
    }

    @NonNull
    private static Profiles not(Profiles profiles) {
        return activeProfile -> !profiles.matches(activeProfile);
    }

    @NonNull
    private static Profiles equals(String profile) {
        return activeProfile -> activeProfile.test(profile);
    }

    @NonNull
    private static Predicate<Profiles> isMatch(Predicate<String> activeProfiles) {
        return profiles -> profiles.matches(activeProfiles);
    }

    private static class ParsedProfiles
    implements Profiles {
        private final String expression;
        private final Profiles parsed;

        ParsedProfiles(String expression, Profiles parsed) {
            this.expression = expression;
            this.parsed = parsed;
        }

        @Override
        public boolean matches(Predicate<String> activeProfiles) {
            return this.parsed.matches(activeProfiles);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof ParsedProfiles) {
                ParsedProfiles that = (ParsedProfiles)other;
                return this.expression.equals(that.expression);
            }
            return false;
        }

        public int hashCode() {
            return this.expression.hashCode();
        }

        public String toString() {
            return this.expression;
        }
    }

    private static enum Operator {
        NONE,
        AND,
        OR,
        NEGATE;

    }
}

