/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.resource;

import com.aspectran.core.context.resource.InvalidResourceException;
import com.aspectran.core.context.resource.ResourceManager;
import com.aspectran.core.context.resource.SiblingClassLoader;
import com.aspectran.utils.FileCopyUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.SystemUtils;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;

public class LocalResourceManager
extends ResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(LocalResourceManager.class);
    private static final String WORK_RESOURCE_DIRNAME_PREFIX = "_resource_";
    private final String resourceLocation;
    private final int resourceNameStart;
    private final SiblingClassLoader owner;

    LocalResourceManager(SiblingClassLoader owner) throws InvalidResourceException {
        this(owner, null);
    }

    LocalResourceManager(SiblingClassLoader owner, String resourceLocation) throws InvalidResourceException {
        this.owner = owner;
        if (StringUtils.hasLength(resourceLocation)) {
            File file = new File(resourceLocation);
            if (!file.exists() || !file.canRead()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Non-existent or inaccessible resource location: " + resourceLocation);
                }
                this.resourceLocation = null;
                this.resourceNameStart = 0;
                return;
            }
            if (!file.isDirectory() && !resourceLocation.toLowerCase().endsWith(".jar")) {
                throw new InvalidResourceException("Invalid resource directory or jar file: " + file.getAbsolutePath());
            }
            this.resourceLocation = file.getAbsolutePath();
            this.resourceNameStart = this.resourceLocation.length() + 1;
            this.findResource(file);
        } else {
            this.resourceLocation = null;
            this.resourceNameStart = 0;
        }
        if (owner.isRoot()) {
            boolean sweepable = true;
            for (ClassLoader parent = owner.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof SiblingClassLoader)) continue;
                sweepable = false;
                break;
            }
            if (sweepable) {
                this.sweepWorkResourceFiles();
            }
        }
    }

    @Override
    public void reset() throws InvalidResourceException {
        super.reset();
        if (this.resourceLocation != null) {
            this.findResource(new File(this.resourceLocation));
        }
    }

    private void findResource(File file) throws InvalidResourceException {
        try {
            if (file.isDirectory()) {
                ArrayList<File> jarFileList = new ArrayList<File>();
                this.findResourceInDir(file, jarFileList);
                if (!jarFileList.isEmpty()) {
                    for (File jarFile : jarFileList) {
                        this.owner.joinSibling(jarFile.getAbsolutePath());
                    }
                }
            } else {
                this.findResourceFromJAR(file);
            }
        }
        catch (Exception e) {
            throw new InvalidResourceException("Failed to find resource from [" + this.resourceLocation + "]", e);
        }
    }

    private void findResourceInDir(@NonNull File dir, List<File> jarFileList) {
        dir.listFiles(file -> {
            String filePath = file.getAbsolutePath();
            String resourceName = filePath.substring(this.resourceNameStart);
            try {
                this.putResource(resourceName, file);
            }
            catch (InvalidResourceException e) {
                throw new RuntimeException(e);
            }
            if (file.isDirectory()) {
                this.findResourceInDir(file, jarFileList);
            } else if (file.isFile() && filePath.toLowerCase().endsWith(".jar")) {
                jarFileList.add(file);
            }
            return false;
        });
    }

    private void findResourceFromJAR(File target) throws InvalidResourceException, IOException {
        Path workDir;
        String workPath = SystemUtils.getProperty("aspectran.workPath");
        File workResourceDir = null;
        if (workPath != null && Files.isDirectory(workDir = Path.of(workPath, new String[0]), new LinkOption[0]) && Files.isWritable(workDir)) {
            workResourceDir = Files.createTempDirectory(workDir, WORK_RESOURCE_DIRNAME_PREFIX, new FileAttribute[0]).toFile();
        }
        if (workResourceDir == null) {
            workResourceDir = Files.createTempDirectory(WORK_RESOURCE_DIRNAME_PREFIX, new FileAttribute[0]).toFile();
        }
        FileCopyUtils.copyFileToDirectory(target, workResourceDir);
        File workResourceFile = new File(workResourceDir, target.getName());
        try (JarFile jarFile = new JarFile(workResourceFile);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                this.putResource(workResourceFile, entry);
            }
        }
        workResourceDir.deleteOnExit();
        workResourceFile.deleteOnExit();
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.appendForce("resourceLocation", this.resourceLocation);
        tsb.append("numberOfResources", this.getNumberOfResources());
        tsb.append("owner", this.owner);
        return tsb.toString();
    }

    private void sweepWorkResourceFiles() {
        Path workDir;
        String workPath = SystemUtils.getProperty("aspectran.workPath");
        if (workPath != null && Files.isDirectory(workDir = Path.of(workPath, new String[0]), new LinkOption[0])) {
            if (logger.isDebugEnabled()) {
                logger.debug("Sweeping " + String.valueOf(workDir.toAbsolutePath()) + File.separatorChar + "_resource_* for old resource files");
            }
            try (Stream<Path> stream = Files.walk(workDir, 1, FileVisitOption.FOLLOW_LINKS);){
                stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().startsWith(WORK_RESOURCE_DIRNAME_PREFIX)).forEach(p -> {
                    try (Stream<Path> stream2 = Files.walk(p, new FileVisitOption[0]);){
                        stream2.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(file -> {
                            if (logger.isTraceEnabled()) {
                                logger.trace("Delete temp resource: " + String.valueOf(file));
                            }
                            file.delete();
                        });
                    }
                    catch (IOException e) {
                        logger.warn("Failed to delete temp resource: " + e.getMessage());
                    }
                });
            }
            catch (IOException e) {
                logger.warn("Inaccessible temp path: " + workPath, e);
            }
        }
    }
}

