/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.resource;

import com.aspectran.core.context.resource.InvalidResourceException;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.jar.JarEntry;

public class ResourceEntries
extends LinkedHashMap<String, URL> {
    private static final long serialVersionUID = -6936820061673430782L;

    ResourceEntries() {
    }

    public void putResource(String resourceName, @NonNull File file) throws InvalidResourceException {
        URL url;
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new InvalidResourceException("Invalid resource: " + String.valueOf(file), e);
        }
        this.put(resourceName, url);
    }

    public void putResource(@NonNull File file, @NonNull JarEntry entry) throws InvalidResourceException {
        URL url;
        String resourceName = entry.getName();
        try {
            url = new URI("jar:" + String.valueOf(file.toURI()) + "!/" + resourceName).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new InvalidResourceException("Invalid resource: " + String.valueOf(file), e);
        }
        this.put(resourceName, url);
    }

    @Override
    public URL put(String resourceName, URL url) {
        if (StringUtils.endsWith(resourceName = resourceName.replace(File.separatorChar, '/'), '/')) {
            resourceName = resourceName.substring(0, resourceName.length() - 1);
        }
        return super.put(resourceName, url);
    }
}

