/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.resource;

import com.aspectran.core.context.resource.InvalidResourceException;
import com.aspectran.core.context.resource.ResourceEntries;
import com.aspectran.core.context.resource.SiblingClassLoader;
import com.aspectran.utils.PathUtils;
import com.aspectran.utils.ResourceUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.jar.JarEntry;

public class ResourceManager {
    private final ResourceEntries resourceEntries = new ResourceEntries();

    ResourceManager() {
    }

    public URL getResource(String name) {
        return (URL)this.resourceEntries.get(name);
    }

    @NonNull
    public static Enumeration<URL> getResources(final Iterator<SiblingClassLoader> owners) {
        return new Enumeration<URL>(){
            private Iterator<URL> values;
            private URL next;

            private boolean hasNext() {
                while (true) {
                    if (this.values == null) {
                        if (!owners.hasNext()) {
                            return false;
                        }
                        this.values = ((SiblingClassLoader)owners.next()).getResourceManager().getResourceEntries().values().iterator();
                    }
                    if (this.values.hasNext()) {
                        this.next = this.values.next();
                        return true;
                    }
                    this.values = null;
                }
            }

            @Override
            public synchronized boolean hasMoreElements() {
                return this.next != null || this.hasNext();
            }

            @Override
            public synchronized URL nextElement() {
                if (this.next == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                URL current = this.next;
                this.next = null;
                return current;
            }
        };
    }

    @NonNull
    public static Enumeration<URL> getResources(Iterator<SiblingClassLoader> owners, String name) {
        return ResourceManager.getResources(owners, name, null);
    }

    @NonNull
    public static Enumeration<URL> getResources(final Iterator<SiblingClassLoader> owners, String name, final Enumeration<URL> inherited) {
        if (owners == null || name == null) {
            return Collections.emptyEnumeration();
        }
        if (StringUtils.endsWith(name, '/')) {
            name = name.substring(0, name.length() - 1);
        }
        final String nameToSearch = name;
        return new Enumeration<URL>(){
            private URL next;
            private boolean noMore;

            private boolean hasNext() {
                do {
                    if (!owners.hasNext()) {
                        return false;
                    }
                    this.next = ((SiblingClassLoader)owners.next()).getResourceManager().getResource(nameToSearch);
                } while (this.next == null);
                return true;
            }

            @Override
            public boolean hasMoreElements() {
                if (!this.noMore) {
                    if (inherited != null && inherited.hasMoreElements()) {
                        return true;
                    }
                    this.noMore = true;
                }
                return this.next != null || this.hasNext();
            }

            @Override
            public URL nextElement() {
                if (!this.noMore && inherited != null && inherited.hasMoreElements()) {
                    return (URL)inherited.nextElement();
                }
                if (this.next == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                URL current = this.next;
                this.next = null;
                return current;
            }
        };
    }

    @NonNull
    public static Enumeration<URL> searchResources(Iterator<SiblingClassLoader> owners, String name) {
        return ResourceManager.searchResources(owners, name, null);
    }

    @NonNull
    public static Enumeration<URL> searchResources(final Iterator<SiblingClassLoader> owners, String name, final Enumeration<URL> inherited) {
        if (StringUtils.endsWith(name, '/')) {
            name = name.substring(0, name.length() - 1);
        }
        final String nameToSearch = name;
        return new Enumeration<URL>(){
            private Iterator<Map.Entry<String, URL>> current;
            private Map.Entry<String, URL> entry;
            private boolean noMore;

            private boolean hasNext() {
                while (true) {
                    if (this.current == null) {
                        if (!owners.hasNext()) {
                            return false;
                        }
                        this.current = ((SiblingClassLoader)owners.next()).getResourceManager().getResourceEntries().entrySet().iterator();
                    }
                    while (this.current.hasNext()) {
                        Map.Entry<String, URL> entry2 = this.current.next();
                        if (!entry2.getKey().equals(nameToSearch)) continue;
                        this.entry = entry2;
                        return true;
                    }
                    this.current = null;
                }
            }

            @Override
            public synchronized boolean hasMoreElements() {
                if (this.entry != null) {
                    return true;
                }
                if (!this.noMore) {
                    if (inherited != null && inherited.hasMoreElements()) {
                        return true;
                    }
                    this.noMore = true;
                }
                return this.hasNext();
            }

            @Override
            public synchronized URL nextElement() {
                if (this.entry == null) {
                    if (!this.noMore && inherited != null && inherited.hasMoreElements()) {
                        return (URL)inherited.nextElement();
                    }
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                }
                URL url = this.entry.getValue();
                this.entry = null;
                return url;
            }
        };
    }

    protected ResourceEntries getResourceEntries() {
        return this.resourceEntries;
    }

    public int getNumberOfResources() {
        return this.resourceEntries.size();
    }

    protected void putResource(String resourceName, File file) throws InvalidResourceException {
        this.resourceEntries.putResource(resourceName, file);
    }

    protected void putResource(File file, JarEntry entry) throws InvalidResourceException {
        this.resourceEntries.putResource(file, entry);
    }

    public void reset() throws InvalidResourceException {
        this.release();
    }

    public void release() {
        this.resourceEntries.clear();
    }

    @NonNull
    public static String resourceNameToClassName(@NonNull String resourceName) {
        String className = resourceName.substring(0, resourceName.length() - ".class".length());
        className = className.replace('/', '.');
        return className;
    }

    @NonNull
    public static String classNameToResourceName(@NonNull String className) {
        return className.replace('.', '/') + ".class";
    }

    public static String packageNameToResourceName(@NonNull String packageName) {
        String resourceName = packageName.replace('.', '/');
        if (StringUtils.endsWith(resourceName, '/')) {
            resourceName = resourceName.substring(0, resourceName.length() - 1);
        }
        return resourceName;
    }

    public static String[] checkResourceLocations(String[] resourceLocations, String basePath) throws InvalidResourceException {
        int i;
        if (resourceLocations == null || resourceLocations.length == 0) {
            return null;
        }
        String[] resourceLocationsToUse = (String[])resourceLocations.clone();
        for (i = 0; i < resourceLocationsToUse.length; ++i) {
            String tempLocation = resourceLocationsToUse[i];
            if (tempLocation == null) continue;
            if (StringUtils.endsWith(tempLocation = PathUtils.cleanPath(tempLocation), '/')) {
                tempLocation = tempLocation.substring(0, tempLocation.length() - 1);
            }
            if (tempLocation.startsWith("classpath:")) {
                String path = tempLocation.substring("classpath:".length());
                try {
                    URL url = ResourceUtils.getResource(path);
                    tempLocation = url.getPath();
                }
                catch (IOException e) {
                    throw new InvalidResourceException("Class path resource [" + tempLocation + "] cannot be resolved to URL", e);
                }
            }
            if (tempLocation.startsWith("file:")) {
                try {
                    URL url = ResourceUtils.toURL(tempLocation);
                    tempLocation = url.getFile();
                }
                catch (Exception e) {
                    throw new InvalidResourceException("Resource location [" + tempLocation + "] is neither a URL not a well-formed file path", e);
                }
            }
            try {
                File f;
                if (StringUtils.hasText(basePath)) {
                    File f2;
                    f = new File(basePath, tempLocation);
                    if (!f.exists() && (f2 = new File(tempLocation)).exists()) {
                        f = f2;
                    }
                } else {
                    f = new File(tempLocation);
                }
                tempLocation = f.getCanonicalPath();
            }
            catch (IOException e) {
                throw new InvalidResourceException("Invalid resource location: " + tempLocation, e);
            }
            resourceLocationsToUse[i] = tempLocation;
        }
        for (i = 0; i < resourceLocationsToUse.length - 1; ++i) {
            String tempLocation1 = resourceLocationsToUse[i];
            if (tempLocation1 == null) continue;
            for (int j = i + 1; j < resourceLocationsToUse.length; ++j) {
                String tempLocation2 = resourceLocationsToUse[j];
                if (tempLocation2 == null || !tempLocation1.equals(tempLocation2)) continue;
                resourceLocationsToUse[j] = null;
            }
        }
        return (String[])Arrays.stream(resourceLocationsToUse).filter(Objects::nonNull).toArray(String[]::new);
    }
}

