/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.resource;

import com.aspectran.core.context.resource.InvalidResourceException;
import com.aspectran.core.context.resource.LocalResourceManager;
import com.aspectran.core.context.resource.ResourceManager;
import com.aspectran.utils.ClassUtils;
import com.aspectran.utils.ObjectUtils;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public final class SiblingClassLoader
extends ClassLoader {
    private final int id;
    private final SiblingClassLoader root;
    private final boolean firstborn;
    private final String resourceLocation;
    private final ResourceManager resourceManager;
    private final List<SiblingClassLoader> children = new LinkedList<SiblingClassLoader>();
    private Set<String> excludeClassNames;
    private Set<String> excludePackageNames;
    private int reloadedCount;

    public SiblingClassLoader() throws InvalidResourceException {
        this(null, (ClassLoader)null);
    }

    public SiblingClassLoader(String name) throws InvalidResourceException {
        this(name, (ClassLoader)null);
    }

    public SiblingClassLoader(String name, ClassLoader parent) throws InvalidResourceException {
        super(name, parent != null ? parent : ClassUtils.getDefaultClassLoader());
        this.id = 1000;
        this.root = this;
        this.firstborn = true;
        this.resourceLocation = null;
        this.resourceManager = new LocalResourceManager(this);
    }

    public SiblingClassLoader(String[] resourceLocations) throws InvalidResourceException {
        this(null, null, resourceLocations);
    }

    public SiblingClassLoader(String name, String[] resourceLocations) throws InvalidResourceException {
        this(name, null, resourceLocations);
    }

    public SiblingClassLoader(ClassLoader parent, String[] resourceLocations) throws InvalidResourceException {
        this(null, parent, resourceLocations);
    }

    public SiblingClassLoader(String name, ClassLoader parent, String[] resourceLocations) throws InvalidResourceException {
        this(name, parent != null ? parent : ClassUtils.getDefaultClassLoader());
        if (resourceLocations != null) {
            this.createChildren(resourceLocations);
        }
    }

    private SiblingClassLoader(String name, @NonNull SiblingClassLoader parent, String resourceLocation) throws InvalidResourceException {
        super(name, parent);
        int numOfChildren = parent.addChild(this);
        this.id = (Math.abs(parent.getId() / 1000) + 1) * 1000 + numOfChildren;
        this.root = parent.getRoot();
        this.firstborn = numOfChildren == 1;
        this.resourceLocation = resourceLocation;
        this.resourceManager = new LocalResourceManager(this, resourceLocation);
    }

    void joinSibling(String resourceLocation) throws InvalidResourceException {
        SiblingClassLoader parent = (SiblingClassLoader)this.getParent();
        parent.createChild(resourceLocation);
    }

    private void createChildren(@NonNull String[] resourceLocations) throws InvalidResourceException {
        SiblingClassLoader scl = this;
        for (String resourceLocation : resourceLocations) {
            if (resourceLocation == null || resourceLocation.isEmpty()) continue;
            scl = scl.createChild(resourceLocation);
        }
    }

    @NonNull
    private SiblingClassLoader createChild(String resourceLocation) throws InvalidResourceException {
        if (!this.firstborn) {
            throw new IllegalStateException("Only the first among siblings can create a child");
        }
        return new SiblingClassLoader(this.getName(), this, resourceLocation);
    }

    public void excludePackage(String ... packageNames) {
        if (packageNames != null && packageNames.length > 0) {
            for (String packageName : packageNames) {
                if (this.excludePackageNames == null) {
                    this.excludePackageNames = new HashSet<String>();
                }
                this.excludePackageNames.add(packageName + ".");
            }
        } else {
            this.excludePackageNames = null;
        }
    }

    public void excludeClass(String ... classNames) {
        if (classNames != null && classNames.length > 0) {
            for (String className : classNames) {
                if (this.isExcludedPackage(className)) continue;
                if (this.excludeClassNames == null) {
                    this.excludeClassNames = new HashSet<String>();
                }
                this.excludeClassNames.add(className);
            }
        } else {
            this.excludeClassNames = null;
        }
    }

    private boolean isExcluded(String className) {
        return this.isExcludedPackage(className) || this.isExcludedClass(className);
    }

    private boolean isExcludedPackage(String className) {
        if (this.excludePackageNames != null) {
            for (String packageName : this.excludePackageNames) {
                if (!className.startsWith(packageName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isExcludedClass(String className) {
        return this.excludeClassNames != null && this.excludeClassNames.contains(className);
    }

    public int getId() {
        return this.id;
    }

    public SiblingClassLoader getRoot() {
        return this.root;
    }

    public boolean isRoot() {
        return this == this.root;
    }

    public List<SiblingClassLoader> getChildren() {
        return this.children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addChild(SiblingClassLoader child) {
        List<SiblingClassLoader> list = this.children;
        synchronized (list) {
            this.children.add(child);
            return this.children.size();
        }
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean isFirstborn() {
        return this.firstborn;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public synchronized void reload() throws InvalidResourceException {
        this.reload(this.root);
    }

    private void reload(@NonNull SiblingClassLoader self) throws InvalidResourceException {
        self.increaseReloadedCount();
        if (self.getResourceManager() != null) {
            self.getResourceManager().reset();
        }
        SiblingClassLoader firstborn = null;
        ArrayList<SiblingClassLoader> siblings = new ArrayList<SiblingClassLoader>();
        for (SiblingClassLoader child : self.getChildren()) {
            if (child.isFirstborn()) {
                firstborn = child;
                continue;
            }
            siblings.add(child);
        }
        if (!siblings.isEmpty()) {
            self.leave(siblings);
        }
        if (firstborn != null) {
            this.reload(firstborn);
        }
    }

    private void increaseReloadedCount() {
        ++this.reloadedCount;
    }

    private void leave(@NonNull List<SiblingClassLoader> siblings) {
        for (SiblingClassLoader sibling : siblings) {
            ResourceManager rm = sibling.getResourceManager();
            if (rm != null) {
                rm.release();
            }
            this.children.remove(sibling);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    ClassLoader parent = this.root.getParent();
                    c = parent != null ? Class.forName(name, false, parent) : this.findSystemClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (c == null) {
                    c = this.findClass(name);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Objects.requireNonNull(name);
        try {
            byte[] classData = this.loadClassData(name);
            if (classData != null) {
                return this.defineClass(name, classData, 0, classData.length);
            }
            throw new ClassNotFoundException(name);
        }
        catch (InvalidResourceException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    @Nullable
    private byte[] loadClassData(String className) throws InvalidResourceException {
        if (this.isExcluded(className)) {
            return null;
        }
        String resourceName = ResourceManager.classNameToResourceName(className);
        Enumeration<URL> res = ResourceManager.getResources(this.getAllMembers(), resourceName);
        URL url = null;
        if (res.hasMoreElements()) {
            url = res.nextElement();
        }
        if (url == null) {
            return null;
        }
        try {
            int i;
            URLConnection connection = url.openConnection();
            BufferedInputStream input = new BufferedInputStream(connection.getInputStream());
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            while ((i = input.read()) != -1) {
                output.write(i);
            }
            input.close();
            byte[] classData = output.toByteArray();
            output.close();
            return classData;
        }
        catch (IOException e) {
            throw new InvalidResourceException("Unable to read class file: " + String.valueOf(url), e);
        }
    }

    @Override
    public URL getResource(String name) {
        ClassLoader parent = this.root.getParent();
        URL url = parent != null ? parent.getResource(name) : SiblingClassLoader.getSystemClassLoader().getResource(name);
        if (url == null) {
            url = this.findResource(name);
        }
        return url;
    }

    @Override
    @NonNull
    public Enumeration<URL> getResources(String name) throws IOException {
        Objects.requireNonNull(name);
        Enumeration<URL> parentResources = null;
        ClassLoader parent = this.root.getParent();
        if (parent != null) {
            parentResources = parent.getResources(name);
        }
        return ResourceManager.getResources(this.getAllMembers(), name, parentResources);
    }

    @Override
    public URL findResource(String name) {
        Objects.requireNonNull(name);
        URL url = null;
        Enumeration<URL> res = ResourceManager.getResources(this.getAllMembers(), name);
        if (res.hasMoreElements()) {
            url = res.nextElement();
        }
        return url;
    }

    @Override
    @NonNull
    public Enumeration<URL> findResources(String name) {
        Objects.requireNonNull(name);
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        Enumeration<URL> res = ResourceManager.getResources(this.getAllMembers(), name);
        if (res.hasMoreElements()) {
            urls.add(res.nextElement());
        }
        return Collections.enumeration(urls);
    }

    @NonNull
    public Iterator<SiblingClassLoader> getAllMembers() {
        return SiblingClassLoader.getMembers(this.root);
    }

    @NonNull
    public Enumeration<URL> getAllResources() {
        return ResourceManager.getResources(this.getAllMembers());
    }

    public String toString() {
        String thisName = ObjectUtils.simpleIdentityToString(this);
        ToStringBuilder tsb = new ToStringBuilder(thisName);
        tsb.append("id", this.id);
        tsb.append("name", this.getName());
        if (this.getParent() instanceof SiblingClassLoader) {
            tsb.append("parent", ((SiblingClassLoader)this.getParent()).getId());
        } else {
            tsb.append("parent", this.getParent().getClass().getName());
        }
        tsb.append("root", this == this.root);
        tsb.append("firstborn", this.firstborn);
        tsb.append("resourceLocation", this.resourceLocation);
        tsb.append("numberOfResources", this.resourceManager.getNumberOfResources());
        tsb.appendSize("numberOfChildren", this.children);
        tsb.append("reloadedCount", this.reloadedCount);
        return tsb.toString();
    }

    @NonNull
    public static Iterator<SiblingClassLoader> getMembers(final @NonNull SiblingClassLoader root) {
        return new Iterator<SiblingClassLoader>(){
            private SiblingClassLoader next;
            private Iterator<SiblingClassLoader> children;
            private SiblingClassLoader firstChild;
            {
                this.next = root;
                this.children = root.getChildren().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public SiblingClassLoader next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                SiblingClassLoader current = this.next;
                if (this.children.hasNext()) {
                    this.next = this.children.next();
                    if (this.firstChild == null) {
                        this.firstChild = this.next;
                    }
                } else if (this.firstChild != null) {
                    this.children = this.firstChild.getChildren().iterator();
                    if (this.children.hasNext()) {
                        this.firstChild = this.next = this.children.next();
                    } else {
                        this.next = null;
                    }
                } else {
                    this.next = null;
                }
                return current;
            }
        };
    }
}

