/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.env.Profiles;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.params.AspectranParameters;
import com.aspectran.core.context.rule.type.AppendableFileFormatType;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;

public class AppendRule {
    private String file;
    private String resource;
    private String url;
    private AppendableFileFormatType format;
    private String profile;
    private Profiles profiles;
    private AspectranParameters aspectranParameters;

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public AppendableFileFormatType getFormat() {
        return this.format;
    }

    public void setFormat(AppendableFileFormatType format) {
        this.format = format;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
        this.profiles = profile != null ? Profiles.of(profile) : null;
    }

    public Profiles getProfiles() {
        return this.profiles;
    }

    public AspectranParameters getAspectranParameters() {
        return this.aspectranParameters;
    }

    public void setAspectranParameters(AspectranParameters aspectranParameters) {
        this.aspectranParameters = aspectranParameters;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("file", this.file);
        tsb.append("resource", this.resource);
        tsb.append("url", this.url);
        tsb.append("format", (Object)this.format);
        tsb.append("profile", this.profile);
        tsb.append("aspectran", this.aspectranParameters);
        return tsb.toString();
    }

    @NonNull
    public static AppendRule newInstance(String file, String resource, String url, String format, String profile) throws IllegalRuleException {
        AppendRule appendRule = new AppendRule();
        if (StringUtils.hasText(file)) {
            appendRule.setFile(file);
        } else if (StringUtils.hasText(resource)) {
            appendRule.setResource(resource);
        } else if (StringUtils.hasText(url)) {
            appendRule.setUrl(url);
        } else {
            throw new IllegalRuleException("The 'append' element requires either a 'file', 'resource' or 'url' attribute");
        }
        AppendableFileFormatType appendableFileFormatType = AppendableFileFormatType.resolve(format);
        if (format != null && appendableFileFormatType == null) {
            throw new IllegalRuleException("Not one of the appendable file formats: '" + format + "'");
        }
        appendRule.setFormat(appendableFileFormatType);
        if (StringUtils.hasText(profile)) {
            appendRule.setProfile(profile);
        }
        return appendRule;
    }

    @NonNull
    public static AppendRule newInstance(AspectranParameters aspectranParameters, String profile) {
        AppendRule appendRule = new AppendRule();
        appendRule.setAspectranParameters(aspectranParameters);
        if (StringUtils.hasText(profile)) {
            appendRule.setProfile(profile);
        }
        return appendRule;
    }
}

