/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.activity.process.action.AdviceAction;
import com.aspectran.core.activity.process.action.AnnotatedAdviceAction;
import com.aspectran.core.activity.process.action.EchoAction;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.activity.process.action.HeaderAction;
import com.aspectran.core.context.rule.AnnotatedActionRule;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.ChooseRule;
import com.aspectran.core.context.rule.EchoActionRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.ExceptionThrownRule;
import com.aspectran.core.context.rule.HeaderActionRule;
import com.aspectran.core.context.rule.IncludeActionRule;
import com.aspectran.core.context.rule.InvokeActionRule;
import com.aspectran.core.context.rule.ability.ActionRuleApplicable;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.core.context.rule.type.AspectAdviceType;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;

public class AspectAdviceRule
implements ActionRuleApplicable {
    private final AspectRule aspectRule;
    private final String aspectId;
    private final String adviceBeanId;
    private final Class<?> adviceBeanClass;
    private final AspectAdviceType aspectAdviceType;
    private Executable adviceAction;
    private ExceptionRule exceptionRule;
    private ExceptionThrownRule exceptionThrownRule;

    public AspectAdviceRule(AspectRule aspectRule, AspectAdviceType aspectAdviceType) {
        if (aspectRule == null) {
            throw new IllegalArgumentException("aspectRule must not be null");
        }
        if (aspectAdviceType == null) {
            throw new IllegalArgumentException("aspectAdviceType must not be null");
        }
        this.aspectRule = aspectRule;
        this.aspectId = aspectRule.getId();
        this.adviceBeanId = aspectRule.getAdviceBeanId();
        this.adviceBeanClass = aspectRule.getAdviceBeanClass();
        this.aspectAdviceType = aspectAdviceType;
    }

    public String getAspectId() {
        return this.aspectId;
    }

    public AspectRule getAspectRule() {
        return this.aspectRule;
    }

    public String getAdviceBeanId() {
        return this.adviceBeanId;
    }

    public Class<?> getAdviceBeanClass() {
        return this.adviceBeanClass;
    }

    public AspectAdviceType getAspectAdviceType() {
        return this.aspectAdviceType;
    }

    @Override
    public Executable applyActionRule(HeaderActionRule headerActionRule) {
        this.adviceAction = new HeaderAction(headerActionRule);
        return this.adviceAction;
    }

    @Override
    public Executable applyActionRule(EchoActionRule echoActionRule) {
        this.adviceAction = new EchoAction(echoActionRule);
        return this.adviceAction;
    }

    @Override
    public Executable applyActionRule(InvokeActionRule invokeActionRule) {
        if (this.adviceBeanId == null && this.adviceBeanClass == null && invokeActionRule.getBeanId() == null && invokeActionRule.getBeanClass() == null) {
            throw new IllegalStateException("Cannot resolve advice bean for " + String.valueOf(invokeActionRule) + " in " + String.valueOf(this));
        }
        this.adviceAction = new AdviceAction(this, invokeActionRule);
        return this.adviceAction;
    }

    @Override
    public Executable applyActionRule(AnnotatedActionRule annotatedActionRule) {
        throw new UnsupportedOperationException("No support applying AnnotatedActionRule to AspectAdviceRule");
    }

    @Override
    public Executable applyActionRule(IncludeActionRule includeActionRule) {
        throw new UnsupportedOperationException("No support applying IncludeActionRule to AspectAdviceRule");
    }

    @Override
    public Executable applyActionRule(ChooseRule chooseRule) {
        throw new UnsupportedOperationException("No support applying ChooseRule to AspectAdviceRule");
    }

    @Override
    public void applyActionRule(Executable action) {
        throw new UnsupportedOperationException();
    }

    public Executable getAdviceAction() {
        return this.adviceAction;
    }

    public void setAdviceAction(Executable adviceAction) {
        this.adviceAction = adviceAction;
    }

    public ActionType getActionType() {
        return this.adviceAction != null ? this.adviceAction.getActionType() : null;
    }

    public ExceptionRule getExceptionRule() {
        return this.exceptionRule;
    }

    public ExceptionThrownRule getExceptionThrownRule() {
        return this.exceptionThrownRule;
    }

    public void setExceptionThrownRule(ExceptionThrownRule exceptionThrownRule) {
        ExceptionRule exceptionRule = new ExceptionRule();
        exceptionRule.putExceptionThrownRule(exceptionThrownRule);
        this.exceptionRule = exceptionRule;
        this.exceptionThrownRule = exceptionThrownRule;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("type", (Object)this.aspectAdviceType);
        tsb.append("bean", this.adviceBeanId);
        if (this.adviceBeanId == null) {
            tsb.append("bean", this.adviceBeanClass);
        }
        tsb.append("action", AspectAdviceRule.toString(this.adviceAction, null));
        return tsb.toString();
    }

    public static String toString(@NonNull Executable adviceAction, @Nullable AspectAdviceRule aspectAdviceRule) {
        if (adviceAction instanceof AdviceAction || adviceAction instanceof AnnotatedAdviceAction) {
            return adviceAction.toString();
        }
        ToStringBuilder tsb = new ToStringBuilder();
        if (aspectAdviceRule != null) {
            tsb.append("type", (Object)aspectAdviceRule.getAspectAdviceType());
        }
        if (adviceAction.getActionType() != null) {
            tsb.append("action", adviceAction.toString());
        } else {
            tsb.append("instance", adviceAction.toString());
        }
        if (aspectAdviceRule != null && aspectAdviceRule.getAspectRule() != null) {
            int order = aspectAdviceRule.getAspectRule().getOrder();
            if (order != Integer.MAX_VALUE) {
                tsb.append("order", order);
            }
            tsb.append("isolated", aspectAdviceRule.getAspectRule().getIsolated());
        }
        return tsb.toString();
    }

    @NonNull
    public static AspectAdviceRule newInstance(AspectRule aspectRule, AspectAdviceType aspectAdviceType) {
        return new AspectAdviceRule(aspectRule, aspectAdviceType);
    }
}

