/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.context.asel.token.Token;
import com.aspectran.core.context.asel.token.TokenParser;
import com.aspectran.core.context.env.Profiles;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ability.Replicable;
import com.aspectran.core.context.rule.type.TextStyleType;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.util.ArrayList;
import java.util.List;

public class DescriptionRule
implements Replicable<DescriptionRule> {
    private String profile;
    private Profiles profiles;
    private TextStyleType contentStyle;
    private String content;
    private String formattedContent;
    private List<DescriptionRule> candidates;

    public DescriptionRule() {
    }

    public DescriptionRule(DescriptionRule other) {
        if (other != null) {
            this.setProfiles(other.getProfile(), other.getProfiles());
            this.setContentStyle(other.getContentStyle());
            this.setContent(other.getContent());
            this.setFormattedContent(other.getFormattedContent());
            this.setCandidates(other.getCandidates());
        }
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
        this.profiles = profile != null ? Profiles.of(profile) : null;
    }

    public Profiles getProfiles() {
        return this.profiles;
    }

    private void setProfiles(String profile, Profiles profiles) {
        this.profile = profile;
        this.profiles = profiles;
    }

    public TextStyleType getContentStyle() {
        return this.contentStyle;
    }

    public void setContentStyle(TextStyleType contentStyle) {
        this.contentStyle = contentStyle;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getFormattedContent() {
        return this.formattedContent != null ? this.formattedContent : this.content;
    }

    public void setFormattedContent(String formattedContent) {
        this.formattedContent = formattedContent;
    }

    public List<DescriptionRule> getCandidates() {
        return this.candidates;
    }

    public void setCandidates(List<DescriptionRule> candidates) {
        this.candidates = candidates;
    }

    public boolean addCandidate(DescriptionRule candidate) {
        if (this.candidates == null) {
            this.candidates = new ArrayList<DescriptionRule>();
        }
        return this.candidates.add(candidate);
    }

    @Override
    public DescriptionRule replicate() {
        DescriptionRule dr = new DescriptionRule();
        dr.setProfiles(this.profile, this.profiles);
        dr.setContentStyle(this.contentStyle);
        dr.setContent(this.content);
        return dr;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("profile", this.profile);
        tsb.append("style", (Object)this.contentStyle);
        tsb.append("content", this.content);
        return tsb.toString();
    }

    public static String render(@NonNull DescriptionRule descriptionRule, Activity activity) {
        Token[] contentTokens;
        String content = descriptionRule.getFormattedContent();
        if (content == null || activity == null) {
            return content;
        }
        for (Token token : contentTokens = TokenParser.makeTokens(content, true)) {
            Token.resolveAlternativeValue(token, activity.getClassLoader());
        }
        return activity.getTokenEvaluator().evaluateAsString(contentTokens);
    }

    @NonNull
    public static DescriptionRule newInstance(String profile, String style) throws IllegalRuleException {
        TextStyleType contentStyle = TextStyleType.resolve(style);
        if (style != null && contentStyle == null) {
            throw new IllegalRuleException("No text style type for '" + style + "'");
        }
        DescriptionRule dr = new DescriptionRule();
        dr.setContentStyle(contentStyle);
        if (StringUtils.hasText(profile)) {
            dr.setProfile(profile);
        }
        return dr;
    }
}

