/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.activity.process.action.AdviceAction;
import com.aspectran.core.activity.process.action.AnnotatedAction;
import com.aspectran.core.activity.process.action.EchoAction;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.activity.process.action.HeaderAction;
import com.aspectran.core.activity.process.action.InvokeAction;
import com.aspectran.core.activity.response.RedirectResponse;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.ResponseMap;
import com.aspectran.core.activity.response.dispatch.DispatchResponse;
import com.aspectran.core.activity.response.transform.TransformResponseFactory;
import com.aspectran.core.context.rule.AnnotatedActionRule;
import com.aspectran.core.context.rule.AspectAdviceRule;
import com.aspectran.core.context.rule.ChooseRule;
import com.aspectran.core.context.rule.DispatchRule;
import com.aspectran.core.context.rule.EchoActionRule;
import com.aspectran.core.context.rule.ForwardRule;
import com.aspectran.core.context.rule.HeaderActionRule;
import com.aspectran.core.context.rule.IncludeActionRule;
import com.aspectran.core.context.rule.InvokeActionRule;
import com.aspectran.core.context.rule.RedirectRule;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.core.context.rule.ability.ActionRuleApplicable;
import com.aspectran.core.context.rule.ability.ResponseRuleApplicable;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.utils.annotation.jsr305.NonNull;

public class ExceptionThrownRule
implements ActionRuleApplicable,
ResponseRuleApplicable {
    private final AspectAdviceRule aspectAdviceRule;
    private String[] exceptionTypes;
    private Executable action;
    private ResponseMap responseMap;
    private Response defaultResponse;

    public ExceptionThrownRule() {
        this(null);
    }

    public ExceptionThrownRule(AspectAdviceRule aspectAdviceRule) {
        this.aspectAdviceRule = aspectAdviceRule;
    }

    public AspectAdviceRule getAspectAdviceRule() {
        return this.aspectAdviceRule;
    }

    public String[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public void setExceptionTypes(String ... exceptionTypes) {
        this.exceptionTypes = exceptionTypes;
    }

    public Executable getAction() {
        return this.action;
    }

    public void setAction(AnnotatedAction action) {
        this.action = action;
    }

    public ActionType getActionType() {
        return this.action != null ? this.action.getActionType() : null;
    }

    public Response getResponse(String contentType) {
        Response response;
        if (this.responseMap != null && contentType != null && (response = (Response)this.responseMap.get(contentType)) != null) {
            return response;
        }
        return this.getDefaultResponse();
    }

    private Response getDefaultResponse() {
        if (this.defaultResponse == null && this.responseMap != null && this.responseMap.size() == 1) {
            return this.responseMap.getFirst();
        }
        return this.defaultResponse;
    }

    public ResponseMap getResponseMap() {
        return this.responseMap;
    }

    private ResponseMap touchResponseMap() {
        if (this.responseMap == null) {
            this.responseMap = new ResponseMap();
        }
        return this.responseMap;
    }

    @Override
    public Executable applyActionRule(HeaderActionRule headerActionRule) {
        HeaderAction action = new HeaderAction(headerActionRule);
        this.action = action;
        return action;
    }

    @Override
    public Executable applyActionRule(EchoActionRule echoActionRule) {
        EchoAction action = new EchoAction(echoActionRule);
        this.action = action;
        return action;
    }

    @Override
    public Executable applyActionRule(InvokeActionRule invokeActionRule) {
        InvokeAction action;
        if (this.aspectAdviceRule != null) {
            if (this.aspectAdviceRule.getAdviceBeanId() == null && this.aspectAdviceRule.getAdviceBeanClass() == null && invokeActionRule.getBeanId() == null && invokeActionRule.getBeanClass() == null) {
                throw new IllegalStateException("Unknown advice bean for " + String.valueOf(invokeActionRule) + " in " + String.valueOf(this));
            }
            action = new AdviceAction(this.aspectAdviceRule, invokeActionRule);
        } else {
            if (invokeActionRule.getBeanId() == null && invokeActionRule.getBeanClass() == null) {
                throw new IllegalStateException("Unknown action bean for " + String.valueOf(invokeActionRule));
            }
            action = new InvokeAction(invokeActionRule);
        }
        this.action = action;
        return action;
    }

    @Override
    public Executable applyActionRule(AnnotatedActionRule annotatedActionRule) {
        throw new UnsupportedOperationException("No support applying AnnotatedActionRule to AspectAdviceRule");
    }

    @Override
    public Executable applyActionRule(IncludeActionRule includeActionRule) {
        throw new UnsupportedOperationException("No support applying IncludeActionRule to AspectAdviceRule");
    }

    @Override
    public Executable applyActionRule(ChooseRule chooseRule) {
        throw new UnsupportedOperationException("No support applying ChooseRule to AspectAdviceRule");
    }

    @Override
    public void applyActionRule(Executable action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Response applyResponseRule(TransformRule transformRule) {
        Response response = TransformResponseFactory.create(transformRule);
        this.touchResponseMap().put(transformRule.getContentType(), response);
        if (transformRule.isDefaultResponse()) {
            this.defaultResponse = response;
        }
        if (this.defaultResponse == null && transformRule.getContentType() == null) {
            this.defaultResponse = response;
        }
        return response;
    }

    @Override
    public Response applyResponseRule(DispatchRule dispatchRule) {
        DispatchResponse response = new DispatchResponse(dispatchRule);
        this.touchResponseMap().put(dispatchRule.getContentType(), response);
        if (dispatchRule.isDefaultResponse()) {
            this.defaultResponse = response;
        }
        if (this.defaultResponse == null && dispatchRule.getContentType() == null) {
            this.defaultResponse = response;
        }
        return response;
    }

    @Override
    public Response applyResponseRule(ForwardRule forwardRule) {
        throw new UnsupportedOperationException("Cannot apply the forward response rule to the exception thrown rule");
    }

    @Override
    public Response applyResponseRule(RedirectRule redirectRule) {
        RedirectResponse response = new RedirectResponse(redirectRule);
        this.touchResponseMap().put(redirectRule.getContentType(), response);
        if (redirectRule.isDefaultResponse()) {
            this.defaultResponse = response;
        }
        if (this.defaultResponse == null && redirectRule.getContentType() == null) {
            this.defaultResponse = response;
        }
        return response;
    }

    @NonNull
    public static ExceptionThrownRule newInstance(Class<? extends Throwable>[] types, AnnotatedAction action) {
        ExceptionThrownRule exceptionThrownRule = new ExceptionThrownRule();
        if (types != null && types.length > 0) {
            String[] exceptionTypes = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                exceptionTypes[i] = types[0].getName();
            }
            exceptionThrownRule.setExceptionTypes(exceptionTypes);
        }
        exceptionThrownRule.setAction(action);
        return exceptionThrownRule;
    }
}

