/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.env.Profiles;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class ItemRuleMap
extends LinkedHashMap<String, ItemRule> {
    private static final long serialVersionUID = 192817512158305803L;
    private String profile;
    private Profiles profiles;
    private List<ItemRuleMap> candidates;

    public ItemRule putItemRule(@NonNull ItemRule itemRule) {
        if (itemRule.isAutoNamed()) {
            this.autoNaming(itemRule);
        }
        return this.put(itemRule.getName(), itemRule);
    }

    private void autoNaming(@NonNull ItemRule itemRule) {
        if (itemRule.getName() == null) {
            itemRule.setName("item#" + this.size());
        }
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
        this.profiles = profile != null ? Profiles.of(profile) : null;
    }

    public Profiles getProfiles() {
        return this.profiles;
    }

    public List<ItemRuleMap> getCandidates() {
        return this.candidates;
    }

    public void setCandidates(List<ItemRuleMap> candidates) {
        this.candidates = candidates;
    }

    public boolean addCandidate(ItemRuleMap itemRuleMap) {
        if (this.candidates == null) {
            this.candidates = new ArrayList<ItemRuleMap>();
        }
        return this.candidates.add(itemRuleMap);
    }
}

