/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.activity.request.FileParameter;
import com.aspectran.core.component.bean.annotation.AttrItem;
import com.aspectran.core.component.bean.annotation.ParamItem;
import com.aspectran.core.context.asel.token.Token;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleList;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.params.EntryParameters;
import com.aspectran.core.context.rule.params.ItemParameters;
import com.aspectran.core.context.rule.type.ItemType;
import com.aspectran.core.context.rule.type.ItemValueType;
import com.aspectran.utils.Assert;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.apon.Parameters;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class ItemRuleUtils {
    public static Class<?> getPrototypeClass(@NonNull ItemRule itemRule, Object value) {
        ItemValueType valueType = itemRule.getValueType();
        if (itemRule.getType() == ItemType.ARRAY) {
            if (valueType == ItemValueType.STRING) {
                return String[].class;
            }
            if (valueType == ItemValueType.INT) {
                return Integer[].class;
            }
            if (valueType == ItemValueType.LONG) {
                return Long[].class;
            }
            if (valueType == ItemValueType.FLOAT) {
                return Float[].class;
            }
            if (valueType == ItemValueType.DOUBLE) {
                return Double[].class;
            }
            if (valueType == ItemValueType.BOOLEAN) {
                return Boolean[].class;
            }
            if (valueType == ItemValueType.PARAMETERS) {
                return Parameters[].class;
            }
            if (valueType == ItemValueType.FILE) {
                return File[].class;
            }
            if (valueType == ItemValueType.MULTIPART_FILE) {
                return FileParameter[].class;
            }
            return value != null ? value.getClass() : Object[].class;
        }
        if (itemRule.getType() == ItemType.LIST) {
            return value != null ? value.getClass() : List.class;
        }
        if (itemRule.getType() == ItemType.MAP) {
            return value != null ? value.getClass() : Map.class;
        }
        if (itemRule.getType() == ItemType.SET) {
            return value != null ? value.getClass() : Set.class;
        }
        if (itemRule.getType() == ItemType.PROPERTIES) {
            return value != null ? value.getClass() : Properties.class;
        }
        if (valueType == ItemValueType.STRING) {
            return String.class;
        }
        if (valueType == ItemValueType.INT) {
            return Integer.class;
        }
        if (valueType == ItemValueType.LONG) {
            return Long.class;
        }
        if (valueType == ItemValueType.FLOAT) {
            return Float.class;
        }
        if (valueType == ItemValueType.DOUBLE) {
            return Double.class;
        }
        if (valueType == ItemValueType.BOOLEAN) {
            return Boolean.class;
        }
        if (valueType == ItemValueType.PARAMETERS) {
            return Parameters.class;
        }
        if (valueType == ItemValueType.FILE) {
            return File.class;
        }
        if (valueType == ItemValueType.MULTIPART_FILE) {
            return FileParameter.class;
        }
        return value != null ? value.getClass() : Object.class;
    }

    public static Iterator<Token[]> tokenIterator(final ItemRule itemRule) {
        Assert.notNull((Object)itemRule, "itemRule must not be null");
        Iterator<Token[]> it = null;
        if (itemRule.isListableType()) {
            List<Token[]> list = itemRule.getTokensList();
            if (list != null) {
                it = list.iterator();
            }
        } else if (itemRule.isMappableType()) {
            Map<String, Token[]> map = itemRule.getTokensMap();
            if (map != null) {
                it = map.values().iterator();
            }
        } else {
            return new Iterator<Token[]>(){
                private int count = 0;

                @Override
                public boolean hasNext() {
                    return this.count++ < 1;
                }

                @Override
                public Token[] next() {
                    return itemRule.getTokens();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Cannot remove an element of an array");
                }
            };
        }
        return it;
    }

    public static ItemRuleMap toItemRuleMap(List<ItemParameters> itemParametersList) throws IllegalRuleException {
        if (itemParametersList == null || itemParametersList.isEmpty()) {
            return null;
        }
        ItemRuleMap itemRuleMap = new ItemRuleMap();
        for (ItemParameters parameters : itemParametersList) {
            itemRuleMap.putItemRule(ItemRuleUtils.toItemRule(parameters));
        }
        return itemRuleMap;
    }

    @NonNull
    public static ItemRuleList toItemRuleList(List<ItemParameters> itemParametersList) throws IllegalRuleException {
        ItemRuleList itemRuleList = new ItemRuleList();
        if (itemParametersList != null) {
            for (ItemParameters parameters : itemParametersList) {
                itemRuleList.add(ItemRuleUtils.toItemRule(parameters));
            }
        }
        return itemRuleList;
    }

    @NonNull
    public static ItemRule toItemRule(ItemParameters itemParameters) throws IllegalRuleException {
        List<String> stringList;
        Assert.notNull((Object)itemParameters, "itemParameters must not be null");
        String type = itemParameters.getString(ItemParameters.type);
        String name = itemParameters.getString(ItemParameters.name);
        String valueType = itemParameters.getString(ItemParameters.valueType);
        Boolean tokenize = itemParameters.getBoolean(ItemParameters.tokenize);
        Boolean mandatory = itemParameters.getBoolean(ItemParameters.mandatory);
        Boolean secret = itemParameters.getBoolean(ItemParameters.secret);
        ItemRule itemRule = ItemRule.newInstance(type, name, valueType, tokenize, mandatory, secret);
        if (itemRule.isListableType()) {
            List<String> stringList2;
            if (itemRule.getValueType() != ItemValueType.BEAN && (stringList2 = itemParameters.getStringList(ItemParameters.value)) != null) {
                for (String value : stringList2) {
                    itemRule.addValue(value);
                }
            }
        } else if (itemRule.isMappableType()) {
            List parametersList = itemParameters.getParametersList(ItemParameters.entry);
            if (parametersList != null && itemRule.getValueType() != ItemValueType.BEAN) {
                for (Parameters parameters : parametersList) {
                    if (parameters == null) continue;
                    String entryName = parameters.getString(EntryParameters.name);
                    String entryValue = parameters.getString(EntryParameters.value);
                    itemRule.putValue(entryName, entryValue);
                }
            }
        } else if (itemRule.getValueType() != ItemValueType.BEAN && (stringList = itemParameters.getStringList(ItemParameters.value)) != null && !stringList.isEmpty()) {
            itemRule.setValue(stringList.get(0));
        }
        return itemRule;
    }

    @NonNull
    public static ItemRule toItemRule(ParamItem paramItem) throws IllegalRuleException {
        Assert.notNull((Object)paramItem, "paramItem must not be null");
        String name = StringUtils.emptyToNull(paramItem.name());
        String value = StringUtils.emptyToNull(paramItem.value());
        boolean tokenize = paramItem.tokenize();
        boolean mandatory = paramItem.mandatory();
        boolean secret = paramItem.secret();
        ItemRule itemRule = ItemRule.newInstance(null, name, null, tokenize, mandatory, secret);
        itemRule.setValue(value);
        return itemRule;
    }

    @NonNull
    public static ItemRule toItemRule(AttrItem attrItem) throws IllegalRuleException {
        Assert.notNull((Object)attrItem, "attrItem must not be null");
        String name = StringUtils.emptyToNull(attrItem.name());
        String value = StringUtils.emptyToNull(attrItem.value());
        boolean tokenize = attrItem.tokenize();
        boolean mandatory = attrItem.mandatory();
        boolean secret = attrItem.secret();
        ItemRule itemRule = ItemRule.newInstance(null, name, null, tokenize, mandatory, secret);
        itemRule.setValue(value);
        return itemRule;
    }
}

