/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.PointcutPatternRule;
import com.aspectran.core.context.rule.type.PointcutType;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.util.ArrayList;
import java.util.List;

public class PointcutRule {
    private final PointcutType pointcutType;
    private List<PointcutPatternRule> pointcutPatternRuleList;

    public PointcutRule(@Nullable PointcutType pointcutType) {
        this.pointcutType = pointcutType;
    }

    public PointcutType getPointcutType() {
        return this.pointcutType;
    }

    public List<PointcutPatternRule> getPointcutPatternRuleList() {
        return this.pointcutPatternRuleList;
    }

    public void addPointcutPatternRule(PointcutPatternRule pointcutPatternRule) {
        if (pointcutPatternRule == null) {
            throw new IllegalArgumentException("pointcutPatternRule must not be null");
        }
        pointcutPatternRule.setPointcutType(this.pointcutType);
        this.touchPointcutPatternRuleList().add(pointcutPatternRule);
    }

    public List<PointcutPatternRule> touchPointcutPatternRuleList() {
        if (this.pointcutPatternRuleList == null) {
            this.pointcutPatternRuleList = new ArrayList<PointcutPatternRule>();
        }
        return this.pointcutPatternRuleList;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("type", (Object)this.pointcutType);
        tsb.append("patterns", this.pointcutPatternRuleList);
        return tsb.toString();
    }

    @NonNull
    public static PointcutRule newInstance(String type) throws IllegalRuleException {
        PointcutType pointcutType = null;
        if (type != null && (pointcutType = PointcutType.resolve(type)) == null) {
            throw new IllegalRuleException("Unrecognized pointcut type '" + type + "'; Pointcut type for Translet must be 'wildcard' or 'regexp'");
        }
        return new PointcutRule(pointcutType);
    }

    public static PointcutRule newInstance(String[] patterns) {
        if (patterns == null || patterns.length == 0) {
            return null;
        }
        PointcutRule pointcutRule = new PointcutRule(PointcutType.WILDCARD);
        ArrayList<PointcutPatternRule> pointcutPatternRuleList = new ArrayList<PointcutPatternRule>(patterns.length);
        ArrayList<PointcutPatternRule> excludePointcutPatternRuleList = new ArrayList<PointcutPatternRule>(patterns.length);
        for (String pattern : patterns) {
            PointcutPatternRule pointcutPatternRule;
            if (pattern == null) continue;
            if ((pattern = pattern.trim()).startsWith("-")) {
                pattern = pattern.startsWith("-:") ? pattern.substring(2).trim() : pattern.substring(1).trim();
                pointcutPatternRule = PointcutPatternRule.newInstance(pattern);
                excludePointcutPatternRuleList.add(pointcutPatternRule);
                continue;
            }
            if (pattern.startsWith("+:")) {
                pattern = pattern.substring(2).trim();
            } else if (pattern.startsWith("+")) {
                pattern = pattern.substring(1).trim();
            }
            pointcutPatternRule = PointcutPatternRule.newInstance(pattern);
            pointcutPatternRuleList.add(pointcutPatternRule);
        }
        if (pointcutPatternRuleList.isEmpty() && excludePointcutPatternRuleList.isEmpty()) {
            return null;
        }
        if (pointcutPatternRuleList.isEmpty()) {
            PointcutPatternRule pointcutPatternRule = new PointcutPatternRule();
            pointcutPatternRule.setExcludePointcutPatternRuleList(excludePointcutPatternRuleList);
            pointcutRule.addPointcutPatternRule(pointcutPatternRule);
        } else {
            for (PointcutPatternRule pointcutPatternRule : pointcutPatternRuleList) {
                pointcutPatternRule.setPointcutType(pointcutRule.getPointcutType());
                pointcutPatternRule.setExcludePointcutPatternRuleList(excludePointcutPatternRuleList);
                pointcutRule.addPointcutPatternRule(pointcutPatternRule);
            }
        }
        return pointcutRule;
    }
}

