/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ScheduleRule;
import com.aspectran.utils.BooleanUtils;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;

public class ScheduledJobRule {
    private final ScheduleRule scheduleRule;
    private String transletName;
    private Boolean disabled;

    public ScheduledJobRule(ScheduleRule scheduleRule) {
        if (scheduleRule == null) {
            throw new IllegalArgumentException("scheduleRule must not be null");
        }
        this.scheduleRule = scheduleRule;
    }

    public ScheduleRule getScheduleRule() {
        return this.scheduleRule;
    }

    public String getTransletName() {
        return this.transletName;
    }

    public void setTransletName(String transletName) {
        this.transletName = transletName;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public boolean isDisabled() {
        return BooleanUtils.toBoolean(this.disabled);
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("translet", this.transletName);
        tsb.append("disabled", this.disabled);
        return tsb.toString();
    }

    @NonNull
    public static ScheduledJobRule newInstance(ScheduleRule scheduleRule, String transletName, Boolean disabled) throws IllegalRuleException {
        if (transletName == null) {
            throw new IllegalRuleException("The 'job' element requires a 'translet' attribute");
        }
        ScheduledJobRule scheduledJobRule = new ScheduledJobRule(scheduleRule);
        scheduledJobRule.setTransletName(transletName);
        scheduledJobRule.setDisabled(disabled);
        return scheduledJobRule;
    }
}

