/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.params.SettingParameters;
import com.aspectran.core.context.rule.params.SettingsParameters;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.apon.VariableParameters;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SettingsAdviceRule {
    private final AspectRule aspectRule;
    private Map<String, Object> settings;

    public SettingsAdviceRule(AspectRule aspectRule) {
        if (aspectRule == null) {
            throw new IllegalArgumentException("aspectRule must not be null");
        }
        this.aspectRule = aspectRule;
    }

    public String getAspectId() {
        return this.aspectRule.getId();
    }

    public AspectRule getAspectRule() {
        return this.aspectRule;
    }

    public Map<String, Object> getSettings() {
        return this.settings;
    }

    public void setSettings(Map<String, Object> settings) {
        this.settings = settings;
    }

    public <T> T getSetting(String name) {
        return (T)this.settings.get(name);
    }

    public void putSetting(String name, Object value) {
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("Setting name can not be null");
        }
        if (this.settings == null) {
            this.settings = new LinkedHashMap<String, Object>();
        }
        this.settings.put(name, value);
    }

    @NonNull
    public static SettingsAdviceRule newInstance(AspectRule aspectRule) {
        return new SettingsAdviceRule(aspectRule);
    }

    @NonNull
    public static SettingsAdviceRule newInstance(AspectRule aspectRule, SettingsParameters settingsParameters) {
        SettingsAdviceRule sar = new SettingsAdviceRule(aspectRule);
        SettingsAdviceRule.updateSettingsAdviceRule(sar, settingsParameters);
        return sar;
    }

    public static void updateSettingsAdviceRule(SettingsAdviceRule sar, String apon) throws IllegalRuleException {
        if (StringUtils.hasText(apon)) {
            SettingsParameters settingsParameters = new SettingsParameters();
            try {
                VariableParameters parameters = new VariableParameters(apon);
                for (String name : parameters.getParameterNames()) {
                    settingsParameters.putSetting(name, parameters.getValue(name));
                }
            }
            catch (IOException e) {
                throw new IllegalRuleException("Settings parameter can not be parsed", e);
            }
            SettingsAdviceRule.updateSettingsAdviceRule(sar, settingsParameters);
        }
    }

    private static void updateSettingsAdviceRule(SettingsAdviceRule sar, SettingsParameters settingsParameters) {
        List settingParametersList;
        if (settingsParameters != null && (settingParametersList = settingsParameters.getParametersList(SettingsParameters.setting)) != null) {
            for (SettingParameters settingParameters : settingParametersList) {
                sar.putSetting(settingParameters.getName(), settingParameters.getValue());
            }
        }
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        if (this.settings != null) {
            tsb.append("settings", this.settings.keySet());
        }
        return tsb.toString();
    }
}

