/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.asel.token.Token;
import com.aspectran.core.context.asel.token.Tokenizer;
import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.ability.BeanReferenceable;
import com.aspectran.core.context.rule.ability.Replicable;
import com.aspectran.core.context.rule.type.BeanRefererType;
import com.aspectran.core.context.rule.type.TextStyleType;
import com.aspectran.core.context.rule.util.TextStyler;
import com.aspectran.utils.BooleanUtils;
import com.aspectran.utils.ResourceUtils;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;

public class TemplateRule
implements Replicable<TemplateRule>,
BeanReferenceable {
    private static final String INTERNAL_TEMPLATE_ENGINE_NAME = "token";
    private static final String NONE_TEMPLATE_ENGINE_NAME = "none";
    private static final BeanRefererType BEAN_REFERER_TYPE = BeanRefererType.TEMPLATE_RULE;
    private String id;
    private String engine;
    private String name;
    private String file;
    private String resource;
    private String url;
    private TextStyleType textStyle;
    private String content;
    private String contentType;
    private String encoding;
    private Boolean noCache;
    private String engineBeanId;
    private Class<?> engineBeanClass;
    private String templateSource;
    private Token[] templateTokens;
    private boolean tokenize;
    private volatile long lastModifiedTime;
    private volatile boolean loaded;
    private boolean builtin;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getEngine() {
        return this.engine;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public TextStyleType getTextStyle() {
        return this.textStyle;
    }

    protected void setTextStyle(TextStyleType textStyle) {
        this.textStyle = textStyle;
    }

    public String getContent() {
        return this.content;
    }

    protected void setContent(String content) {
        this.content = content;
    }

    public String getContentType() {
        return this.contentType;
    }

    protected void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Boolean getNoCache() {
        return this.noCache;
    }

    public boolean isNoCache() {
        return BooleanUtils.toBoolean(this.noCache);
    }

    public void setNoCache(Boolean noCache) {
        this.noCache = noCache;
    }

    public boolean isBuiltin() {
        return this.builtin;
    }

    public void setBuiltin(boolean builtin) {
        this.builtin = builtin;
    }

    public boolean isOutsourcing() {
        return this.name != null && this.file == null && this.resource == null && this.url == null;
    }

    public String getEngineBeanId() {
        return this.engineBeanId;
    }

    public void setEngineBeanId(String engineBeanId) {
        this.engine = engineBeanId;
        if (engineBeanId != null) {
            switch (engineBeanId) {
                case "token": {
                    this.engineBeanId = null;
                    this.tokenize = true;
                    break;
                }
                case "none": {
                    this.engineBeanId = null;
                    this.tokenize = false;
                    break;
                }
                default: {
                    this.engineBeanId = engineBeanId;
                    this.tokenize = false;
                    break;
                }
            }
        } else {
            this.engineBeanId = null;
            this.tokenize = true;
        }
    }

    public Class<?> getEngineBeanClass() {
        return this.engineBeanClass;
    }

    public void setEngineBeanClass(Class<?> engineBeanClass) {
        this.engineBeanClass = engineBeanClass;
    }

    public boolean isExternalEngine() {
        return this.engineBeanId != null;
    }

    public boolean isTokenize() {
        return this.tokenize;
    }

    public String getTemplateSource() {
        return this.templateSource;
    }

    public String getTemplateSource(ActivityContext context) throws IOException {
        if (this.file != null || this.resource != null || this.url != null) {
            if (this.isNoCache()) {
                return this.loadTemplateSource(context);
            }
            this.loadCachedTemplateSource(context);
            return this.templateSource;
        }
        return this.templateSource;
    }

    public void setTemplateSource(String templateSource) {
        this.templateSource = templateSource;
        if (this.isTokenize()) {
            this.templateTokens = this.parseContentTokens(templateSource);
        }
    }

    protected void setTemplateSource(String templateSource, Token[] templateTokens) {
        this.templateSource = templateSource;
        this.templateTokens = templateTokens;
    }

    public Token[] getTemplateTokens() {
        return this.templateTokens;
    }

    public Token[] getTemplateTokens(ActivityContext context) throws IOException {
        if (this.isExternalEngine()) {
            throw new UnsupportedOperationException();
        }
        if (this.file != null || this.resource != null || this.url != null) {
            if (this.isNoCache()) {
                String source = this.loadTemplateSource(context);
                return this.parseContentTokens(source);
            }
            this.loadCachedTemplateSource(context);
            return this.templateTokens;
        }
        return this.templateTokens;
    }

    private Token[] parseContentTokens(String content) {
        if (content == null || content.isEmpty()) {
            return null;
        }
        List<Token> tokenList = Tokenizer.tokenize(content, false);
        if (!tokenList.isEmpty()) {
            return tokenList.toArray(new Token[0]);
        }
        return new Token[0];
    }

    private String loadTemplateSource(ActivityContext context) throws IOException {
        String templateSource = null;
        if (this.file != null) {
            File file = context.getApplicationAdapter().toRealPathAsFile(this.file);
            templateSource = ResourceUtils.read(file, this.encoding);
        } else if (this.resource != null) {
            ClassLoader classLoader = context.getAvailableActivity().getClassLoader();
            URL url = classLoader.getResource(this.resource);
            templateSource = ResourceUtils.read(url, this.encoding);
        } else if (this.url != null) {
            URL url = URI.create(this.url).toURL();
            templateSource = ResourceUtils.read(url, this.encoding);
        }
        return templateSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCachedTemplateSource(ActivityContext context) throws IOException {
        boolean loaded;
        if (this.file != null) {
            File file = context.getApplicationAdapter().toRealPathAsFile(this.file);
            long time1 = this.lastModifiedTime;
            long time2 = file.lastModified();
            if (time2 > time1) {
                TemplateRule templateRule = this;
                synchronized (templateRule) {
                    time1 = this.lastModifiedTime;
                    time2 = file.lastModified();
                    if (time2 > time1) {
                        String template = ResourceUtils.read(file, this.encoding);
                        this.setTemplateSource(template);
                        this.lastModifiedTime = time2;
                    }
                }
            }
        } else if (this.resource != null) {
            boolean loaded2 = this.loaded;
            if (!loaded2) {
                TemplateRule templateRule = this;
                synchronized (templateRule) {
                    loaded2 = this.loaded;
                    if (!loaded2) {
                        URL url = context.getAvailableActivity().getClassLoader().getResource(this.resource);
                        String template = ResourceUtils.read(url, this.encoding);
                        this.setTemplateSource(template);
                        this.loaded = true;
                    }
                }
            }
        } else if (this.url != null && !(loaded = this.loaded)) {
            TemplateRule templateRule = this;
            synchronized (templateRule) {
                loaded = this.loaded;
                if (!loaded) {
                    URL url = URI.create(this.url).toURL();
                    String template = ResourceUtils.read(url, this.encoding);
                    this.setTemplateSource(template);
                    this.loaded = true;
                }
            }
        }
    }

    @Override
    public TemplateRule replicate() {
        return TemplateRule.replicate(this);
    }

    @Override
    public BeanRefererType getBeanRefererType() {
        return BEAN_REFERER_TYPE;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        if (!this.builtin) {
            tsb.append("id", this.id);
        }
        tsb.append("engine", this.engine);
        if (this.file != null) {
            tsb.append("file", this.file);
        } else if (this.resource != null) {
            tsb.append("resource", this.resource);
        } else if (this.url != null) {
            tsb.append("url", this.url);
        } else if (this.name != null) {
            tsb.append("name", this.name);
        } else {
            tsb.appendSize("contentLength", this.content);
        }
        tsb.append("style", (Object)this.textStyle);
        tsb.append("contentType", this.contentType);
        tsb.append("encoding", this.encoding);
        tsb.append("noCache", this.noCache);
        return tsb.toString();
    }

    @NonNull
    public static TemplateRule newInstance(String id, String engine, String name, String file, String resource, String url, String style, String content, String contentType, String encoding, Boolean noCache) throws IllegalRuleException {
        if (id == null) {
            throw new IllegalRuleException("The 'template' element requires an 'id' attribute");
        }
        TextStyleType textStyleType = TextStyleType.resolve(style);
        if (style != null && textStyleType == null) {
            throw new IllegalRuleException("No text style type for '" + style + "'");
        }
        TemplateRule tr = new TemplateRule();
        tr.setId(id);
        tr.setEngineBeanId(engine);
        tr.setName(name);
        tr.setFile(file);
        tr.setResource(resource);
        tr.setUrl(url);
        tr.setTextStyle(textStyleType);
        tr.setContent(content);
        tr.setContentType(contentType);
        tr.setEncoding(encoding);
        tr.setNoCache(noCache);
        TemplateRule.updateTemplateSource(tr);
        return tr;
    }

    @NonNull
    public static TemplateRule newInstanceForBuiltin(String id, String engine, String name, String file, String resource, String url, String style, String content, String contentType, String encoding, Boolean noCache) throws IllegalRuleException {
        TextStyleType textStyleType = TextStyleType.resolve(style);
        if (style != null && textStyleType == null) {
            throw new IllegalRuleException("No text style type for '" + style + "'");
        }
        TemplateRule tr = new TemplateRule();
        tr.setId(id);
        tr.setEngineBeanId(engine);
        tr.setName(name);
        tr.setFile(file);
        tr.setResource(resource);
        tr.setUrl(url);
        tr.setTextStyle(textStyleType);
        tr.setContent(content);
        tr.setContentType(contentType);
        tr.setEncoding(encoding);
        tr.setNoCache(noCache);
        tr.setBuiltin(true);
        TemplateRule.updateTemplateSource(tr);
        return tr;
    }

    @NonNull
    public static TemplateRule replicate(@NonNull TemplateRule templateRule) {
        TemplateRule tr = new TemplateRule();
        tr.setId(templateRule.getId());
        tr.setEngineBeanId(templateRule.getEngine());
        tr.setEngineBeanClass(templateRule.getEngineBeanClass());
        tr.setName(templateRule.getName());
        tr.setFile(templateRule.getFile());
        tr.setResource(templateRule.getResource());
        tr.setUrl(templateRule.getUrl());
        tr.setTextStyle(templateRule.getTextStyle());
        tr.setContent(templateRule.getContent());
        tr.setContentType(templateRule.getContentType());
        tr.setTemplateSource(templateRule.getTemplateSource(), templateRule.getTemplateTokens());
        tr.setEncoding(templateRule.getEncoding());
        tr.setNoCache(templateRule.getNoCache());
        tr.setBuiltin(templateRule.isBuiltin());
        return tr;
    }

    public static void updateTemplateSource(@NonNull TemplateRule templateRule, String content) {
        templateRule.setContent(content);
        TemplateRule.updateTemplateSource(templateRule);
    }

    private static void updateTemplateSource(@NonNull TemplateRule templateRule) {
        String content = templateRule.getContent();
        if (content != null) {
            content = TextStyler.styling(content, templateRule.getTextStyle());
            templateRule.setTemplateSource(content);
        }
    }
}

