/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule;

import com.aspectran.core.context.rule.TemplateRule;
import com.aspectran.core.context.rule.ability.Replicable;
import com.aspectran.core.context.rule.type.ContentType;
import com.aspectran.core.context.rule.type.FormatType;
import com.aspectran.core.context.rule.type.ResponseType;
import com.aspectran.utils.BooleanUtils;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;

public class TransformRule
implements Replicable<TransformRule> {
    public static final ResponseType RESPONSE_TYPE = ResponseType.TRANSFORM;
    private FormatType formatType;
    private String contentType;
    private String encoding;
    private Boolean pretty;
    private String templateId;
    private TemplateRule templateRule;
    private Boolean defaultResponse;

    public FormatType getFormatType() {
        return this.formatType;
    }

    public void setFormatType(FormatType formatType) {
        if (formatType == FormatType.CUSTOM) {
            throw new IllegalArgumentException("CustomTransform is only allowed to be defined via an annotated method");
        }
        this.formatType = formatType;
        if (this.contentType == null && formatType != null) {
            if (formatType == FormatType.TEXT) {
                this.contentType = ContentType.TEXT_PLAIN.toString();
            } else if (formatType == FormatType.JSON) {
                this.contentType = ContentType.APPLICATION_JSON.toString();
            } else if (formatType == FormatType.XML) {
                this.contentType = ContentType.APPLICATION_XML.toString();
            }
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Boolean getPretty() {
        return this.pretty;
    }

    public boolean isPretty() {
        return BooleanUtils.toBoolean(this.pretty);
    }

    public void setPretty(Boolean pretty) {
        this.pretty = pretty;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public TemplateRule getTemplateRule() {
        return this.templateRule;
    }

    public void setTemplateRule(TemplateRule templateRule) {
        this.templateRule = templateRule;
        if (templateRule != null) {
            this.templateId = templateRule.getId();
            if (this.formatType == null) {
                this.setFormatType(FormatType.TEXT);
            }
            if (templateRule.getEncoding() != null && this.encoding == null) {
                this.encoding = templateRule.getEncoding();
            }
        }
    }

    public Boolean getDefaultResponse() {
        return this.defaultResponse;
    }

    public boolean isDefaultResponse() {
        return BooleanUtils.toBoolean(this.defaultResponse);
    }

    public void setDefaultResponse(Boolean defaultResponse) {
        this.defaultResponse = defaultResponse;
    }

    @Override
    public TransformRule replicate() {
        return TransformRule.replicate(this);
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.appendForce("type", (Object)RESPONSE_TYPE);
        tsb.appendForce("format", (Object)this.formatType);
        tsb.append("contentType", this.contentType);
        tsb.append("encoding", this.encoding);
        tsb.append("default", this.getDefaultResponse());
        tsb.append("pretty", this.pretty);
        tsb.append("template", this.templateId);
        tsb.append("template", this.templateRule);
        return tsb.toString();
    }

    @NonNull
    public static TransformRule newInstance(String format, String contentType, String encoding, Boolean defaultResponse, Boolean pretty) {
        FormatType formatType = FormatType.resolve(format);
        return TransformRule.newInstance(formatType, contentType, encoding, defaultResponse, pretty);
    }

    @NonNull
    public static TransformRule newInstance(FormatType formatType, String contentType, String encoding, Boolean pretty) {
        return TransformRule.newInstance(formatType, contentType, encoding, null, pretty);
    }

    @NonNull
    public static TransformRule newInstance(FormatType formatType, String contentType, String encoding, Boolean defaultResponse, Boolean pretty) {
        if (formatType == null && contentType != null) {
            formatType = FormatType.resolve(ContentType.resolve(contentType));
        }
        TransformRule tr = new TransformRule();
        tr.setFormatType(formatType);
        if (contentType != null) {
            tr.setContentType(contentType);
        }
        tr.setEncoding(encoding);
        tr.setDefaultResponse(defaultResponse);
        tr.setPretty(pretty);
        return tr;
    }

    @NonNull
    public static TransformRule replicate(@NonNull TransformRule transformRule) {
        TransformRule tr = new TransformRule();
        tr.setFormatType(transformRule.getFormatType());
        tr.setContentType(transformRule.getContentType());
        tr.setEncoding(transformRule.getEncoding());
        tr.setDefaultResponse(transformRule.getDefaultResponse());
        tr.setPretty(transformRule.getPretty());
        TemplateRule templateRule = transformRule.getTemplateRule();
        if (templateRule != null) {
            tr.setTemplateRule(templateRule.replicate());
        }
        return tr;
    }
}

