/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.appender;

import com.aspectran.core.context.env.EnvironmentProfiles;
import com.aspectran.core.context.rule.AppendRule;
import com.aspectran.core.context.rule.appender.AbstractRuleAppender;
import com.aspectran.core.context.rule.appender.FileRuleAppender;
import com.aspectran.core.context.rule.appender.ParametersRuleAppender;
import com.aspectran.core.context.rule.appender.ResourceRuleAppender;
import com.aspectran.core.context.rule.appender.RuleAppendHandler;
import com.aspectran.core.context.rule.appender.RuleAppender;
import com.aspectran.core.context.rule.appender.UrlRuleAppender;
import com.aspectran.core.context.rule.assistant.ActivityRuleAssistant;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractAppendHandler
implements RuleAppendHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ActivityRuleAssistant assistant;
    private final EnvironmentProfiles environmentProfiles;
    private List<RuleAppender> pendingList;
    private RuleAppender currentRuleAppender;
    private boolean useAponToLoadXml;
    private boolean debugMode;

    AbstractAppendHandler(@NonNull ActivityRuleAssistant assistant) {
        this.assistant = assistant;
        this.environmentProfiles = assistant.getEnvironmentProfiles();
    }

    @Override
    public ActivityRuleAssistant getContextRuleAssistant() {
        return this.assistant;
    }

    @Override
    public void pending(@NonNull AppendRule appendRule) {
        AbstractRuleAppender appender = null;
        if (appendRule.getAspectranParameters() != null) {
            appender = new ParametersRuleAppender();
        } else if (StringUtils.hasText(appendRule.getFile())) {
            appender = new FileRuleAppender(this.assistant.getBasePath(), appendRule.getFile());
        } else if (StringUtils.hasText(appendRule.getResource())) {
            appender = new ResourceRuleAppender(appendRule.getResource(), this.assistant.getClassLoader());
        } else if (StringUtils.hasText(appendRule.getUrl())) {
            appender = new UrlRuleAppender(appendRule.getUrl());
        }
        if (appender != null) {
            appender.setAppendRule(appendRule);
            this.pending(appender);
        }
    }

    private void pending(RuleAppender appender) {
        if (this.pendingList == null) {
            this.pendingList = new ArrayList<RuleAppender>();
        }
        this.pendingList.add(appender);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("pending RuleAppender " + String.valueOf(appender));
        }
    }

    protected void handle() throws Exception {
        if (this.pendingList != null) {
            List<RuleAppender> pendedList = this.pendingList;
            this.pendingList = null;
            for (RuleAppender appender : pendedList) {
                if (this.environmentProfiles != null && !this.environmentProfiles.acceptsProfiles(appender.getProfiles())) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Append rules " + String.valueOf(appender));
                }
                this.handle(appender);
            }
        }
    }

    @Override
    public List<RuleAppender> getPendingList() {
        return this.pendingList;
    }

    @Override
    public RuleAppender getCurrentRuleAppender() {
        return this.currentRuleAppender;
    }

    @Override
    public void setCurrentRuleAppender(RuleAppender currentRuleAppender) {
        this.currentRuleAppender = currentRuleAppender;
    }

    protected boolean isUseAponToLoadXml() {
        return this.useAponToLoadXml;
    }

    @Override
    public void setUseAponToLoadXml(boolean useAponToLoadXml) {
        this.useAponToLoadXml = useAponToLoadXml;
    }

    protected boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }
}

