/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.appender;

import com.aspectran.core.context.env.Profiles;
import com.aspectran.core.context.rule.AppendRule;
import com.aspectran.core.context.rule.appender.RuleAppender;
import com.aspectran.core.context.rule.type.AppendableFileFormatType;
import com.aspectran.core.context.rule.type.AppenderType;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.nodelet.NodeTracker;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

abstract class AbstractRuleAppender
implements RuleAppender {
    private final AppenderType appenderType;
    private AppendRule appendRule;
    private AppendableFileFormatType appendableFileFormatType;
    private Profiles profiles;
    private long lastModified;
    private NodeTracker nodeTracker;

    AbstractRuleAppender(AppenderType appenderType) {
        this.appenderType = appenderType;
    }

    @Override
    public AppenderType getAppenderType() {
        return this.appenderType;
    }

    @Override
    public AppendRule getAppendRule() {
        return this.appendRule;
    }

    @Override
    public void setAppendRule(@NonNull AppendRule appendRule) {
        this.appendRule = appendRule;
        if (appendRule.getFormat() != null) {
            this.appendableFileFormatType = appendRule.getFormat();
        }
        this.setProfiles(appendRule.getProfiles());
    }

    @Override
    public AppendableFileFormatType getAppendableFileFormatType() {
        return this.appendableFileFormatType;
    }

    @Override
    public void setAppendableFileFormatType(AppendableFileFormatType appendableFileFormatType) {
        this.appendableFileFormatType = appendableFileFormatType;
    }

    protected void determineAppendedFileFormatType(String resourceName) {
        if (resourceName != null && resourceName.toLowerCase().endsWith(".apon")) {
            this.setAppendableFileFormatType(AppendableFileFormatType.APON);
        } else {
            this.setAppendableFileFormatType(AppendableFileFormatType.XML);
        }
    }

    @Override
    public Profiles getProfiles() {
        return this.profiles;
    }

    private void setProfiles(Profiles profiles) {
        this.profiles = profiles;
    }

    @Override
    public void setProfile(String profile) {
        this.setProfiles(profile != null ? Profiles.of(profile) : null);
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public Reader getReader() throws IOException {
        return this.getReader(null);
    }

    @Override
    public Reader getReader(String encoding) throws IOException {
        if (encoding != null) {
            return new InputStreamReader(this.getInputStream(), encoding);
        }
        return new InputStreamReader(this.getInputStream());
    }

    @Override
    public NodeTracker getNodeTracker() {
        return this.nodeTracker;
    }

    @Override
    public void setNodeTracker(NodeTracker nodeTracker) {
        this.nodeTracker = nodeTracker;
    }
}

