/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.appender;

import com.aspectran.core.context.rule.IllegalRuleException;
import com.aspectran.core.context.rule.appender.AbstractAppendHandler;
import com.aspectran.core.context.rule.appender.FileRuleAppender;
import com.aspectran.core.context.rule.appender.RuleAppender;
import com.aspectran.core.context.rule.assistant.ActivityRuleAssistant;
import com.aspectran.core.context.rule.assistant.AssistantLocal;
import com.aspectran.core.context.rule.assistant.ShallowContextRuleAssistant;
import com.aspectran.core.context.rule.converter.ParametersToRules;
import com.aspectran.core.context.rule.converter.RulesToParameters;
import com.aspectran.core.context.rule.params.AspectranParameters;
import com.aspectran.core.context.rule.params.RootParameters;
import com.aspectran.core.context.rule.parser.xml.AspectranDtdResolver;
import com.aspectran.core.context.rule.parser.xml.AspectranNodeParser;
import com.aspectran.core.context.rule.type.AppendableFileFormatType;
import com.aspectran.core.context.rule.type.AppenderType;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.apon.AponWriter;
import com.aspectran.utils.apon.XmlToParameters;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.xml.sax.EntityResolver;

public class HybridRuleAppendHandler
extends AbstractAppendHandler {
    private final String encoding;
    private AspectranNodeParser aspectranNodeParser;
    private EntityResolver entityResolver;

    public HybridRuleAppendHandler(ActivityRuleAssistant assistant, String encoding) {
        super(assistant);
        this.encoding = encoding;
    }

    @Override
    public void handle(RuleAppender appender) throws Exception {
        this.setCurrentRuleAppender(appender);
        AssistantLocal assistantLocal = this.getContextRuleAssistant().backupAssistantLocal();
        if (appender != null) {
            if (appender.getAppenderType() == AppenderType.PARAMETERS) {
                AspectranParameters aspectranParameters = appender.getAppendRule().getAspectranParameters();
                RootParameters rootParameters = new RootParameters(aspectranParameters);
                this.convertToRules(rootParameters);
            } else {
                if (appender.getAppendableFileFormatType() == AppendableFileFormatType.APON) {
                    try (Reader reader = appender.getReader(this.encoding);){
                        RootParameters rootParameters = new RootParameters(reader);
                        this.convertToRules(rootParameters);
                    }
                }
                if (this.isUseAponToLoadXml()) {
                    RootParameters rootParameters;
                    if (appender.getAppenderType() == AppenderType.FILE) {
                        FileRuleAppender fileRuleAppender = (FileRuleAppender)appender;
                        rootParameters = (RootParameters)XmlToParameters.from(fileRuleAppender.getFile(), RootParameters.class, this.getEntityResolver());
                        if (this.isDebugMode()) {
                            this.saveAsAponFile(fileRuleAppender, rootParameters);
                        }
                    } else {
                        try (Reader reader = appender.getReader(this.encoding);){
                            rootParameters = (RootParameters)XmlToParameters.from(reader, RootParameters.class, this.getEntityResolver());
                        }
                    }
                    this.convertToRules(rootParameters);
                } else {
                    this.getAspectranNodeParser().parse(appender);
                    if (this.isDebugMode() && appender.getAppenderType() == AppenderType.FILE) {
                        FileRuleAppender fileRuleAppender = (FileRuleAppender)appender;
                        this.saveAsAponFile(fileRuleAppender);
                    }
                }
            }
        }
        super.handle();
        if (assistantLocal.getReplicatedCount() > 0) {
            this.getContextRuleAssistant().restoreAssistantLocal(assistantLocal);
        }
    }

    private AspectranNodeParser getAspectranNodeParser() {
        if (this.aspectranNodeParser == null) {
            this.aspectranNodeParser = new AspectranNodeParser(this.getContextRuleAssistant());
        }
        return this.aspectranNodeParser;
    }

    private EntityResolver getEntityResolver() {
        if (this.entityResolver == null) {
            this.entityResolver = new AspectranDtdResolver(false);
        }
        return this.entityResolver;
    }

    private void convertToRules(RootParameters rootParameters) throws IllegalRuleException {
        new ParametersToRules(this.getContextRuleAssistant()).toRules(rootParameters);
    }

    private void saveAsAponFile(FileRuleAppender fileRuleAppender) throws IOException {
        RootParameters rootParameters;
        ShallowContextRuleAssistant assistant = null;
        try {
            assistant = new ShallowContextRuleAssistant();
            ((ActivityRuleAssistant)assistant).prepare();
            AspectranNodeParser parser = new AspectranNodeParser(assistant, false, false);
            parser.parse(fileRuleAppender);
            rootParameters = RulesToParameters.toRootParameters(assistant);
        }
        catch (Exception e) {
            throw new IOException("Failed to convert as Root Parameters: " + String.valueOf(fileRuleAppender), e);
        }
        finally {
            if (assistant != null) {
                ((ActivityRuleAssistant)assistant).release();
            }
        }
        this.saveAsAponFile(fileRuleAppender, rootParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAsAponFile(FileRuleAppender fileRuleAppender, RootParameters rootParameters) throws IOException {
        File xmlFile = this.makeFile(fileRuleAppender);
        File aponFile = this.makeAponFile(fileRuleAppender);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Save as APON file: " + String.valueOf(aponFile));
        }
        try {
            AponWriter aponWriter;
            if (this.encoding != null) {
                FileOutputStream outputStream = new FileOutputStream(aponFile);
                aponWriter = new AponWriter(new OutputStreamWriter((OutputStream)outputStream, this.encoding));
            } else {
                aponWriter = new AponWriter(new FileWriter(aponFile));
            }
            aponWriter.nullWritable(false);
            try {
                aponWriter.comment(xmlFile.getAbsolutePath());
                aponWriter.write(rootParameters);
            }
            finally {
                try {
                    aponWriter.close();
                }
                catch (IOException e) {
                    this.logger.error("Exception during closing file " + String.valueOf(aponFile), e);
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to save as APON file: " + String.valueOf(aponFile), e);
        }
    }

    @NonNull
    private File makeFile(@NonNull FileRuleAppender fileRuleAppender) {
        String basePath = fileRuleAppender.getBasePath();
        String filePath = fileRuleAppender.getFilePath();
        return new File(basePath, filePath);
    }

    @NonNull
    private File makeAponFile(@NonNull FileRuleAppender fileRuleAppender) {
        String basePath = fileRuleAppender.getBasePath();
        String filePath = fileRuleAppender.getFilePath() + "." + String.valueOf((Object)AppendableFileFormatType.APON);
        return new File(basePath, filePath);
    }
}

