/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.appender;

import com.aspectran.core.context.rule.appender.AbstractRuleAppender;
import com.aspectran.core.context.rule.type.AppenderType;
import com.aspectran.utils.ToStringBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;

public class UrlRuleAppender
extends AbstractRuleAppender {
    private final String ruleUrl;

    public UrlRuleAppender(String ruleUrl) {
        super(AppenderType.URL);
        this.ruleUrl = ruleUrl;
        this.determineAppendedFileFormatType(ruleUrl);
    }

    @Override
    public String getQualifiedName() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            URL url = new URI(this.ruleUrl).toURL();
            URLConnection conn = url.openConnection();
            this.setLastModified(conn.getLastModified());
            return conn.getInputStream();
        }
        catch (Exception e) {
            throw new IOException("Failed to get rules from url: " + this.ruleUrl, e);
        }
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("url", this.ruleUrl);
        tsb.append("format", (Object)this.getAppendableFileFormatType());
        tsb.append("profile", this.getProfiles());
        return tsb.toString();
    }
}

