/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.assistant;

import com.aspectran.core.context.rule.assistant.BeanReferenceInspector;
import com.aspectran.core.context.rule.parser.ActivityContextParserException;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.util.Map;

public class BeanReferenceException
extends ActivityContextParserException {
    private static final long serialVersionUID = -244633940486989865L;

    BeanReferenceException(Map<BeanReferenceInspector.RefererInfo, BeanReferenceInspector.RefererKey> brokenReferences) {
        super(BeanReferenceException.getMessage(brokenReferences));
    }

    @NonNull
    private static String getMessage(@NonNull Map<BeanReferenceInspector.RefererInfo, BeanReferenceInspector.RefererKey> brokenReferences) {
        Map.Entry<BeanReferenceInspector.RefererInfo, BeanReferenceInspector.RefererKey> first = brokenReferences.entrySet().iterator().next();
        return BeanReferenceException.getDetailMessage(first.getValue(), first.getKey()) + (String)(brokenReferences.size() > 1 ? " (and " + (brokenReferences.size() - 1) + " more)" : "");
    }

    @NonNull
    private static String getDetailMessage(BeanReferenceInspector.RefererKey refererKey, BeanReferenceInspector.RefererInfo refererInfo) {
        if (refererKey != null) {
            String beanId = refererKey.getQualifier();
            Class<?> beanClass = refererKey.getType();
            if (beanId != null) {
                return "Cannot resolve reference to bean " + String.valueOf(refererKey) + "; Referer: " + String.valueOf(refererInfo);
            }
            return "No unique bean of type [" + String.valueOf(beanClass) + "] is defined; Referer: " + String.valueOf(refererInfo);
        }
        return "Cannot resolve reference: " + String.valueOf(refererInfo);
    }
}

