/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.assistant;

import com.aspectran.core.component.bean.BeanRuleAnalyzer;
import com.aspectran.core.component.bean.BeanRuleException;
import com.aspectran.core.component.bean.BeanRuleRegistry;
import com.aspectran.core.component.bean.NoUniqueBeanException;
import com.aspectran.core.context.asel.token.Token;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.InvokeActionRule;
import com.aspectran.core.context.rule.ability.BeanReferenceable;
import com.aspectran.core.context.rule.appender.RuleAppender;
import com.aspectran.core.context.rule.assistant.BeanReferenceException;
import com.aspectran.core.context.rule.type.BeanRefererType;
import com.aspectran.utils.BeanUtils;
import com.aspectran.utils.MethodUtils;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.utils.nodelet.NodeTracker;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BeanReferenceInspector {
    private static final Logger logger = LoggerFactory.getLogger(BeanReferenceInspector.class);
    private final Map<RefererKey, Set<RefererInfo>> refererInfoMap = new LinkedHashMap<RefererKey, Set<RefererInfo>>(256);

    public void reserve(String beanId, Class<?> beanClass, BeanReferenceable referenceable, RuleAppender ruleAppender) {
        RefererKey key = new RefererKey(beanClass, beanId);
        Set<RefererInfo> refererInfoSet = this.refererInfoMap.get(key);
        if (refererInfoSet == null) {
            refererInfoSet = new LinkedHashSet<RefererInfo>();
            refererInfoSet.add(new RefererInfo(referenceable, ruleAppender));
            this.refererInfoMap.put(key, refererInfoSet);
        } else {
            refererInfoSet.add(new RefererInfo(referenceable, ruleAppender));
        }
    }

    public void inspect(BeanRuleRegistry beanRuleRegistry) throws BeanReferenceException, BeanRuleException {
        LinkedHashMap<RefererInfo, RefererKey> brokenReferences = new LinkedHashMap<RefererInfo, RefererKey>();
        for (Map.Entry<RefererKey, Set<RefererInfo>> entry : this.refererInfoMap.entrySet()) {
            BeanRule[] beanRules;
            BeanRule beanRule;
            Set<RefererInfo> refererInfoSet;
            Class<?> beanClass;
            String beanId;
            RefererKey refererKey;
            block17: {
                block13: {
                    block14: {
                        block15: {
                            block16: {
                                refererKey = entry.getKey();
                                beanId = refererKey.getQualifier();
                                beanClass = refererKey.getType();
                                refererInfoSet = entry.getValue();
                                beanRule = null;
                                beanRules = null;
                                if (beanClass == null) break block13;
                                beanRules = beanRuleRegistry.getBeanRules(beanClass);
                                if (beanRules == null) break block14;
                                if (beanRules.length != 1) break block15;
                                if (beanId == null) break block16;
                                if (!beanId.equals(beanRules[0].getId())) break block14;
                                beanRule = beanRules[0];
                                break block14;
                            }
                            beanRule = beanRules[0];
                            break block14;
                        }
                        if (beanId != null) {
                            for (BeanRule br : beanRules) {
                                if (!beanId.equals(br.getId())) continue;
                                beanRule = br;
                                break;
                            }
                        }
                    }
                    if (beanRule == null && beanRules == null) {
                        beanRule = beanRuleRegistry.getBeanRuleForConfig(beanClass);
                    }
                    break block17;
                }
                if (beanId != null) {
                    beanRule = beanRuleRegistry.getBeanRule(beanId);
                }
            }
            if (beanRule == null) {
                if (beanRules != null && beanRules.length > 1) {
                    for (RefererInfo refererInfo : refererInfoSet) {
                        if (beanId != null) {
                            logger.error("Cannot resolve reference to bean " + String.valueOf(refererKey) + "; Referer: " + String.valueOf(refererInfo));
                        } else {
                            logger.error("No unique bean of type [" + String.valueOf(beanClass) + "] is defined: expected single matching bean but found " + beanRules.length + ": [" + NoUniqueBeanException.getBeanDescriptions(beanRules) + "]; Referer: " + String.valueOf(refererInfo));
                        }
                        brokenReferences.put(refererInfo, refererKey);
                    }
                    continue;
                }
                for (RefererInfo refererInfo : refererInfoSet) {
                    if (this.isValidStaticReference(refererInfo)) continue;
                    logger.error("Cannot resolve reference: " + String.valueOf(refererInfo));
                    brokenReferences.put(refererInfo, null);
                }
                continue;
            }
            for (RefererInfo refererInfo : refererInfoSet) {
                if (refererInfo.getBeanRefererType() != BeanRefererType.BEAN_METHOD_ACTION_RULE) continue;
                this.checkTransletActionParameter((InvokeActionRule)refererInfo.getReferenceable(), beanRule, refererInfo);
            }
        }
        if (!brokenReferences.isEmpty()) {
            throw new BeanReferenceException(brokenReferences);
        }
    }

    private boolean isValidStaticReference(@NonNull RefererInfo refererInfo) {
        Token token;
        if (refererInfo.getBeanRefererType() == BeanRefererType.TOKEN && (token = (Token)refererInfo.getReferenceable()).getAlternativeValue() != null && token.getGetterName() != null) {
            T[] enums;
            Class beanClass = (Class)token.getAlternativeValue();
            if (beanClass.isEnum() && (enums = beanClass.getEnumConstants()) != null) {
                for (Object en : enums) {
                    if (!token.getGetterName().equals(en.toString())) continue;
                    return true;
                }
            }
            return BeanUtils.hasReadableProperty((Class)token.getAlternativeValue(), token.getGetterName());
        }
        return false;
    }

    private void checkTransletActionParameter(@NonNull InvokeActionRule invokeActionRule, BeanRule beanRule, RefererInfo refererInfo) throws BeanRuleException {
        if (invokeActionRule.getArgumentItemRuleMap() == null) {
            String methodName;
            Class<?> beanClass = beanRule.getTargetBeanClass();
            Method m1 = MethodUtils.getAccessibleMethod(beanClass, methodName = invokeActionRule.getMethodName(), BeanRuleAnalyzer.TRANSLET_ACTION_PARAMETER_TYPES);
            if (m1 != null) {
                invokeActionRule.setMethod(m1);
                invokeActionRule.setRequiresTranslet(true);
            } else {
                Method m2 = MethodUtils.getAccessibleMethod(beanClass, methodName);
                if (m2 == null) {
                    throw new BeanRuleException("No such bean method " + methodName + "() on bean " + String.valueOf(beanClass) + " in " + String.valueOf(refererInfo), beanRule);
                }
                invokeActionRule.setMethod(m2);
                invokeActionRule.setRequiresTranslet(false);
            }
        }
    }

    static class RefererKey {
        private final Class<?> type;
        private final String qualifier;
        private volatile int hashCode;

        RefererKey(Class<?> type, String qualifier) {
            this.type = type;
            this.qualifier = qualifier;
        }

        Class<?> getType() {
            return this.type;
        }

        String getQualifier() {
            return this.qualifier;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RefererKey)) {
                return false;
            }
            RefererKey key = (RefererKey)other;
            return Objects.equals(this.type, key.type) && Objects.equals(this.qualifier, key.qualifier);
        }

        public int hashCode() {
            int prime = 31;
            int result = this.hashCode;
            if (result == 0) {
                result = 11;
                if (this.type != null) {
                    result = 31 * result + this.type.hashCode();
                }
                if (this.qualifier != null) {
                    result = 31 * result + this.qualifier.hashCode();
                }
                this.hashCode = result;
            }
            return result;
        }

        public String toString() {
            ToStringBuilder tsb = new ToStringBuilder();
            tsb.append("type", this.type);
            tsb.append("qualifier", this.qualifier);
            return tsb.toString();
        }
    }

    static class RefererInfo {
        private final BeanReferenceable referenceable;
        private final RuleAppender ruleAppender;
        private final NodeTracker nodeTracker;

        RefererInfo(@NonNull BeanReferenceable referenceable, @Nullable RuleAppender ruleAppender) {
            NodeTracker nodeTracker;
            this.referenceable = referenceable;
            this.ruleAppender = ruleAppender;
            this.nodeTracker = ruleAppender != null ? ((nodeTracker = ruleAppender.getNodeTracker()) != null ? nodeTracker.getClonedNodeTracker() : null) : null;
        }

        BeanReferenceable getReferenceable() {
            return this.referenceable;
        }

        RuleAppender getRuleAppender() {
            return this.ruleAppender;
        }

        BeanRefererType getBeanRefererType() {
            return this.referenceable.getBeanRefererType();
        }

        NodeTracker getNodeTracker() {
            return this.nodeTracker;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this.referenceable.getBeanRefererType());
            sb.append(" ").append(this.referenceable);
            if (this.ruleAppender != null) {
                sb.append(" in ").append(this.ruleAppender.getQualifiedName());
                if (this.nodeTracker != null) {
                    sb.append(" ").append(this.nodeTracker);
                }
            }
            return sb.toString();
        }
    }
}

