/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.assistant;

import com.aspectran.core.context.rule.type.DefaultSettingType;
import com.aspectran.utils.BooleanUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.util.Map;

public class DefaultSettings {
    private String transletNamePrefix;
    private String transletNameSuffix;
    private Boolean pointcutPatternVerifiable;
    private String defaultTemplateEngineBean;
    private String defaultSchedulerBean;

    public DefaultSettings() {
    }

    public DefaultSettings(@NonNull DefaultSettings ds) {
        this.transletNamePrefix = ds.getTransletNamePrefix();
        this.transletNameSuffix = ds.getTransletNameSuffix();
        this.pointcutPatternVerifiable = ds.getPointcutPatternVerifiable();
        this.defaultTemplateEngineBean = ds.getDefaultTemplateEngineBean();
        this.defaultSchedulerBean = ds.getDefaultSchedulerBean();
    }

    public String getTransletNamePrefix() {
        return this.transletNamePrefix;
    }

    public void setTransletNamePrefix(String transletNamePrefix) {
        this.transletNamePrefix = transletNamePrefix;
    }

    public String getTransletNameSuffix() {
        return this.transletNameSuffix;
    }

    public void setTransletNameSuffix(String transletNameSuffix) {
        this.transletNameSuffix = transletNameSuffix;
    }

    public boolean isPointcutPatternVerifiable() {
        return BooleanUtils.toBoolean(this.pointcutPatternVerifiable, false);
    }

    public Boolean getPointcutPatternVerifiable() {
        return this.pointcutPatternVerifiable;
    }

    public void setPointcutPatternVerifiable(boolean pointcutPatternVerifiable) {
        this.pointcutPatternVerifiable = pointcutPatternVerifiable;
    }

    public String getDefaultTemplateEngineBean() {
        return this.defaultTemplateEngineBean;
    }

    public void setDefaultTemplateEngineBean(String defaultTemplateEngineBean) {
        this.defaultTemplateEngineBean = defaultTemplateEngineBean;
    }

    public String getDefaultSchedulerBean() {
        return this.defaultSchedulerBean;
    }

    public void setDefaultSchedulerBean(String defaultSchedulerBean) {
        this.defaultSchedulerBean = defaultSchedulerBean;
    }

    public void apply(@NonNull Map<DefaultSettingType, String> settings) {
        if (settings.get((Object)DefaultSettingType.TRANSLET_NAME_PREFIX) != null) {
            this.setTransletNamePrefix(settings.get((Object)DefaultSettingType.TRANSLET_NAME_PREFIX));
        }
        if (settings.get((Object)DefaultSettingType.TRANSLET_NAME_SUFFIX) != null) {
            this.setTransletNameSuffix(settings.get((Object)DefaultSettingType.TRANSLET_NAME_SUFFIX));
        }
        if (settings.get((Object)DefaultSettingType.POINTCUT_PATTERN_VERIFIABLE) != null) {
            this.pointcutPatternVerifiable = settings.get((Object)DefaultSettingType.POINTCUT_PATTERN_VERIFIABLE) == null || Boolean.parseBoolean(settings.get((Object)DefaultSettingType.POINTCUT_PATTERN_VERIFIABLE));
        }
        if (settings.get((Object)DefaultSettingType.DEFAULT_TEMPLATE_ENGINE_BEAN) != null) {
            this.defaultTemplateEngineBean = settings.get((Object)DefaultSettingType.DEFAULT_TEMPLATE_ENGINE_BEAN);
        }
        if (settings.get((Object)DefaultSettingType.DEFAULT_SCHEDULER_BEAN) != null) {
            this.defaultSchedulerBean = settings.get((Object)DefaultSettingType.DEFAULT_SCHEDULER_BEAN);
        }
    }
}

