/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.context.rule.converter;

import com.aspectran.core.activity.process.ActionList;
import com.aspectran.core.activity.process.ContentList;
import com.aspectran.core.activity.process.action.ChooseAction;
import com.aspectran.core.activity.process.action.EchoAction;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.activity.process.action.HeaderAction;
import com.aspectran.core.activity.process.action.IncludeAction;
import com.aspectran.core.activity.process.action.InvokeAction;
import com.aspectran.core.activity.response.ForwardResponse;
import com.aspectran.core.activity.response.RedirectResponse;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.ResponseMap;
import com.aspectran.core.activity.response.dispatch.DispatchResponse;
import com.aspectran.core.activity.response.transform.TransformResponse;
import com.aspectran.core.context.rule.AppendRule;
import com.aspectran.core.context.rule.AspectAdviceRule;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.ChooseRule;
import com.aspectran.core.context.rule.ChooseWhenRule;
import com.aspectran.core.context.rule.DescriptionRule;
import com.aspectran.core.context.rule.DispatchRule;
import com.aspectran.core.context.rule.EchoActionRule;
import com.aspectran.core.context.rule.EnvironmentRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.ExceptionThrownRule;
import com.aspectran.core.context.rule.ForwardRule;
import com.aspectran.core.context.rule.HeaderActionRule;
import com.aspectran.core.context.rule.IncludeActionRule;
import com.aspectran.core.context.rule.InvokeActionRule;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.RedirectRule;
import com.aspectran.core.context.rule.RequestRule;
import com.aspectran.core.context.rule.ResponseRule;
import com.aspectran.core.context.rule.ScheduleRule;
import com.aspectran.core.context.rule.ScheduledJobRule;
import com.aspectran.core.context.rule.TemplateRule;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.appender.RuleAppender;
import com.aspectran.core.context.rule.assistant.ActivityRuleAssistant;
import com.aspectran.core.context.rule.assistant.AssistantLocal;
import com.aspectran.core.context.rule.assistant.DefaultSettings;
import com.aspectran.core.context.rule.params.ActionParameters;
import com.aspectran.core.context.rule.params.AdviceActionParameters;
import com.aspectran.core.context.rule.params.AdviceParameters;
import com.aspectran.core.context.rule.params.AppendParameters;
import com.aspectran.core.context.rule.params.AspectParameters;
import com.aspectran.core.context.rule.params.AspectranParameters;
import com.aspectran.core.context.rule.params.BeanParameters;
import com.aspectran.core.context.rule.params.ChooseWhenParameters;
import com.aspectran.core.context.rule.params.ContentParameters;
import com.aspectran.core.context.rule.params.ContentsParameters;
import com.aspectran.core.context.rule.params.DescriptionParameters;
import com.aspectran.core.context.rule.params.DispatchParameters;
import com.aspectran.core.context.rule.params.EntryParameters;
import com.aspectran.core.context.rule.params.EnvironmentParameters;
import com.aspectran.core.context.rule.params.ExceptionParameters;
import com.aspectran.core.context.rule.params.ExceptionThrownParameters;
import com.aspectran.core.context.rule.params.ForwardParameters;
import com.aspectran.core.context.rule.params.ItemHolderParameters;
import com.aspectran.core.context.rule.params.ItemParameters;
import com.aspectran.core.context.rule.params.JoinpointParameters;
import com.aspectran.core.context.rule.params.RedirectParameters;
import com.aspectran.core.context.rule.params.RequestParameters;
import com.aspectran.core.context.rule.params.ResponseParameters;
import com.aspectran.core.context.rule.params.RootParameters;
import com.aspectran.core.context.rule.params.ScheduleParameters;
import com.aspectran.core.context.rule.params.ScheduledJobParameters;
import com.aspectran.core.context.rule.params.SchedulerParameters;
import com.aspectran.core.context.rule.params.SettingsParameters;
import com.aspectran.core.context.rule.params.TemplateParameters;
import com.aspectran.core.context.rule.params.TransformParameters;
import com.aspectran.core.context.rule.params.TransletParameters;
import com.aspectran.core.context.rule.params.TriggerExpressionParameters;
import com.aspectran.core.context.rule.params.TriggerParameters;
import com.aspectran.core.context.rule.params.TypeAliasesParameters;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.core.context.rule.type.AspectAdviceType;
import com.aspectran.core.context.rule.type.DefaultSettingType;
import com.aspectran.core.context.rule.type.ItemType;
import com.aspectran.core.context.rule.type.ItemValueType;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.context.rule.type.ResponseType;
import com.aspectran.core.context.rule.type.ScopeType;
import com.aspectran.core.context.rule.type.TextStyleType;
import com.aspectran.core.context.rule.util.TextStyler;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.apon.AbstractParameters;
import com.aspectran.utils.apon.Parameter;
import com.aspectran.utils.apon.ParameterKey;
import com.aspectran.utils.apon.Parameters;
import com.aspectran.utils.apon.VariableParameters;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class RulesToParameters {
    private RulesToParameters() {
    }

    @NonNull
    public static RootParameters toRootParameters(ActivityRuleAssistant assistant) {
        RootParameters rootParameters = new RootParameters();
        rootParameters.putValue(RootParameters.aspectran, (Object)RulesToParameters.toAspectranParameters(assistant));
        return rootParameters;
    }

    @NonNull
    private static AspectranParameters toAspectranParameters(@NonNull ActivityRuleAssistant assistant) {
        AbstractParameters ps;
        List<EnvironmentRule> environmentRules;
        AspectranParameters aspectranParameters = new AspectranParameters();
        AssistantLocal assistantLocal = assistant.getAssistantLocal();
        if (assistantLocal.getDescriptionRule() != null) {
            RulesToParameters.toDescriptionParameters(assistantLocal.getDescriptionRule(), aspectranParameters, AspectranParameters.description);
        }
        SettingsParameters settingsParameters = RulesToParameters.toDefaultSettings(assistantLocal);
        aspectranParameters.putValueIfNotNull(AspectranParameters.settings, (Object)settingsParameters);
        Map<String, String> typeAliases = assistant.getTypeAliases();
        if (!typeAliases.isEmpty()) {
            TypeAliasesParameters typeAliasesParameters = (TypeAliasesParameters)aspectranParameters.newParameters(AspectranParameters.typeAliases);
            for (Map.Entry entry : typeAliases.entrySet()) {
                typeAliasesParameters.putTypeAlias((String)entry.getKey(), entry.getValue());
            }
        }
        if (!(environmentRules = assistant.getEnvironmentRules()).isEmpty()) {
            for (EnvironmentRule environmentRule : environmentRules) {
                ps = RulesToParameters.toEnvironmentParameters(environmentRule);
                aspectranParameters.putValue(AspectranParameters.environment, (Object)ps);
            }
        }
        for (AspectRule aspectRule : assistant.getAspectRules()) {
            ps = RulesToParameters.toAspectParameters(aspectRule);
            aspectranParameters.putValue(AspectranParameters.aspect, (Object)ps);
        }
        for (BeanRule beanRule : assistant.getBeanRules()) {
            ps = RulesToParameters.toBeanParameters(beanRule);
            aspectranParameters.putValue(AspectranParameters.bean, (Object)ps);
        }
        for (ScheduleRule scheduleRule : assistant.getScheduleRules()) {
            ps = RulesToParameters.toScheduleParameters(scheduleRule);
            aspectranParameters.putValue(AspectranParameters.schedule, (Object)ps);
        }
        for (TransletRule transletRule : assistant.getTransletRules()) {
            ps = RulesToParameters.toTransletParameters(transletRule);
            aspectranParameters.putValue(AspectranParameters.translet, (Object)ps);
        }
        for (TemplateRule templateRule : assistant.getTemplateRules()) {
            ps = RulesToParameters.toTemplateParameters(templateRule);
            aspectranParameters.putValue(AspectranParameters.template, (Object)ps);
        }
        List<RuleAppender> appenders = assistant.getRuleAppendHandler().getPendingList();
        if (appenders != null) {
            for (RuleAppender appender : appenders) {
                AppendParameters ps2 = RulesToParameters.toAppendParameters(appender);
                aspectranParameters.putValue(AspectranParameters.append, (Object)ps2);
            }
        }
        return aspectranParameters;
    }

    public static void toDescriptionParameters(DescriptionRule descriptionRule, Parameters parameters, ParameterKey key) {
        if (descriptionRule == null) {
            throw new IllegalArgumentException("descriptionRule must not be null");
        }
        if (descriptionRule.getCandidates() != null) {
            for (DescriptionRule dr : descriptionRule.getCandidates()) {
                DescriptionParameters descriptionParameters = new DescriptionParameters(dr);
                parameters.putValue(key, (Object)descriptionParameters);
            }
        } else {
            DescriptionParameters descriptionParameters = new DescriptionParameters(descriptionRule);
            parameters.putValue(key, (Object)descriptionParameters);
        }
    }

    @Nullable
    private static SettingsParameters toDefaultSettings(@NonNull AssistantLocal assistantLocal) {
        DefaultSettings defaultSettings = assistantLocal.getDefaultSettings();
        if (defaultSettings != null) {
            SettingsParameters settingsParameters = new SettingsParameters();
            if (defaultSettings.getTransletNamePrefix() != null) {
                settingsParameters.putSetting(DefaultSettingType.TRANSLET_NAME_PREFIX.toString(), defaultSettings.getTransletNamePrefix());
            }
            if (defaultSettings.getTransletNameSuffix() != null) {
                settingsParameters.putSetting(DefaultSettingType.TRANSLET_NAME_SUFFIX.toString(), defaultSettings.getTransletNameSuffix());
            }
            if (defaultSettings.getPointcutPatternVerifiable() != null) {
                settingsParameters.putSetting(DefaultSettingType.POINTCUT_PATTERN_VERIFIABLE.toString(), defaultSettings.getPointcutPatternVerifiable());
            }
            if (defaultSettings.getDefaultTemplateEngineBean() != null) {
                settingsParameters.putSetting(DefaultSettingType.DEFAULT_TEMPLATE_ENGINE_BEAN.toString(), defaultSettings.getDefaultTemplateEngineBean());
            }
            if (defaultSettings.getDefaultSchedulerBean() != null) {
                settingsParameters.putSetting(DefaultSettingType.DEFAULT_SCHEDULER_BEAN.toString(), defaultSettings.getDefaultSchedulerBean());
            }
            return settingsParameters;
        }
        return null;
    }

    @NonNull
    private static AppendParameters toAppendParameters(@NonNull RuleAppender appender) {
        AppendRule appendRule = appender.getAppendRule();
        if (appendRule == null) {
            throw new IllegalArgumentException("Every appender except Root Appender requires an AppendRule");
        }
        return RulesToParameters.toAppendParameters(appendRule);
    }

    @NonNull
    public static AppendParameters toAppendParameters(AppendRule appendRule) {
        if (appendRule == null) {
            throw new IllegalArgumentException("appendRule must not be null");
        }
        AppendParameters appendParameters = new AppendParameters();
        appendParameters.putValueIfNotNull(AppendParameters.file, (Object)appendRule.getFile());
        appendParameters.putValueIfNotNull(AppendParameters.resource, (Object)appendRule.getResource());
        appendParameters.putValueIfNotNull(AppendParameters.url, (Object)appendRule.getUrl());
        appendParameters.putValueIfNotNull(AppendParameters.format, (Object)appendRule.getFormat());
        appendParameters.putValueIfNotNull(AppendParameters.profile, (Object)appendRule.getProfile());
        appendParameters.putValueIfNotNull(AppendParameters.aspectran, (Object)appendRule.getAspectranParameters());
        return appendParameters;
    }

    @NonNull
    public static EnvironmentParameters toEnvironmentParameters(EnvironmentRule environmentRule) {
        if (environmentRule == null) {
            throw new IllegalArgumentException("environmentRule must not be null");
        }
        EnvironmentParameters environmentParameters = new EnvironmentParameters();
        if (environmentRule.getDescriptionRule() != null) {
            RulesToParameters.toDescriptionParameters(environmentRule.getDescriptionRule(), environmentParameters, EnvironmentParameters.description);
        }
        environmentParameters.putValueIfNotNull(EnvironmentParameters.profile, (Object)environmentRule.getProfile());
        if (environmentRule.getPropertyItemRuleMapList() != null) {
            for (ItemRuleMap propertyItemRuleMap : environmentRule.getPropertyItemRuleMapList()) {
                RulesToParameters.toItemHolderParameters(propertyItemRuleMap, environmentParameters, EnvironmentParameters.properties);
            }
        }
        return environmentParameters;
    }

    @NonNull
    public static AspectParameters toAspectParameters(AspectRule aspectRule) {
        ExceptionRule exceptionRule;
        Map<String, Object> settings;
        if (aspectRule == null) {
            throw new IllegalArgumentException("aspectRule must not be null");
        }
        AspectParameters aspectParameters = new AspectParameters();
        if (aspectRule.getDescriptionRule() != null) {
            RulesToParameters.toDescriptionParameters(aspectRule.getDescriptionRule(), aspectParameters, AspectParameters.description);
        }
        aspectParameters.putValueIfNotNull(AspectParameters.id, (Object)aspectRule.getId());
        if (aspectRule.getOrder() != Integer.MAX_VALUE) {
            aspectParameters.putValueIfNotNull(AspectParameters.order, (Object)aspectRule.getOrder());
        }
        aspectParameters.putValueIfNotNull(AspectParameters.isolated, (Object)aspectRule.getIsolated());
        aspectParameters.putValueIfNotNull(AspectParameters.disabled, (Object)aspectRule.getDisabled());
        if (aspectRule.getJoinpointRule() != null) {
            JoinpointParameters joinpointParameters = aspectRule.getJoinpointRule().getJoinpointParameters();
            if (joinpointParameters != null) {
                joinpointParameters.putValueIfNotNull(JoinpointParameters.target, (Object)aspectRule.getJoinpointTargetType());
                aspectParameters.putValue(AspectParameters.joinpoint, (Object)joinpointParameters);
            } else {
                joinpointParameters = (JoinpointParameters)aspectParameters.newParameters(AspectParameters.joinpoint);
                joinpointParameters.putValueIfNotNull(JoinpointParameters.target, (Object)aspectRule.getJoinpointTargetType());
            }
        }
        if (aspectRule.getSettingsAdviceRule() != null && (settings = aspectRule.getSettingsAdviceRule().getSettings()) != null) {
            SettingsParameters settingsParameters = (SettingsParameters)aspectParameters.newParameters(AspectParameters.settings);
            for (Map.Entry<String, Object> entry : settings.entrySet()) {
                settingsParameters.putSetting(entry.getKey(), entry.getValue());
            }
        }
        if (aspectRule.getAspectAdviceRuleList() != null) {
            AdviceParameters adviceParameters = (AdviceParameters)aspectParameters.newParameters(AspectParameters.advice);
            adviceParameters.putValueIfNotNull(AdviceParameters.bean, (Object)aspectRule.getAdviceBeanId());
            for (AspectAdviceRule aspectAdviceRule : aspectRule.getAspectAdviceRuleList()) {
                AdviceActionParameters adviceActionParameters;
                if (aspectAdviceRule.getAspectAdviceType() == AspectAdviceType.BEFORE) {
                    adviceActionParameters = (AdviceActionParameters)adviceParameters.newParameters(AdviceParameters.beforeAdvice);
                    if (aspectAdviceRule.getAdviceAction() == null) continue;
                    RulesToParameters.toActionParameters(aspectAdviceRule.getAdviceAction(), (Parameters)adviceActionParameters);
                    continue;
                }
                if (aspectAdviceRule.getAspectAdviceType() == AspectAdviceType.AFTER) {
                    adviceActionParameters = (AdviceActionParameters)adviceParameters.newParameters(AdviceParameters.afterAdvice);
                    if (aspectAdviceRule.getAdviceAction() == null) continue;
                    RulesToParameters.toActionParameters(aspectAdviceRule.getAdviceAction(), (Parameters)adviceActionParameters);
                    continue;
                }
                if (aspectAdviceRule.getAspectAdviceType() == AspectAdviceType.AROUND) {
                    adviceActionParameters = (AdviceActionParameters)adviceParameters.newParameters(AdviceParameters.aroundAdvice);
                    if (aspectAdviceRule.getAdviceAction() == null) continue;
                    RulesToParameters.toActionParameters(aspectAdviceRule.getAdviceAction(), (Parameters)adviceActionParameters);
                    continue;
                }
                if (aspectAdviceRule.getAspectAdviceType() != AspectAdviceType.FINALLY) continue;
                adviceActionParameters = (AdviceActionParameters)adviceParameters.newParameters(AdviceParameters.finallyAdvice);
                if (aspectAdviceRule.getExceptionThrownRule() != null) {
                    adviceActionParameters.putValue(AdviceActionParameters.thrown, (Object)RulesToParameters.toExceptionThrownParameters(aspectAdviceRule.getExceptionThrownRule()));
                }
                if (aspectAdviceRule.getAdviceAction() == null) continue;
                RulesToParameters.toActionParameters(aspectAdviceRule.getAdviceAction(), (Parameters)adviceActionParameters);
            }
        }
        if ((exceptionRule = aspectRule.getExceptionRule()) != null) {
            ExceptionParameters exceptionParameters = (ExceptionParameters)aspectParameters.touchParameters(AspectParameters.exception);
            if (exceptionRule.getDescriptionRule() != null) {
                RulesToParameters.toDescriptionParameters(exceptionRule.getDescriptionRule(), exceptionParameters, ExceptionParameters.description);
            }
            for (ExceptionThrownRule etr : exceptionRule.getExceptionThrownRuleList()) {
                exceptionParameters.putValue(ExceptionParameters.thrown, (Object)RulesToParameters.toExceptionThrownParameters(etr));
            }
        }
        return aspectParameters;
    }

    @NonNull
    public static BeanParameters toBeanParameters(BeanRule beanRule) {
        ItemRuleMap propertyItemRuleMap;
        if (beanRule == null) {
            throw new IllegalArgumentException("beanRule must not be null");
        }
        BeanParameters beanParameters = new BeanParameters();
        if (beanRule.getDescriptionRule() != null) {
            RulesToParameters.toDescriptionParameters(beanRule.getDescriptionRule(), beanParameters, BeanParameters.description);
        }
        beanParameters.putValueIfNotNull(BeanParameters.id, (Object)beanRule.getId());
        beanParameters.putValueIfNotNull(BeanParameters.className, (Object)beanRule.getClassName());
        beanParameters.putValueIfNotNull(BeanParameters.scan, (Object)beanRule.getScanPattern());
        beanParameters.putValueIfNotNull(BeanParameters.mask, (Object)beanRule.getMaskPattern());
        if (beanRule.getSingleton() == Boolean.TRUE && beanRule.getScopeType() == ScopeType.SINGLETON) {
            beanParameters.putValue(BeanParameters.singleton, (Object)beanRule.getSingleton());
        } else if (beanRule.getScopeType() != null) {
            beanParameters.putValue(BeanParameters.scope, (Object)beanRule.getScopeType().toString());
        }
        beanParameters.putValueIfNotNull(BeanParameters.factoryBean, (Object)beanRule.getFactoryBeanId());
        beanParameters.putValueIfNotNull(BeanParameters.factoryMethod, (Object)beanRule.getFactoryMethodName());
        beanParameters.putValueIfNotNull(BeanParameters.initMethod, (Object)beanRule.getInitMethodName());
        beanParameters.putValueIfNotNull(BeanParameters.destroyMethod, (Object)beanRule.getDestroyMethodName());
        beanParameters.putValueIfNotNull(BeanParameters.lazyInit, (Object)beanRule.getLazyInit());
        beanParameters.putValueIfNotNull(BeanParameters.important, (Object)beanRule.getImportant());
        beanParameters.putValueIfNotNull(BeanParameters.filter, (Object)beanRule.getFilterParameters());
        ItemRuleMap constructorArgumentItemRuleMap = beanRule.getConstructorArgumentItemRuleMap();
        if (constructorArgumentItemRuleMap != null) {
            RulesToParameters.toItemHolderParameters(constructorArgumentItemRuleMap, beanParameters, BeanParameters.arguments);
        }
        if ((propertyItemRuleMap = beanRule.getPropertyItemRuleMap()) != null) {
            RulesToParameters.toItemHolderParameters(propertyItemRuleMap, beanParameters, BeanParameters.properties);
        }
        return beanParameters;
    }

    @NonNull
    public static ScheduleParameters toScheduleParameters(ScheduleRule scheduleRule) {
        return RulesToParameters.toScheduleParameters(scheduleRule, null);
    }

    @NonNull
    public static ScheduleParameters toScheduleParameters(ScheduleRule scheduleRule, ScheduledJobRule scheduledJobRule) {
        if (scheduleRule == null) {
            throw new IllegalArgumentException("scheduleRule must not be null");
        }
        ScheduleParameters scheduleParameters = new ScheduleParameters();
        if (scheduleRule.getDescriptionRule() != null) {
            RulesToParameters.toDescriptionParameters(scheduleRule.getDescriptionRule(), scheduleParameters, ScheduleParameters.description);
        }
        scheduleParameters.putValueIfNotNull(ScheduleParameters.id, (Object)scheduleRule.getId());
        SchedulerParameters schedulerParameters = (SchedulerParameters)scheduleParameters.newParameters(ScheduleParameters.scheduler);
        schedulerParameters.putValueIfNotNull(SchedulerParameters.bean, (Object)scheduleRule.getSchedulerBeanId());
        TriggerExpressionParameters expressionParameters = scheduleRule.getTriggerExpressionParameters();
        if (expressionParameters != null && scheduleRule.getTriggerType() != null) {
            TriggerParameters triggerParameters = (TriggerParameters)schedulerParameters.newParameters(SchedulerParameters.trigger);
            triggerParameters.putValue(TriggerParameters.type, (Object)scheduleRule.getTriggerType());
            triggerParameters.putValue(TriggerParameters.expression, (Object)expressionParameters);
        }
        if (scheduledJobRule == null) {
            List<ScheduledJobRule> scheduledJobRuleList = scheduleRule.getScheduledJobRuleList();
            if (scheduledJobRuleList != null) {
                for (ScheduledJobRule jobRule : scheduledJobRuleList) {
                    scheduleParameters.putValue(ScheduleParameters.job, (Object)RulesToParameters.toScheduledJobParameters(jobRule));
                }
            }
        } else {
            scheduleParameters.putValue(ScheduleParameters.job, (Object)RulesToParameters.toScheduledJobParameters(scheduledJobRule));
        }
        return scheduleParameters;
    }

    @NonNull
    public static ScheduledJobParameters toScheduledJobParameters(ScheduledJobRule scheduledJobRule) {
        if (scheduledJobRule == null) {
            throw new IllegalArgumentException("scheduledJobRule must not be null");
        }
        ScheduledJobParameters scheduledJobParameters = new ScheduledJobParameters();
        scheduledJobParameters.putValue(ScheduledJobParameters.translet, (Object)scheduledJobRule.getTransletName());
        scheduledJobParameters.putValueIfNotNull(ScheduledJobParameters.disabled, (Object)scheduledJobRule.getDisabled());
        return scheduledJobParameters;
    }

    @NonNull
    public static TransletParameters toTransletParameters(TransletRule transletRule) {
        ExceptionRule exceptionRule;
        List<ResponseRule> responseRuleList;
        ContentList contentList;
        RequestRule requestRule;
        if (transletRule == null) {
            throw new IllegalArgumentException("transletRule must not be null");
        }
        TransletParameters transletParameters = new TransletParameters();
        if (transletRule.getDescriptionRule() != null) {
            RulesToParameters.toDescriptionParameters(transletRule.getDescriptionRule(), transletParameters, TransletParameters.description);
        }
        transletParameters.putValueIfNotNull(TransletParameters.name, (Object)transletRule.getName());
        transletParameters.putValueIfNotNull(TransletParameters.scan, (Object)transletRule.getScanPath());
        transletParameters.putValueIfNotNull(TransletParameters.mask, (Object)transletRule.getMaskPattern());
        if (transletRule.getAllowedMethods() != null) {
            transletParameters.putValue(TransletParameters.method, (Object)MethodType.stringify(transletRule.getAllowedMethods()));
        }
        if ((requestRule = transletRule.getRequestRule()) != null) {
            if (requestRule.isExplicit()) {
                Object attributeItemRuleMap;
                RequestParameters requestParameters = (RequestParameters)transletParameters.newParameters(TransletParameters.request);
                requestParameters.putValueIfNotNull(RequestParameters.method, (Object)requestRule.getAllowedMethod());
                requestParameters.putValueIfNotNull(RequestParameters.encoding, (Object)requestRule.getEncoding());
                ItemRuleMap parameterItemRuleMap = requestRule.getParameterItemRuleMap();
                if (parameterItemRuleMap != null) {
                    RulesToParameters.toItemHolderParameters(parameterItemRuleMap, requestParameters, RequestParameters.parameters);
                }
                if ((attributeItemRuleMap = requestRule.getAttributeItemRuleMap()) != null) {
                    RulesToParameters.toItemHolderParameters((ItemRuleMap)attributeItemRuleMap, requestParameters, RequestParameters.attributes);
                }
            } else {
                ItemRuleMap attributeItemRuleMap;
                ItemRuleMap parameterItemRuleMap = requestRule.getParameterItemRuleMap();
                if (parameterItemRuleMap != null) {
                    RulesToParameters.toItemHolderParameters(parameterItemRuleMap, transletParameters, TransletParameters.parameters);
                }
                if ((attributeItemRuleMap = requestRule.getAttributeItemRuleMap()) != null) {
                    RulesToParameters.toItemHolderParameters(attributeItemRuleMap, transletParameters, TransletParameters.attributes);
                }
            }
        }
        if ((contentList = transletRule.getContentList()) != null) {
            if (contentList.isExplicit()) {
                ContentsParameters contentsParameters = (ContentsParameters)transletParameters.newParameters(TransletParameters.contents);
                contentsParameters.putValueIfNotNull(ContentsParameters.name, (Object)contentList.getName());
                for (ActionList actionList : contentList) {
                    ContentParameters contentParameters = (ContentParameters)contentsParameters.newParameters(ContentsParameters.content);
                    contentParameters.putValueIfNotNull(ContentParameters.name, (Object)actionList.getName());
                    RulesToParameters.toActionParameters(actionList, (Parameters)contentParameters);
                }
            } else {
                for (Object actionList : contentList) {
                    if (((ActionList)actionList).isExplicit()) {
                        ContentParameters contentParameters = (ContentParameters)transletParameters.newParameters(TransletParameters.content);
                        contentParameters.putValueIfNotNull(ContentParameters.name, (Object)((ActionList)actionList).getName());
                        RulesToParameters.toActionParameters((ActionList)actionList, (Parameters)contentParameters);
                        continue;
                    }
                    RulesToParameters.toActionParameters((ActionList)actionList, (Parameters)transletParameters);
                }
            }
        }
        if ((responseRuleList = transletRule.getResponseRuleList()) != null) {
            for (ResponseRule responseRule : responseRuleList) {
                if (responseRule == null) continue;
                transletParameters.putValue(TransletParameters.response, (Object)RulesToParameters.toResponseParameters(responseRule));
            }
        } else {
            ResponseRule responseRule = transletRule.getResponseRule();
            if (responseRule != null) {
                if (responseRule.isExplicit()) {
                    transletParameters.putValue(TransletParameters.response, (Object)RulesToParameters.toResponseParameters(responseRule));
                } else {
                    Response response = responseRule.getResponse();
                    if (response != null) {
                        if (response.getResponseType() == ResponseType.TRANSFORM) {
                            TransformResponse transformResponse = (TransformResponse)response;
                            transletParameters.putValue(TransletParameters.transform, (Object)RulesToParameters.toTransformParameters(transformResponse.getTransformRule()));
                        } else if (response.getResponseType() == ResponseType.DISPATCH) {
                            DispatchResponse dispatchResponse = (DispatchResponse)response;
                            transletParameters.putValue(TransletParameters.dispatch, (Object)RulesToParameters.toDispatchParameters(dispatchResponse.getDispatchRule()));
                        } else if (response.getResponseType() == ResponseType.FORWARD) {
                            ForwardResponse forwardResponse = (ForwardResponse)response;
                            transletParameters.putValue(TransletParameters.forward, (Object)RulesToParameters.toForwardParameters(forwardResponse.getForwardRule()));
                        } else if (response.getResponseType() == ResponseType.REDIRECT) {
                            RedirectResponse redirectResponse = (RedirectResponse)response;
                            transletParameters.putValue(TransletParameters.redirect, (Object)RulesToParameters.toRedirectParameters(redirectResponse.getRedirectRule()));
                        }
                    }
                }
            }
        }
        if ((exceptionRule = transletRule.getExceptionRule()) != null) {
            ExceptionParameters exceptionParameters = (ExceptionParameters)transletParameters.touchParameters(TransletParameters.exception);
            if (exceptionRule.getDescriptionRule() != null) {
                RulesToParameters.toDescriptionParameters(exceptionRule.getDescriptionRule(), exceptionParameters, ExceptionParameters.description);
            }
            for (ExceptionThrownRule etr : exceptionRule.getExceptionThrownRuleList()) {
                exceptionParameters.putValue(ExceptionParameters.thrown, (Object)RulesToParameters.toExceptionThrownParameters(etr));
            }
        }
        return transletParameters;
    }

    @NonNull
    public static ExceptionThrownParameters toExceptionThrownParameters(ExceptionThrownRule exceptionThrownRule) {
        ResponseMap responseMap;
        if (exceptionThrownRule == null) {
            throw new IllegalArgumentException("exceptionThrownRule must not be null");
        }
        ExceptionThrownParameters exceptionThrownParameters = new ExceptionThrownParameters();
        if (exceptionThrownRule.getExceptionTypes() != null) {
            for (String exceptionType : exceptionThrownRule.getExceptionTypes()) {
                exceptionThrownParameters.putValue(ExceptionThrownParameters.type, (Object)exceptionType);
            }
        }
        if (exceptionThrownRule.getAction() != null) {
            RulesToParameters.toActionParameters(exceptionThrownRule.getAction(), (Parameters)exceptionThrownParameters);
        }
        if ((responseMap = exceptionThrownRule.getResponseMap()) != null) {
            for (Response response : responseMap) {
                if (response.getResponseType() == ResponseType.TRANSFORM) {
                    TransformResponse transformResponse = (TransformResponse)response;
                    exceptionThrownParameters.putValue(ExceptionThrownParameters.transform, (Object)RulesToParameters.toTransformParameters(transformResponse.getTransformRule()));
                    continue;
                }
                if (response.getResponseType() == ResponseType.DISPATCH) {
                    DispatchResponse dispatchResponse = (DispatchResponse)response;
                    exceptionThrownParameters.putValue(ExceptionThrownParameters.dispatch, (Object)RulesToParameters.toDispatchParameters(dispatchResponse.getDispatchRule()));
                    continue;
                }
                if (response.getResponseType() == ResponseType.REDIRECT) {
                    RedirectResponse redirectResponse = (RedirectResponse)response;
                    exceptionThrownParameters.putValue(ExceptionThrownParameters.redirect, (Object)RulesToParameters.toRedirectParameters(redirectResponse.getRedirectRule()));
                    continue;
                }
                if (response.getResponseType() != ResponseType.FORWARD) continue;
                throw new IllegalArgumentException("Cannot apply the forward response rule to the exception thrown rule");
            }
        }
        return exceptionThrownParameters;
    }

    @NonNull
    public static ResponseParameters toResponseParameters(ResponseRule responseRule) {
        if (responseRule == null) {
            throw new IllegalArgumentException("responseRule must not be null");
        }
        ResponseParameters responseParameters = new ResponseParameters();
        responseParameters.putValueIfNotNull(ResponseParameters.name, (Object)responseRule.getName());
        responseParameters.putValueIfNotNull(ResponseParameters.encoding, (Object)responseRule.getEncoding());
        ActionList actionList = responseRule.getActionList();
        if (actionList != null) {
            RulesToParameters.toActionParameters(actionList, (Parameters)responseParameters);
        }
        if (responseRule.getResponse() != null) {
            if (responseRule.getResponseType() == ResponseType.TRANSFORM) {
                TransformResponse transformResponse = (TransformResponse)responseRule.getResponse();
                responseParameters.putValue(ResponseParameters.transform, (Object)RulesToParameters.toTransformParameters(transformResponse.getTransformRule()));
            } else if (responseRule.getResponseType() == ResponseType.DISPATCH) {
                DispatchResponse dispatchResponse = (DispatchResponse)responseRule.getResponse();
                responseParameters.putValue(ResponseParameters.dispatch, (Object)RulesToParameters.toDispatchParameters(dispatchResponse.getDispatchRule()));
            } else if (responseRule.getResponseType() == ResponseType.FORWARD) {
                ForwardResponse forwardResponse = (ForwardResponse)responseRule.getResponse();
                responseParameters.putValue(ResponseParameters.forward, (Object)RulesToParameters.toForwardParameters(forwardResponse.getForwardRule()));
            } else if (responseRule.getResponseType() == ResponseType.REDIRECT) {
                RedirectResponse redirectResponse = (RedirectResponse)responseRule.getResponse();
                responseParameters.putValue(ResponseParameters.redirect, (Object)RulesToParameters.toRedirectParameters(redirectResponse.getRedirectRule()));
            }
        }
        return responseParameters;
    }

    @NonNull
    public static TransformParameters toTransformParameters(TransformRule transformRule) {
        if (transformRule == null) {
            throw new IllegalArgumentException("transformRule must not be null");
        }
        TransformParameters transformParameters = new TransformParameters();
        transformParameters.putValueIfNotNull(TransformParameters.format, (Object)transformRule.getFormatType());
        transformParameters.putValueIfNotNull(TransformParameters.contentType, (Object)transformRule.getContentType());
        transformParameters.putValueIfNotNull(TransformParameters.encoding, (Object)transformRule.getEncoding());
        transformParameters.putValueIfNotNull(TransformParameters.defaultResponse, (Object)transformRule.getDefaultResponse());
        transformParameters.putValueIfNotNull(TransformParameters.pretty, (Object)transformRule.getPretty());
        if (transformRule.getTemplateRule() != null) {
            transformParameters.putValue(TransformParameters.template, (Object)RulesToParameters.toTemplateParameters(transformRule.getTemplateRule()));
        }
        return transformParameters;
    }

    @NonNull
    public static DispatchParameters toDispatchParameters(DispatchRule dispatchRule) {
        if (dispatchRule == null) {
            throw new IllegalArgumentException("dispatchRule must not be null");
        }
        DispatchParameters dispatchParameters = new DispatchParameters();
        dispatchParameters.putValueIfNotNull(DispatchParameters.name, (Object)dispatchRule.getName());
        dispatchParameters.putValueIfNotNull(DispatchParameters.dispatcher, (Object)dispatchRule.getDispatcherName());
        dispatchParameters.putValueIfNotNull(DispatchParameters.contentType, (Object)dispatchRule.getContentType());
        dispatchParameters.putValueIfNotNull(DispatchParameters.encoding, (Object)dispatchRule.getEncoding());
        dispatchParameters.putValueIfNotNull(DispatchParameters.defaultResponse, (Object)dispatchRule.getDefaultResponse());
        return dispatchParameters;
    }

    @NonNull
    public static ForwardParameters toForwardParameters(ForwardRule forwardRule) {
        if (forwardRule == null) {
            throw new IllegalArgumentException("forwardRule must not be null");
        }
        ForwardParameters forwardParameters = new ForwardParameters();
        forwardParameters.putValueIfNotNull(ForwardParameters.contentType, (Object)forwardRule.getContentType());
        forwardParameters.putValueIfNotNull(ForwardParameters.translet, (Object)forwardRule.getTransletName());
        forwardParameters.putValueIfNotNull(ForwardParameters.defaultResponse, (Object)forwardRule.getDefaultResponse());
        ItemRuleMap attributeItemRuleMap = forwardRule.getAttributeItemRuleMap();
        if (attributeItemRuleMap != null) {
            RulesToParameters.toItemHolderParameters(attributeItemRuleMap, forwardParameters, ForwardParameters.attributes);
        }
        return forwardParameters;
    }

    @NonNull
    public static RedirectParameters toRedirectParameters(RedirectRule redirectRule) {
        if (redirectRule == null) {
            throw new IllegalArgumentException("redirectRule must not be null");
        }
        RedirectParameters redirectParameters = new RedirectParameters();
        redirectParameters.putValueIfNotNull(RedirectParameters.contentType, (Object)redirectRule.getContentType());
        redirectParameters.putValueIfNotNull(RedirectParameters.path, (Object)redirectRule.getPath());
        redirectParameters.putValueIfNotNull(RedirectParameters.encoding, (Object)redirectRule.getEncoding());
        redirectParameters.putValueIfNotNull(RedirectParameters.excludeNullParameters, (Object)redirectRule.getExcludeNullParameters());
        redirectParameters.putValueIfNotNull(RedirectParameters.excludeEmptyParameters, (Object)redirectRule.getExcludeEmptyParameters());
        redirectParameters.putValueIfNotNull(RedirectParameters.defaultResponse, (Object)redirectRule.getDefaultResponse());
        ItemRuleMap parameterItemRuleMap = redirectRule.getParameterItemRuleMap();
        if (parameterItemRuleMap != null) {
            RulesToParameters.toItemHolderParameters(parameterItemRuleMap, redirectParameters, RedirectParameters.parameters);
        }
        return redirectParameters;
    }

    @NonNull
    public static TemplateParameters toTemplateParameters(TemplateRule templateRule) {
        if (templateRule == null) {
            throw new IllegalArgumentException("templateRule must not be null");
        }
        TemplateParameters templateParameters = new TemplateParameters();
        templateParameters.putValueIfNotNull(TemplateParameters.id, (Object)templateRule.getId());
        templateParameters.putValueIfNotNull(TemplateParameters.engine, (Object)templateRule.getEngine());
        if (templateRule.getFile() != null) {
            templateParameters.putValueIfNotNull(TemplateParameters.file, (Object)templateRule.getFile());
        } else if (templateRule.getResource() != null) {
            templateParameters.putValueIfNotNull(TemplateParameters.resource, (Object)templateRule.getResource());
        } else if (templateRule.getUrl() != null) {
            templateParameters.putValueIfNotNull(TemplateParameters.url, (Object)templateRule.getUrl());
        } else if (templateRule.getName() != null) {
            templateParameters.putValueIfNotNull(TemplateParameters.name, (Object)templateRule.getName());
        } else {
            if (templateRule.getContent() != null) {
                if (templateRule.getTextStyle() == TextStyleType.APON) {
                    String content = TextStyler.stripAponStyle(templateRule.getContent());
                    templateParameters.putValue(TemplateParameters.content, (Object)content);
                } else {
                    templateParameters.putValue(TemplateParameters.content, (Object)templateRule.getContent());
                }
            } else {
                templateParameters.putValueIfNotNull(TemplateParameters.content, (Object)templateRule.getTemplateSource());
            }
            templateParameters.putValueIfNotNull(TemplateParameters.style, (Object)templateRule.getTextStyle());
        }
        templateParameters.putValueIfNotNull(TemplateParameters.contentType, (Object)templateRule.getContentType());
        templateParameters.putValueIfNotNull(TemplateParameters.encoding, (Object)templateRule.getEncoding());
        templateParameters.putValueIfNotNull(TemplateParameters.noCache, (Object)templateRule.getNoCache());
        return templateParameters;
    }

    @NonNull
    private static void toActionParameters(@NonNull ActionList actionList, Parameters parameters) {
        for (Executable action : actionList) {
            RulesToParameters.toActionParameters(action, parameters);
        }
    }

    private static void toActionParameters(@NonNull Executable action, Parameters parameters) {
        if (action.getActionType() == ActionType.INVOKE) {
            InvokeActionRule invokeActionRule = ((InvokeAction)action).getInvokeActionRule();
            if (invokeActionRule.getBeanId() != null) {
                parameters.putValue("action", (Object)RulesToParameters.toActionParameters(invokeActionRule));
            } else {
                parameters.putValue("invoke", (Object)RulesToParameters.toActionParameters(invokeActionRule));
            }
        } else if (action.getActionType() == ActionType.INCLUDE) {
            IncludeActionRule includeActionRule = ((IncludeAction)action).getIncludeActionRule();
            parameters.putValue("include", (Object)RulesToParameters.toActionParameters(includeActionRule));
        } else if (action.getActionType() == ActionType.ECHO) {
            EchoActionRule echoActionRule = ((EchoAction)action).getEchoActionRule();
            parameters.putValue("echo", (Object)RulesToParameters.toActionParameters(echoActionRule));
        } else if (action.getActionType() == ActionType.HEADER) {
            HeaderActionRule headerActionRule = ((HeaderAction)action).getHeaderActionRule();
            parameters.putValue("headers", (Object)RulesToParameters.toActionParameters(headerActionRule));
        } else if (action.getActionType() == ActionType.CHOOSE) {
            ChooseRule chooseRule = ((ChooseAction)action).getChooseRule();
            parameters.putValue("choose", (Object)RulesToParameters.toActionParameters(chooseRule));
        }
    }

    @NonNull
    public static ActionParameters toActionParameters(HeaderActionRule headerActionRule) {
        if (headerActionRule == null) {
            throw new IllegalArgumentException("headerActionRule must not be null");
        }
        ActionParameters actionParameters = new ActionParameters();
        actionParameters.putValueIfNotNull(ActionParameters.id, (Object)headerActionRule.getActionId());
        actionParameters.putValueIfNotNull(ActionParameters.hidden, (Object)headerActionRule.getHidden());
        ItemRuleMap headerItemRuleMap = headerActionRule.getHeaderItemRuleMap();
        if (headerItemRuleMap != null) {
            RulesToParameters.toItemParameters(headerItemRuleMap, actionParameters);
        }
        return actionParameters;
    }

    @NonNull
    public static ActionParameters toActionParameters(EchoActionRule echoActionRule) {
        if (echoActionRule == null) {
            throw new IllegalArgumentException("echoActionRule must not be null");
        }
        ActionParameters actionParameters = new ActionParameters();
        actionParameters.putValueIfNotNull(ActionParameters.id, (Object)echoActionRule.getActionId());
        actionParameters.putValueIfNotNull(ActionParameters.hidden, (Object)echoActionRule.getHidden());
        ItemRuleMap attributeItemRuleMap = echoActionRule.getEchoItemRuleMap();
        if (attributeItemRuleMap != null) {
            RulesToParameters.toItemParameters(attributeItemRuleMap, actionParameters);
        }
        return actionParameters;
    }

    @NonNull
    public static ActionParameters toActionParameters(InvokeActionRule invokeActionRule) {
        ItemRuleMap argumentItemRuleMap;
        if (invokeActionRule == null) {
            throw new IllegalArgumentException("invokeActionRule must not be null");
        }
        ActionParameters actionParameters = new ActionParameters();
        actionParameters.putValueIfNotNull(ActionParameters.id, (Object)invokeActionRule.getActionId());
        actionParameters.putValueIfNotNull(ActionParameters.bean, (Object)invokeActionRule.getBeanId());
        actionParameters.putValueIfNotNull(ActionParameters.method, (Object)invokeActionRule.getMethodName());
        actionParameters.putValueIfNotNull(ActionParameters.hidden, (Object)invokeActionRule.getHidden());
        ItemRuleMap propertyItemRuleMap = invokeActionRule.getPropertyItemRuleMap();
        if (propertyItemRuleMap != null) {
            RulesToParameters.toItemHolderParameters(propertyItemRuleMap, actionParameters, ActionParameters.properties);
        }
        if ((argumentItemRuleMap = invokeActionRule.getArgumentItemRuleMap()) != null) {
            RulesToParameters.toItemHolderParameters(argumentItemRuleMap, actionParameters, ActionParameters.arguments);
        }
        return actionParameters;
    }

    @NonNull
    public static ActionParameters toActionParameters(IncludeActionRule includeActionRule) {
        ItemRuleMap attributeItemRuleMap;
        if (includeActionRule == null) {
            throw new IllegalArgumentException("includeActionRule must not be null");
        }
        ActionParameters actionParameters = new ActionParameters();
        actionParameters.putValueIfNotNull(ActionParameters.id, (Object)includeActionRule.getActionId());
        actionParameters.putValueIfNotNull(ActionParameters.translet, (Object)includeActionRule.getTransletName());
        actionParameters.putValueIfNotNull(ActionParameters.method, (Object)includeActionRule.getMethodType());
        actionParameters.putValueIfNotNull(ActionParameters.hidden, (Object)includeActionRule.getHidden());
        ItemRuleMap parameterItemRuleMap = includeActionRule.getParameterItemRuleMap();
        if (parameterItemRuleMap != null) {
            RulesToParameters.toItemHolderParameters(parameterItemRuleMap, actionParameters, ActionParameters.parameters);
        }
        if ((attributeItemRuleMap = includeActionRule.getAttributeItemRuleMap()) != null) {
            RulesToParameters.toItemHolderParameters(attributeItemRuleMap, actionParameters, ActionParameters.attributes);
        }
        return actionParameters;
    }

    @NonNull
    private static ActionParameters toActionParameters(ChooseRule chooseRule) {
        if (chooseRule == null) {
            throw new IllegalArgumentException("chooseRule must not be null");
        }
        ActionParameters actionParameters = new ActionParameters();
        if (chooseRule.getChooseWhenRules() != null) {
            for (ChooseWhenRule chooseWhenRule : chooseRule.getChooseWhenRules()) {
                ChooseWhenParameters chooseWhenParameters = chooseWhenRule.getExpression() != null ? (ChooseWhenParameters)actionParameters.newParameters(ActionParameters.when) : (ChooseWhenParameters)actionParameters.newParameters(ActionParameters.otherwise);
                chooseWhenParameters.putValueIfNotNull(ChooseWhenParameters.test, (Object)chooseWhenRule.getExpression());
                if (chooseWhenRule.getResponse() == null) continue;
                Response response = chooseWhenRule.getResponse();
                if (response.getResponseType() == ResponseType.TRANSFORM) {
                    TransformResponse transformResponse = (TransformResponse)response;
                    TransformParameters transformParameters = RulesToParameters.toTransformParameters(transformResponse.getTransformRule());
                    chooseWhenParameters.putValue(ChooseWhenParameters.transform, (Object)transformParameters);
                    continue;
                }
                if (response.getResponseType() == ResponseType.DISPATCH) {
                    DispatchResponse dispatchResponse = (DispatchResponse)response;
                    DispatchParameters dispatchParameters = RulesToParameters.toDispatchParameters(dispatchResponse.getDispatchRule());
                    chooseWhenParameters.putValue(ChooseWhenParameters.dispatch, (Object)dispatchParameters);
                    continue;
                }
                if (response.getResponseType() == ResponseType.FORWARD) {
                    ForwardResponse forwardResponse = (ForwardResponse)response;
                    ForwardParameters forwardParameters = RulesToParameters.toForwardParameters(forwardResponse.getForwardRule());
                    chooseWhenParameters.putValue(ChooseWhenParameters.forward, (Object)forwardParameters);
                    continue;
                }
                if (response.getResponseType() != ResponseType.REDIRECT) continue;
                RedirectResponse redirectResponse = (RedirectResponse)response;
                RedirectParameters redirectParameters = RulesToParameters.toRedirectParameters(redirectResponse.getRedirectRule());
                chooseWhenParameters.putValue(ChooseWhenParameters.redirect, (Object)redirectParameters);
            }
        }
        return actionParameters;
    }

    private static void toItemHolderParameters(@NonNull ItemRuleMap itemRuleMap, Parameters parameters, ParameterKey key) {
        if (itemRuleMap.getCandidates() != null) {
            for (ItemRuleMap irm : itemRuleMap.getCandidates()) {
                parameters.putValue(key, (Object)RulesToParameters.toItemHolderParameters(irm));
            }
        } else {
            parameters.putValue(key, (Object)RulesToParameters.toItemHolderParameters(itemRuleMap));
        }
    }

    @NonNull
    public static ItemHolderParameters toItemHolderParameters(ItemRuleMap itemRuleMap) {
        if (itemRuleMap == null) {
            throw new IllegalArgumentException("itemRuleMap must not be null");
        }
        ItemHolderParameters itemHolderParameters = new ItemHolderParameters();
        itemHolderParameters.putValueIfNotNull(ItemHolderParameters.profile, (Object)itemRuleMap.getProfile());
        for (ItemRule itemRule : itemRuleMap.values()) {
            itemHolderParameters.addItemParameters(RulesToParameters.toItemParameters(itemRule));
        }
        return itemHolderParameters;
    }

    private static void toItemParameters(ItemRuleMap itemRuleMap, ActionParameters actionParameters) {
        if (itemRuleMap == null) {
            throw new IllegalArgumentException("itemRuleMap must not be null");
        }
        for (ItemRule itemRule : itemRuleMap.values()) {
            actionParameters.putValue(ActionParameters.item, (Object)RulesToParameters.toItemParameters(itemRule));
        }
    }

    @NonNull
    public static ItemParameters toItemParameters(ItemRule itemRule) {
        ItemParameters itemParameters;
        block12: {
            block15: {
                block13: {
                    block14: {
                        block11: {
                            if (itemRule == null) {
                                throw new IllegalArgumentException("itemRule must not be null");
                            }
                            itemParameters = new ItemParameters();
                            if (itemRule.getType() != null && itemRule.getType() != ItemType.SINGLE) {
                                itemParameters.putValue(ItemParameters.type, (Object)itemRule.getType());
                            }
                            if (!itemRule.isAutoNamed()) {
                                itemParameters.putValue(ItemParameters.name, (Object)itemRule.getName());
                            }
                            if (itemRule.getValueType() != ItemValueType.STRING && itemRule.getValueType() != ItemValueType.BEAN) {
                                itemParameters.putValueIfNotNull(ItemParameters.valueType, (Object)itemRule.getValueType());
                            }
                            itemParameters.putValueIfNotNull(ItemParameters.tokenize, (Object)itemRule.getTokenize());
                            itemParameters.putValueIfNotNull(ItemParameters.mandatory, (Object)itemRule.getMandatory());
                            itemParameters.putValueIfNotNull(ItemParameters.secret, (Object)itemRule.getSecret());
                            if (itemRule.getType() != ItemType.SINGLE) break block11;
                            if (itemRule.getValueType() == ItemValueType.BEAN) {
                                BeanRule beanRule = itemRule.getBeanRule();
                                BeanParameters beanParameters = RulesToParameters.toBeanParameters(beanRule);
                                itemParameters.putValueIfNotNull(ItemParameters.bean, (Object)beanParameters);
                            } else {
                                Object o = RulesToParameters.determineItemValue(itemRule.getValue(), itemRule.getValueType());
                                itemParameters.putValueIfNotNull(ItemParameters.value, o);
                            }
                            break block12;
                        }
                        if (!itemRule.isListableType()) break block13;
                        if (itemRule.getValueType() != ItemValueType.BEAN) break block14;
                        List<BeanRule> beanRuleList = itemRule.getBeanRuleList();
                        if (beanRuleList == null) break block12;
                        for (BeanRule beanRule : beanRuleList) {
                            BeanParameters beanParameters = RulesToParameters.toBeanParameters(beanRule);
                            itemParameters.putValueIfNotNull(ItemParameters.bean, (Object)beanParameters);
                        }
                        break block12;
                    }
                    List<String> valueList = itemRule.getValueList();
                    if (valueList == null || valueList.isEmpty()) break block12;
                    Parameter p = itemParameters.getParameter(ItemParameters.value);
                    p.arraylize();
                    for (String value : valueList) {
                        Object o = RulesToParameters.determineItemValue(value, itemRule.getValueType());
                        p.putValue(o);
                    }
                    break block12;
                }
                if (!itemRule.isMappableType()) break block12;
                if (itemRule.getValueType() != ItemValueType.BEAN) break block15;
                Map<String, BeanRule> beanRuleMap = itemRule.getBeanRuleMap();
                if (beanRuleMap == null) break block12;
                for (Map.Entry<String, BeanRule> entry : beanRuleMap.entrySet()) {
                    EntryParameters ps = (EntryParameters)itemParameters.newParameters(ItemParameters.entry);
                    BeanParameters beanParameters = RulesToParameters.toBeanParameters(entry.getValue());
                    ps.putValue(EntryParameters.name, (Object)entry.getKey());
                    ps.putValue(EntryParameters.bean, (Object)beanParameters);
                }
                break block12;
            }
            Map<String, String> valueMap = itemRule.getValueMap();
            if (valueMap != null) {
                for (Map.Entry<String, String> entry : valueMap.entrySet()) {
                    EntryParameters ps = (EntryParameters)itemParameters.newParameters(ItemParameters.entry);
                    Object o = RulesToParameters.determineItemValue(entry.getValue(), itemRule.getValueType());
                    ps.putValue(EntryParameters.name, (Object)entry.getKey());
                    ps.putValue(EntryParameters.value, o);
                }
            }
        }
        return itemParameters;
    }

    private static Object determineItemValue(String value, ItemValueType valueType) {
        if (value == null) {
            return null;
        }
        if (valueType == ItemValueType.PARAMETERS) {
            try {
                return new VariableParameters(value);
            }
            catch (IOException e) {
                throw new RuntimeException("Parameters can not be parsed", e);
            }
        }
        return value;
    }
}

